/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.opensha.commons.data.Location;
import org.opensha.sha.earthquake.observedEarthquake.CubeToObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.step.calc.RegionDefaults;

public class CubeToObsEqkRuptureChinaFormat
extends CubeToObsEqkRupture {
    private static Logger logger = Logger.getLogger(CubeToObsEqkRuptureChinaFormat.class);

    public CubeToObsEqkRuptureChinaFormat(String eventFile, Calendar startTime, Calendar endTime) throws FileNotFoundException, IOException {
        super(eventFile, startTime, endTime);
    }

    protected ObsEqkRupture readFile(String obsEqkEventstr) {
        obsEqkEventstr = obsEqkEventstr.trim();
        String yrStr = obsEqkEventstr.substring(0, 4);
        String monthStr = obsEqkEventstr.substring(4, 6);
        String dayStr = obsEqkEventstr.substring(6, 8);
        String hrStr = obsEqkEventstr.substring(8, 10);
        String minuteStr = obsEqkEventstr.substring(10, 12);
        String secStr = obsEqkEventstr.substring(12, 14);
        String latStr = obsEqkEventstr.substring(14, 20).trim();
        String lonStr = obsEqkEventstr.substring(20, 27).trim();
        String magStr = obsEqkEventstr.substring(27, 31);
        String dpthStr = obsEqkEventstr.substring(31, 34);
        String sourceStr = obsEqkEventstr.substring(34, 37);
        double lat = Double.parseDouble(latStr);
        double lon = Double.parseDouble(lonStr);
        double depth = Double.parseDouble(dpthStr);
        if (lat < RegionDefaults.searchLatMin || lat > RegionDefaults.searchLatMax) {
            return null;
        }
        if (lon < RegionDefaults.searchLongMin || lon > RegionDefaults.searchLongMax) {
            return null;
        }
        int year = Integer.parseInt(yrStr);
        int month = Integer.parseInt(monthStr.trim());
        int day = Integer.parseInt(dayStr.trim());
        int hour = Integer.parseInt(hrStr.trim());
        int min = Integer.parseInt(minuteStr.trim());
        int sec = Integer.parseInt(secStr.trim());
        GregorianCalendar originTime = new GregorianCalendar(TimeZone.getTimeZone("GMT+8:00"));
        originTime.set(year, month - 1, day, hour, min, sec);
        originTime.set(14, 0);
        double mag = Double.parseDouble(magStr);
        return new ObsEqkRupture(RegionDefaults.dateformater.format(originTime.getTime()), sourceStr, '0', originTime, 0.0, 0.0, 0.0, "", new Location(lat, lon, depth), mag);
    }

    public static void main(String[] args) {
        try {
            CubeToObsEqkRuptureChinaFormat cubeToRup = new CubeToObsEqkRuptureChinaFormat("data/china/china2ml_197001_201001.eqt", null, null);
            ObsEqkRupList rupList = cubeToRup.getAllObsEqkRupEvents();
            rupList.sortObsEqkRupListByOriginTime();
            int size = rupList.size();
            logger.info("rupList size " + size);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

