/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.opensha.commons.data.Location;
import org.opensha.sha.earthquake.observedEarthquake.CubeToObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.CubeToObsEqkRuptureChinaFormat;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.step.calc.RegionDefaults;

public class CubeToObsEqkRuptureCsepFormat
extends CubeToObsEqkRupture {
    private static Logger logger = Logger.getLogger(CubeToObsEqkRuptureChinaFormat.class);

    public CubeToObsEqkRuptureCsepFormat(String eventFile, Calendar startTime, Calendar endTime) throws FileNotFoundException, IOException {
        super(eventFile, startTime, endTime);
    }

    protected ObsEqkRupture readFile(String obsEqkEventstr) {
        obsEqkEventstr = obsEqkEventstr.trim();
        String[] eventsParams = obsEqkEventstr.split("[ \t]+");
        String yrStr = eventsParams[2];
        String monthStr = eventsParams[3];
        String dayStr = eventsParams[4];
        String hrStr = eventsParams[7];
        String minuteStr = eventsParams[8];
        String secStr = eventsParams[9];
        String latStr = eventsParams[1];
        String lonStr = eventsParams[0];
        String magStr = eventsParams[5];
        String dpthStr = eventsParams[6];
        String magErrStr = eventsParams[12];
        String depthErrStr = eventsParams[11];
        String horrErrStr = eventsParams[10];
        double lat = Double.parseDouble(latStr);
        double lon = Double.parseDouble(lonStr);
        double depth = Double.parseDouble(dpthStr);
        if (lat < RegionDefaults.searchLatMin || lat > RegionDefaults.searchLatMax) {
            return null;
        }
        if (lon < RegionDefaults.searchLongMin || lon > RegionDefaults.searchLongMax) {
            return null;
        }
        if (depth > RegionDefaults.MAX_Z) {
            return null;
        }
        int year = (int)Double.parseDouble(yrStr);
        int month = (int)Double.parseDouble(monthStr.trim());
        int day = (int)Double.parseDouble(dayStr.trim());
        int hour = (int)Double.parseDouble(hrStr.trim());
        int min = (int)Double.parseDouble(minuteStr.trim());
        int sec = (int)Double.parseDouble(secStr.trim());
        GregorianCalendar originTime = new GregorianCalendar(TimeZone.getTimeZone("GMT+8:00"));
        originTime.set(year, month - 1, day, hour, min, sec);
        originTime.set(14, 0);
        double mag = Double.parseDouble(magStr);
        double horzErr = 0.0;
        double vertErr = 0.0;
        double magErr = 0.0;
        if (horrErrStr != null && !horrErrStr.equals("")) {
            horzErr = Double.parseDouble(horrErrStr);
        }
        if (depthErrStr != null && !depthErrStr.equals("")) {
            vertErr = Double.parseDouble(depthErrStr);
        }
        if (magErrStr != null && !magErrStr.equals("")) {
            magErr = Double.parseDouble(magErrStr);
        }
        return new ObsEqkRupture(RegionDefaults.dateformater.format(originTime.getTime()), "CS", '0', originTime, horzErr, vertErr, magErr, "", new Location(lat, lon, depth), mag);
    }

    public static void main(String[] args) {
        try {
            CubeToObsEqkRuptureCsepFormat cubeToRup = new CubeToObsEqkRuptureCsepFormat("data/csep/example_CSEP_cat.txt", null, null);
            ObsEqkRupList rupList = cubeToRup.getAllObsEqkRupEvents();
            rupList.sortObsEqkRupListByOriginTime();
            int size = rupList.size();
            logger.info("rupList size " + size);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

