/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class PointEqkSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("PointEqkSource");
    private static String NAME = "Point Eqk Source";
    private boolean D = false;
    private Location location;
    private double aveDip = Double.NaN;
    private double aveRake = Double.NaN;
    private double duration = Double.NaN;
    private double minMag = Double.NaN;
    private ArrayList<Double> mags;
    private ArrayList<Double> rates;
    private ArrayList<Double> rakes;
    private ArrayList<Double> dips;
    private boolean variableDepthRakeAndDip = false;
    private ArbitrarilyDiscretizedFunc aveRupTopVersusMag;
    private double defaultHypoDepth;

    public PointEqkSource(Location loc, IncrementalMagFreqDist magFreqDist, double duration, double aveRake, double aveDip, double minMag) {
        this.location = loc;
        this.duration = duration;
        this.aveRake = aveRake;
        this.aveDip = aveDip;
        this.minMag = minMag;
        this.setMagsAndRates(magFreqDist);
        this.isPoissonian = true;
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setPointSurface(this.location, aveDip);
        this.probEqkRupture.setAveRake(aveRake);
    }

    public PointEqkSource(Location loc, IncrementalMagFreqDist magFreqDist, double duration, double aveRake, double aveDip) {
        this(loc, magFreqDist, duration, aveRake, aveDip, 0.0);
    }

    public PointEqkSource(HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc, ArbitrarilyDiscretizedFunc aveRupTopVersusMag, double defaultHypoDepth, double duration, double minMag) {
        this.aveRupTopVersusMag = aveRupTopVersusMag;
        this.defaultHypoDepth = defaultHypoDepth;
        this.duration = duration;
        this.minMag = minMag;
        this.isPoissonian = true;
        this.location = hypoMagFreqDistAtLoc.getLocation().copy();
        this.setAll(hypoMagFreqDistAtLoc);
        this.variableDepthRakeAndDip = true;
        this.probEqkRupture = new ProbEqkRupture();
    }

    public PointEqkSource(Location loc, double magnitude, double probability, double aveRake, double aveDip) {
        this.location = loc;
        this.aveRake = aveRake;
        this.aveDip = aveDip;
        this.mags = new ArrayList();
        this.mags.add(new Double(magnitude));
        this.isPoissonian = false;
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setPointSurface(this.location, aveDip);
        this.probEqkRupture.setAveRake(aveRake);
        this.probEqkRupture.setProbability(probability);
    }

    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        locList.addLocation(this.location);
        return locList;
    }

    public EvenlyGriddedSurfaceAPI getSourceSurface() {
        return this.probEqkRupture.getRuptureSurface();
    }

    private void setAll(HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc) {
        this.mags = new ArrayList();
        this.rates = new ArrayList();
        this.rakes = new ArrayList();
        this.dips = new ArrayList();
        IncrementalMagFreqDist[] magFreqDists = hypoMagFreqDistAtLoc.getMagFreqDistList();
        FocalMechanism[] focalMechanisms = hypoMagFreqDistAtLoc.getFocalMechanismList();
        for (int i = 0; i < magFreqDists.length; ++i) {
            FocalMechanism focalMech = focalMechanisms[i];
            IncrementalMagFreqDist magFreqDist = magFreqDists[i];
            for (int m = 0; m < magFreqDist.getNum(); ++m) {
                if (!(magFreqDist.getY(m) > 0.0) || !(magFreqDist.getX(m) >= this.minMag)) continue;
                this.mags.add(new Double(magFreqDist.getX(m)));
                this.rates.add(new Double(magFreqDist.getY(m)));
                this.rakes.add(new Double(focalMech.getRake()));
                this.dips.add(new Double(focalMech.getDip()));
            }
        }
    }

    private void setMagsAndRates(IncrementalMagFreqDist magFreqDist) {
        this.mags = new ArrayList();
        this.rates = new ArrayList();
        for (int i = 0; i < magFreqDist.getNum(); ++i) {
            if (!(magFreqDist.getY(i) > 0.0) || !(magFreqDist.getX(i) >= this.minMag)) continue;
            this.mags.add(new Double(magFreqDist.getX(i)));
            this.rates.add(new Double(magFreqDist.getY(i)));
        }
    }

    public int getNumRuptures() {
        return this.mags.size();
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        double mag = this.mags.get(nthRupture);
        this.probEqkRupture.setMag(mag);
        if (this.isPoissonian) {
            this.probEqkRupture.setProbability(1.0 - Math.exp(-this.duration * this.rates.get(nthRupture)));
        }
        if (this.variableDepthRakeAndDip) {
            this.probEqkRupture.setAveRake(this.rakes.get(nthRupture));
            double depth = mag < this.aveRupTopVersusMag.getMinX() ? this.defaultHypoDepth : this.aveRupTopVersusMag.getClosestY(mag);
            this.location.setDepth(depth);
            this.probEqkRupture.setPointSurface(this.location, this.dips.get(nthRupture));
        }
        return this.probEqkRupture;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setLocation(Location loc) {
        if (this.variableDepthRakeAndDip) {
            throw new RuntimeException(C + "-- Error - can't set Location when variableDepthRakeAndDip = true");
        }
        this.location = loc;
        this.probEqkRupture.setPointSurface(this.location, this.aveDip);
    }

    public Location getLocation() {
        return this.location;
    }

    public double getMinMag() {
        return this.minMag;
    }

    public double getMinDistance(Site site) {
        return RelativeLocation.getHorzDistance(site.getLocation(), this.location);
    }

    public String getName() {
        return C;
    }
}

