/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.A_Faults;

import java.util.ArrayList;
import java.util.HashMap;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.MomentMagCalc;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Somerville_2006_MagAreaRel;
import org.opensha.commons.calc.nnls.NNLSWrapper;
import org.opensha.commons.data.ValueWeight;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.Region;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.A_Faults.TimePredictableQkProbCalc;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.A_Faults.WG02_QkProbCalc;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.A_Faults.WG02_QkSimulations;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.EmpiricalModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.SegRateConstraint;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class A_FaultSegmentedSourceGenerator {
    private static String C = new String("A_FaultSource");
    private static final boolean D = false;
    private static final boolean MATLAB_TEST = false;
    protected String NAME = "Type-A Fault Source";
    private int num_seg;
    private int num_rup;
    private static final double MIN_MAG = 5.05;
    private static final double MAX_MAG = 8.95;
    private static final double DELTA_MAG = 0.1;
    private static final int NUM_MAG = UCERF2.NUM_MAG;
    private static final double MIN_RUP_RATE = 1.0E-10;
    private double magSigma;
    private double magTruncLevel;
    private double[] minRates;
    private boolean wtedInversion;
    private double relativeSegRate_wt;
    private double aPrioriRupWt;
    private double minNonZeroAprioriRate;
    private String slipModelType;
    public static final String CHAR_SLIP_MODEL = "Characteristic (Dsr=Ds)";
    public static final String UNIFORM_SLIP_MODEL = "Uniform/Boxcar (Dsr=Dr)";
    public static final String WG02_SLIP_MODEL = "WGCEP-2002 model (Dsr prop to Vs)";
    public static final String TAPERED_SLIP_MODEL = "Tapered Ends ([Sin(x)]^0.5)";
    private static EvenlyDiscretizedFunc taperedSlipPDF;
    private static EvenlyDiscretizedFunc taperedSlipCDF;
    private int[][] rupInSeg;
    private double[][] segSlipInRup;
    private FaultSegmentData segmentData;
    private ArbDiscrEmpiricalDistFunc[] segSlipDist;
    private ArbitrarilyDiscretizedFunc[] rupSlipDist;
    private double[] finalSegRate;
    private double[] segRateFromApriori;
    private double[] segRateFromAprioriWithMinRateConstr;
    private double[] finalSegSlipRate;
    private double[] aPrioriSegSlipRate;
    private String[] rupNameShort;
    private String[] rupNameLong;
    private double[] rupArea;
    private double[] rupMeanMag;
    private double[] rupMeanMo;
    private double[] rupMoRate;
    private double[] totRupRate;
    double[] rupRateSolution;
    private IncrementalMagFreqDist[] rupMagFreqDist;
    private SummedMagFreqDist summedMagFreqDist;
    private double totalMoRateFromRups;
    private ValueWeight[] aPrioriRupRates;
    private double moRateReduction;
    private double aveSlipCorr;
    private double meanMagCorrection;
    private MagAreaRelationship magAreaRel;
    private static NNLSWrapper nnls;
    private ArrayList<FaultRuptureSource> sourceList;
    private static final double DEFAULT_GRID_SPACING = 1.0;
    private Boolean isTimeDeptendent;
    private double[] segProb;
    private double[] segGain;
    private double[] segAperiodicity;
    private double[] segTimeSinceLast;
    private double[] rupProb;
    private double[] rupGain;
    private HashMap<Integer, Integer> rupSrcMapping;
    private HashMap<Integer, Integer> srcRupMapping;
    private static Somerville_2006_MagAreaRel somerville_magAreaRel;

    public A_FaultSegmentedSourceGenerator(FaultSegmentData segmentData, MagAreaRelationship magAreaRel, String slipModelType, ValueWeight[] aPrioriRupRates, double magSigma, double magTruncLevel, double moRateReduction, double meanMagCorrection, double[] minRates, boolean wtedInversion, double relativeSegRate_wt, double aPrioriRupWt) {
        this.segmentData = segmentData;
        this.magAreaRel = magAreaRel;
        this.slipModelType = slipModelType;
        this.aPrioriRupRates = aPrioriRupRates;
        this.magSigma = magSigma;
        this.magTruncLevel = magTruncLevel;
        this.moRateReduction = moRateReduction;
        this.meanMagCorrection = meanMagCorrection;
        this.minRates = minRates;
        this.wtedInversion = wtedInversion;
        this.relativeSegRate_wt = relativeSegRate_wt;
        this.aPrioriRupWt = aPrioriRupWt;
        this.num_seg = segmentData.getNumSegments();
        this.calcAllRates();
        this.isTimeDeptendent = null;
    }

    private void calcAllRates() {
        int col;
        int row;
        int rup;
        if (this.segmentData.getFaultName().equals("San Jacinto")) {
            this.rupInSeg = A_FaultSegmentedSourceGenerator.getSanJacintoRupInSeg();
            this.num_rup = 25;
        } else {
            this.rupInSeg = A_FaultSegmentedSourceGenerator.getRupInSegMatrix(this.num_seg);
            this.num_rup = A_FaultSegmentedSourceGenerator.getNumRuptureSurfaces(this.segmentData);
        }
        if (this.num_rup != this.aPrioriRupRates.length) {
            throw new RuntimeException("Error: number of ruptures is incompatible with number of elements in aPrioriRupRates");
        }
        this.rupNameShort = A_FaultSegmentedSourceGenerator.getAllShortRuptureNames(this.segmentData);
        this.rupNameLong = A_FaultSegmentedSourceGenerator.getAllLongRuptureNames(this.segmentData);
        this.minNonZeroAprioriRate = Double.MAX_VALUE;
        for (rup = 0; rup < this.num_rup; ++rup) {
            if (this.aPrioriRupRates[rup].getValue() == 0.0 || !(this.aPrioriRupRates[rup].getValue() < this.minNonZeroAprioriRate)) continue;
            this.minNonZeroAprioriRate = this.aPrioriRupRates[rup].getValue();
        }
        this.computeRupAreas();
        this.computeSegRatesFromAprioriRates();
        this.setAveSlipCorrection();
        if (this.slipModelType.equals(CHAR_SLIP_MODEL)) {
            this.getRupMeanMagsAssumingCharSlip();
        } else {
            this.rupMeanMag = new double[this.num_rup];
            this.rupMeanMo = new double[this.num_rup];
            for (rup = 0; rup < this.num_rup; ++rup) {
                this.rupMeanMag[rup] = this.magAreaRel.getMedianMag(this.rupArea[rup] / 1000000.0) + this.meanMagCorrection;
                this.rupMeanMo[rup] = this.aveSlipCorr * MomentMagCalc.getMoment(this.rupMeanMag[rup]);
            }
        }
        this.computeSegSlipInRupMatrix();
        ArrayList<SegRateConstraint> segRateConstraints = this.segmentData.getSegRateConstraints();
        int numRateConstraints = segRateConstraints.size();
        int totNumRows = this.num_seg;
        if (this.relativeSegRate_wt > 0.0) {
            totNumRows += numRateConstraints;
        }
        if (this.aPrioriRupWt > 0.0) {
            totNumRows += this.num_rup;
        }
        int numRowsBeforeSegRateData = this.num_seg;
        if (this.aPrioriRupWt > 0.0) {
            numRowsBeforeSegRateData += this.num_rup;
        }
        double[][] C = new double[totNumRows][this.num_rup];
        double[] d = new double[totNumRows];
        for (int row2 = 0; row2 < this.num_seg; ++row2) {
            d[row2] = this.segmentData.getSegmentSlipRate(row2) * (1.0 - this.moRateReduction);
            for (int col2 = 0; col2 < this.num_rup; ++col2) {
                C[row2][col2] = this.segSlipInRup[row2][col2];
            }
        }
        if (this.aPrioriRupWt > 0.0) {
            for (int rup2 = 0; rup2 < this.num_rup; ++rup2) {
                d[rup2 + this.num_seg] = this.aPrioriRupRates[rup2].getValue();
                C[rup2 + this.num_seg][rup2] = 1.0;
            }
        }
        if (this.relativeSegRate_wt > 0.0) {
            for (row = 0; row < numRateConstraints; ++row) {
                SegRateConstraint constraint = segRateConstraints.get(row);
                int seg = constraint.getSegIndex();
                d[row + numRowsBeforeSegRateData] = constraint.getMean();
                for (int col3 = 0; col3 < this.num_rup; ++col3) {
                    C[row + numRowsBeforeSegRateData][col3] = this.rupInSeg[seg][col3];
                }
            }
        }
        double[] Cmin = new double[totNumRows];
        for (row = 0; row < totNumRows; ++row) {
            for (col = 0; col < this.num_rup; ++col) {
                int n = row;
                Cmin[n] = Cmin[n] + this.minRates[col] * C[row][col];
            }
            int n = row;
            d[n] = d[n] - Cmin[row];
        }
        if (this.wtedInversion) {
            for (int row3 = 0; row3 < this.num_seg; ++row3) {
                double data_wt = 1.0 / ((1.0 - this.moRateReduction) * this.segmentData.getSegSlipRateStdDev(row3));
                int n = row3;
                d[n] = d[n] * data_wt;
                int col4 = 0;
                while (col4 < this.num_rup) {
                    double[] dArray = C[row3];
                    int n2 = col4++;
                    dArray[n2] = dArray[n2] * data_wt;
                }
            }
            if (this.relativeSegRate_wt > 0.0) {
                for (int row4 = 0; row4 < numRateConstraints; ++row4) {
                    SegRateConstraint constraint = segRateConstraints.get(row4);
                    double data_wt = 1.0 / constraint.getStdDevOfMean();
                    int n = row4 + numRowsBeforeSegRateData;
                    d[n] = d[n] * data_wt;
                    int col5 = 0;
                    while (col5 < this.num_rup) {
                        double[] dArray = C[row4 + numRowsBeforeSegRateData];
                        int n3 = col5++;
                        dArray[n3] = dArray[n3] * data_wt;
                    }
                }
            }
        }
        if (this.aPrioriRupWt > 0.0) {
            int rup3 = 0;
            while (rup3 < this.num_rup) {
                double wt = this.aPrioriRupRates[rup3].getValue() > 0.0 ? this.aPrioriRupWt / this.aPrioriRupRates[rup3].getValue() : this.aPrioriRupWt / this.minNonZeroAprioriRate;
                if (this.segmentData.getFaultName().equals("San Jacinto") && rup3 == 3) {
                    wt = 1.0E10 / this.minNonZeroAprioriRate;
                }
                int n = rup3 + this.num_seg;
                d[n] = d[n] * wt;
                double[] dArray = C[rup3 + this.num_seg];
                int n4 = rup3++;
                dArray[n4] = dArray[n4] * wt;
            }
        }
        if (this.relativeSegRate_wt > 0.0) {
            for (int row5 = 0; row5 < numRateConstraints; ++row5) {
                int n = row5 + numRowsBeforeSegRateData;
                d[n] = d[n] * this.relativeSegRate_wt;
                col = 0;
                while (col < this.num_rup) {
                    double[] dArray = C[row5 + numRowsBeforeSegRateData];
                    int n5 = col++;
                    dArray[n5] = dArray[n5] * this.relativeSegRate_wt;
                }
            }
        }
        this.rupRateSolution = A_FaultSegmentedSourceGenerator.getNNLS_solution(C, d);
        for (int rup4 = 0; rup4 < this.num_rup; ++rup4) {
            int n = rup4;
            this.rupRateSolution[n] = this.rupRateSolution[n] + this.minRates[rup4];
        }
        this.totRupRate = new double[this.num_rup];
        this.rupMoRate = new double[this.num_rup];
        this.totalMoRateFromRups = 0.0;
        this.summedMagFreqDist = new SummedMagFreqDist(5.05, NUM_MAG, 0.1);
        boolean singleMag = this.magSigma * this.magTruncLevel < 0.05;
        this.rupMagFreqDist = new GaussianMagFreqDist[this.num_rup];
        for (int i = 0; i < this.num_rup; ++i) {
            this.rupMoRate[i] = this.rupRateSolution[i] * this.rupMeanMo[i];
            this.totalMoRateFromRups += this.rupMoRate[i];
            double mag = singleMag ? (double)Math.round((this.rupMeanMag[i] - 5.05) / 0.1) * 0.1 + 5.05 : this.rupMeanMag[i];
            this.rupMagFreqDist[i] = new GaussianMagFreqDist(5.05, 8.95, NUM_MAG, mag, this.magSigma, this.rupMoRate[i], this.magTruncLevel, 2);
            this.summedMagFreqDist.addIncrementalMagFreqDist(this.rupMagFreqDist[i]);
            this.totRupRate[i] = this.rupMagFreqDist[i].getTotalIncrRate();
        }
        String summed_info = "\n\nMoment Rate: " + (float)this.getTotalMoRateFromSummedMFD() + "\n\nTotal Rate: " + (float)this.summedMagFreqDist.getCumRate(0);
        this.summedMagFreqDist.setInfo(summed_info);
        this.computeFinalSegSlipRate();
        this.computeFinalSegRates();
        this.computeRupSlipDist();
    }

    public StirlingGriddedSurface getCombinedGriddedSurface(int rupIndex, boolean applyCyberShakeDDW_Corr) {
        int[] segmentsInRup = this.getSegmentsInRup(rupIndex);
        if (applyCyberShakeDDW_Corr) {
            double ddwCorrFactor = somerville_magAreaRel.getMedianArea(this.rupMeanMag[rupIndex]) / (this.rupArea[rupIndex] / 1000000.0);
            return this.segmentData.getCombinedGriddedSurface(segmentsInRup, 1.0, ddwCorrFactor);
        }
        return this.segmentData.getCombinedGriddedSurface(segmentsInRup, 1.0);
    }

    public StirlingGriddedSurface getCombinedGriddedSurfaceForSource(int srcIndex, boolean applyCyberShakeDDW_Corr) {
        return this.getCombinedGriddedSurface(this.srcRupMapping.get(srcIndex), applyCyberShakeDDW_Corr);
    }

    public double getAveRake(int rupIndex) {
        int[] segmentsInRup = this.getSegmentsInRup(rupIndex);
        return this.segmentData.getAveRake(segmentsInRup);
    }

    public double getAveRakeForSource(int srcIndex) {
        return this.getAveRake(this.srcRupMapping.get(srcIndex));
    }

    public ArrayList<FaultRuptureSource> getTimeIndependentSources(double duration) {
        int i;
        this.isTimeDeptendent = false;
        this.segTimeSinceLast = null;
        this.segAperiodicity = null;
        this.segGain = new double[this.num_seg];
        this.segProb = new double[this.num_seg];
        for (i = 0; i < this.num_seg; ++i) {
            this.segProb[i] = 1.0 - Math.exp(-duration * this.finalSegRate[i]);
            this.segGain[i] = 1.0;
        }
        this.sourceList = new ArrayList();
        this.rupSrcMapping = new HashMap();
        this.srcRupMapping = new HashMap();
        this.rupGain = new double[this.num_rup];
        this.rupProb = new double[this.num_rup];
        for (i = 0; i < this.num_rup; ++i) {
            this.rupProb[i] = 1.0 - Math.exp(-duration * this.totRupRate[i]);
            this.rupGain[i] = 1.0;
            if (!(this.rupMagFreqDist[i].getTotalIncrRate() > 1.0E-10)) continue;
            FaultRuptureSource faultRupSrc = new FaultRuptureSource(this.rupMagFreqDist[i], (EvenlyGriddedSurface)this.getCombinedGriddedSurface(i, false), this.getAveRake(i), duration);
            faultRupSrc.setName(this.getLongRupName(i));
            if (faultRupSrc.getNumRuptures() == 0) {
                System.out.println(faultRupSrc.getName() + " has zero ruptures");
            }
            this.rupSrcMapping.put(i, this.sourceList.size());
            this.srcRupMapping.put(this.sourceList.size(), i);
            this.sourceList.add(faultRupSrc);
        }
        return this.sourceList;
    }

    public ArrayList<FaultRuptureSource> getTimeDepEmpiricalSources(double duration, EmpiricalModel empiricalModel) {
        this.isTimeDeptendent = false;
        this.segTimeSinceLast = null;
        this.segAperiodicity = null;
        this.sourceList = new ArrayList();
        this.rupSrcMapping = new HashMap();
        this.srcRupMapping = new HashMap();
        this.rupGain = new double[this.num_rup];
        this.rupProb = new double[this.num_rup];
        double[] modRupRate = new double[this.num_rup];
        for (int i = 0; i < this.num_rup; ++i) {
            StirlingGriddedSurface rupSurf = this.getCombinedGriddedSurface(i, false);
            double empiricalCorr = empiricalModel.getCorrection(rupSurf);
            modRupRate[i] = this.totRupRate[i] * empiricalCorr;
            this.rupProb[i] = 1.0 - Math.exp(-duration * modRupRate[i]);
            this.rupGain[i] = this.rupProb[i] / (1.0 - Math.exp(-duration * this.totRupRate[i]));
            IncrementalMagFreqDist modMagFreqDist = this.rupMagFreqDist[i].deepClone();
            for (int magIndex = 0; magIndex < modMagFreqDist.getNum(); ++magIndex) {
                modMagFreqDist.set(magIndex, empiricalCorr * modMagFreqDist.getY(magIndex));
            }
            if (!(this.totRupRate[i] > 1.0E-10)) continue;
            FaultRuptureSource faultRupSrc = new FaultRuptureSource(modMagFreqDist, (EvenlyGriddedSurface)rupSurf, this.getAveRake(i), duration);
            faultRupSrc.setName(this.getLongRupName(i));
            if (faultRupSrc.getNumRuptures() == 0) {
                System.out.println(faultRupSrc.getName() + " has zero ruptures");
            }
            this.rupSrcMapping.put(i, this.sourceList.size());
            this.srcRupMapping.put(this.sourceList.size(), i);
            this.sourceList.add(faultRupSrc);
        }
        this.segGain = new double[this.num_seg];
        this.segProb = new double[this.num_seg];
        double[] modSegRate = new double[this.num_seg];
        for (int seg = 0; seg < this.num_seg; ++seg) {
            modSegRate[seg] = 0.0;
            for (int rup = 0; rup < this.num_rup; ++rup) {
                if (this.rupInSeg[seg][rup] != 1) continue;
                int n = seg;
                modSegRate[n] = modSegRate[n] + modRupRate[rup];
            }
        }
        for (int i = 0; i < this.num_seg; ++i) {
            this.segProb[i] = 1.0 - Math.exp(-duration * modSegRate[i]);
            this.segGain[i] = this.segProb[i] / (1.0 - Math.exp(-duration * this.finalSegRate[i]));
        }
        return this.sourceList;
    }

    public ArrayList<FaultRuptureSource> getTimeDependentSources(double duration, double startYear, double aperiodicity, boolean applySegVariableAperiodicity) {
        int i;
        this.isTimeDeptendent = true;
        this.segTimeSinceLast = new double[this.num_seg];
        this.segAperiodicity = new double[this.num_seg];
        for (i = 0; i < this.num_seg; ++i) {
            this.segTimeSinceLast[i] = startYear - this.segmentData.getSegCalYearOfLastEvent(i);
            if (applySegVariableAperiodicity) {
                this.segAperiodicity[i] = this.segmentData.getSegAperiodicity(i);
                if (!Double.isNaN(this.segAperiodicity[i])) continue;
                this.segAperiodicity[i] = aperiodicity;
                continue;
            }
            this.segAperiodicity[i] = aperiodicity;
        }
        this.rupProb = WG02_QkProbCalc.getRupProbs(this.finalSegRate, this.totRupRate, this.getFinalSegMoRate(), this.segAperiodicity, this.segTimeSinceLast, duration, this.rupInSeg);
        for (i = 0; i < this.num_rup; ++i) {
            if (!(this.rupProb[i] <= 1.0E-12)) continue;
            this.rupProb[i] = 0.0;
        }
        this.segProb = WG02_QkProbCalc.getSegProbs(this.finalSegRate, this.segAperiodicity, this.segTimeSinceLast, duration);
        this.segGain = new double[this.num_seg];
        for (i = 0; i < this.num_seg; ++i) {
            this.segGain[i] = this.segProb[i] / (1.0 - Math.exp(-duration * this.finalSegRate[i]));
        }
        this.rupGain = new double[this.num_rup];
        for (i = 0; i < this.num_rup; ++i) {
            this.rupGain[i] = this.totRupRate[i] > 1.0E-12 ? this.rupProb[i] / (1.0 - Math.exp(-duration * this.totRupRate[i])) : 1.0;
        }
        this.sourceList = new ArrayList();
        this.rupSrcMapping = new HashMap();
        this.srcRupMapping = new HashMap();
        for (i = 0; i < this.num_rup; ++i) {
            if (!(this.rupProb[i] > 1.0E-10)) continue;
            FaultRuptureSource faultRupSrc = new FaultRuptureSource(this.rupProb[i], this.rupMagFreqDist[i], this.getCombinedGriddedSurface(i, false), this.getAveRake(i));
            faultRupSrc.setName(this.getLongRupName(i));
            this.rupSrcMapping.put(i, this.sourceList.size());
            this.srcRupMapping.put(this.sourceList.size(), i);
            this.sourceList.add(faultRupSrc);
        }
        return this.sourceList;
    }

    public double getTotFaultProb() {
        double totProbNoEvent = 1.0;
        for (int i = 0; i < this.num_rup; ++i) {
            totProbNoEvent *= 1.0 - this.getRupSourceProb(i);
        }
        return 1.0 - totProbNoEvent;
    }

    public double getTotFaultProb(double mag) {
        return this.getTotFaultProb(mag, null);
    }

    public double getTotFaultProb(double mag, Region region) {
        double totProbNoEvent = 1.0;
        for (int i = 0; i < this.num_rup; ++i) {
            totProbNoEvent *= 1.0 - this.getRupSourceProbAboveMag(i, mag, region);
        }
        return 1.0 - totProbNoEvent;
    }

    public double getApproxTotFaultProb(double mag, Region region) {
        double totProbNoEvent = 1.0;
        for (int i = 0; i < this.num_rup; ++i) {
            totProbNoEvent *= 1.0 - this.getRupSourceApproxProbAboveMag(i, mag, region);
        }
        return 1.0 - totProbNoEvent;
    }

    public double getTotFaultProbGain() {
        double totPoisProbNoEvent = 1.0;
        for (int i = 0; i < this.num_rup; ++i) {
            double poisProb = this.getRupSourceProb(i) / this.getRupSourcProbGain(i);
            totPoisProbNoEvent *= 1.0 - poisProb;
        }
        return this.getTotFaultProb() / (1.0 - totPoisProbNoEvent);
    }

    public double getRupSourceProb(int ithRup) {
        return this.rupProb[ithRup];
    }

    public double getRupSourceProbAboveMag(int ithRup, double mag) {
        return this.getRupSourceProbAboveMag(ithRup, mag, null);
    }

    public double getRupSourceProbAboveMag(int ithRup, double mag, Region region) {
        if (!this.rupSrcMapping.containsKey(ithRup)) {
            return 0.0;
        }
        int srcIndex = this.rupSrcMapping.get(ithRup);
        return this.sourceList.get(srcIndex).computeTotalProbAbove(mag, region);
    }

    public double getRupSourceApproxProbAboveMag(int ithRup, double mag, Region region) {
        if (!this.rupSrcMapping.containsKey(ithRup)) {
            return 0.0;
        }
        int srcIndex = this.rupSrcMapping.get(ithRup);
        return this.sourceList.get(srcIndex).computeApproxTotalProbAbove(mag, region);
    }

    public double getRupSourcProbGain(int ithRup) {
        return this.rupGain[ithRup];
    }

    public double getSegProbGain(int ithSeg) {
        return this.segGain[ithSeg];
    }

    public double getSegProb(int ithSeg) {
        return this.segProb[ithSeg];
    }

    public double getSegAperiodicity(int ithSeg) {
        if (this.isTimeDeptendent.booleanValue()) {
            return this.segAperiodicity[ithSeg];
        }
        return Double.NaN;
    }

    public double getSegTimeSinceLast(int ithSeg) {
        if (this.isTimeDeptendent.booleanValue()) {
            return this.segTimeSinceLast[ithSeg];
        }
        return Double.NaN;
    }

    public String getNSHMP_SrcFileString() {
        boolean localDebug = true;
        StringBuffer strBuffer = new StringBuffer("");
        ArrayList<FaultRuptureSource> sourceList = this.getTimeIndependentSources(1.0);
        int srcIndex = 0;
        for (int rupIndex = 0; rupIndex < this.num_rup; ++rupIndex) {
            if (!this.rupSrcMapping.containsKey(rupIndex)) continue;
            FaultRuptureSource faultRupSrc = this.sourceList.get(srcIndex++);
            strBuffer.append("1\t");
            double rake = faultRupSrc.getRupture(0).getAveRake();
            double wt = 1.0;
            String rakeStr = "";
            if (rake >= -45.0 && rake <= 45.0 || rake >= 135.0 || rake <= -135.0) {
                rakeStr = "1";
            } else if (rake > 45.0 && rake < 135.0) {
                rakeStr = "2";
            } else if (rake > -135.0 && rake < -45.0) {
                rakeStr = "3";
            } else {
                throw new RuntimeException("Invalid Rake:" + rake + ", index=" + rupIndex + ", name=" + this.getLongRupName(rupIndex));
            }
            strBuffer.append(rakeStr + "\t" + "1" + "\t" + this.segmentData.getFaultName() + ";" + this.getLongRupName(rupIndex) + "\n");
            double fixRate = this.rupMoRate[rupIndex] / MomentMagCalc.getMoment(this.rupMeanMag[rupIndex]);
            strBuffer.append((float)this.getRupMeanMag(rupIndex) + "\t" + (float)fixRate + "\t" + wt + "\n");
            EvenlyGriddedSurfFromSimpleFaultData surface = (EvenlyGriddedSurfFromSimpleFaultData)faultRupSrc.getSourceSurface();
            strBuffer.append((float)surface.getAveDip() + "\t" + (float)surface.getSurfaceWidth() + "\t" + (float)surface.getUpperSeismogenicDepth() + "\t" + (float)surface.getSurfaceLength() + "\n");
            FaultTrace faultTrace = surface.getFaultTrace();
            strBuffer.append(faultTrace.getNumLocations() + "\n");
            for (int locIndex = 0; locIndex < faultTrace.getNumLocations(); ++locIndex) {
                strBuffer.append(faultTrace.getLocationAt(locIndex).getLatitude() + "\t" + faultTrace.getLocationAt(locIndex).getLongitude() + "\n");
            }
            if (!localDebug) continue;
            System.out.println(this.getLongRupName(rupIndex) + "\t" + (float)this.getRupMeanMag(rupIndex) + "\t" + (float)this.getRupRateSolution(rupIndex) + "\t" + (float)this.getRupRate(rupIndex) + "\t" + (float)(this.getRupRateSolution(rupIndex) / this.getRupRate(rupIndex)) + "\t" + this.magAreaRel.getName() + "\t" + this.aPrioriRupWt);
        }
        return strBuffer.toString();
    }

    private int[] getSegmentsInRup(int rupIndex) {
        ArrayList<Integer> segs = new ArrayList<Integer>();
        for (int segIndex = 0; segIndex < this.num_seg; ++segIndex) {
            if (this.rupInSeg[segIndex][rupIndex] != 1) continue;
            segs.add(segIndex);
        }
        int[] segArray = new int[segs.size()];
        for (int i = 0; i < segArray.length; ++i) {
            segArray[i] = (Integer)segs.get(i);
        }
        return segArray;
    }

    private void computeFinalSegSlipRate() {
        this.finalSegSlipRate = new double[this.num_seg];
        this.aPrioriSegSlipRate = new double[this.num_seg];
        for (int seg = 0; seg < this.num_seg; ++seg) {
            this.finalSegSlipRate[seg] = 0.0;
            this.aPrioriSegSlipRate[seg] = 0.0;
            for (int rup = 0; rup < this.num_rup; ++rup) {
                int n = seg;
                this.finalSegSlipRate[n] = this.finalSegSlipRate[n] + this.totRupRate[rup] * this.segSlipInRup[seg][rup];
                int n2 = seg;
                this.aPrioriSegSlipRate[n2] = this.aPrioriSegSlipRate[n2] + this.aPrioriRupRates[rup].getValue() * this.segSlipInRup[seg][rup];
            }
        }
    }

    public static final ArrayList getSupportedSlipModels() {
        ArrayList<String> models = new ArrayList<String>();
        models.add(CHAR_SLIP_MODEL);
        models.add(UNIFORM_SLIP_MODEL);
        models.add(WG02_SLIP_MODEL);
        models.add(TAPERED_SLIP_MODEL);
        return models;
    }

    public double getMoRateReduction() {
        return this.moRateReduction;
    }

    private void getRupMeanMagsAssumingCharSlip() {
        this.rupMeanMag = new double[this.num_rup];
        this.rupMeanMo = new double[this.num_rup];
        for (int rup = 0; rup < this.num_rup; ++rup) {
            for (int seg = 0; seg < this.num_seg; ++seg) {
                if (this.rupInSeg[seg][rup] != 1) continue;
                double area = this.segmentData.getSegmentArea(seg);
                double slip = this.segmentData.getSegmentSlipRate(seg) / this.segRateFromAprioriWithMinRateConstr[seg] * (1.0 - this.moRateReduction);
                int n = rup;
                this.rupMeanMo[n] = this.rupMeanMo[n] + area * slip * 3.0E10;
            }
            this.rupMeanMag[rup] = MomentMagCalc.getMag(this.rupMeanMo[rup] / this.aveSlipCorr);
        }
    }

    private static final int[][] getRupInSegMatrix(int num_seg) {
        int num_rup = num_seg * (num_seg + 1) / 2;
        int[][] rupInSeg = new int[num_seg][num_rup];
        int n_rup_wNseg = num_seg;
        int remain_rups = num_seg;
        int nSegInRup = 1;
        int startSeg = 0;
        for (int rup = 0; rup < num_rup; ++rup) {
            for (int seg = startSeg; seg < startSeg + nSegInRup; ++seg) {
                rupInSeg[seg][rup] = 1;
            }
            ++startSeg;
            if (--remain_rups != 0) continue;
            startSeg = 0;
            ++nSegInRup;
            remain_rups = --n_rup_wNseg;
        }
        return rupInSeg;
    }

    private static final int[][] getSanJacintoRupInSeg() {
        int num_seg = 7;
        int num_rup = 25;
        int[][] sjfRupInSeg = new int[][]{{1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1}};
        return sjfRupInSeg;
    }

    public double getTotalMoRateFromRups() {
        return this.totalMoRateFromRups;
    }

    public double getTotalMoRateFromSummedMFD() {
        return this.summedMagFreqDist.getTotalMomentRate();
    }

    public double getRupRate(int ithRup) {
        return this.totRupRate[ithRup];
    }

    public double getRupRateSolution(int ithRup) {
        return this.rupRateSolution[ithRup];
    }

    public double getRupRateResid(int ithRup) {
        double max = this.totRupRate[ithRup];
        if (max < this.aPrioriRupRates[ithRup].getValue()) {
            max = this.aPrioriRupRates[ithRup].getValue();
        }
        if (max <= 1.0E-10) {
            return 0.0;
        }
        return (this.totRupRate[ithRup] - this.aPrioriRupRates[ithRup].getValue()) / max;
    }

    public double getRupMoRate(int ithRup) {
        return this.rupMoRate[ithRup];
    }

    public double getAPrioriRupRate(int ithRup) {
        return this.aPrioriRupRates[ithRup].getValue();
    }

    public IncrementalMagFreqDist getTotalRupMFD() {
        return this.summedMagFreqDist;
    }

    public double getFinalSegSlipRate(int ithSegment) {
        return this.finalSegSlipRate[ithSegment];
    }

    public double get_aPrioriSegSlipRate(int ithSegment) {
        return this.aPrioriSegSlipRate[ithSegment];
    }

    public double getSegRateFromAprioriRates(int ithSegment) {
        return this.segRateFromApriori[ithSegment];
    }

    public double getFinalSegmentRate(int ithSegment) {
        return this.finalSegRate[ithSegment];
    }

    public ArbDiscrEmpiricalDistFunc getSegmentSlipDist(int ithSegment) {
        return this.segSlipDist[ithSegment];
    }

    public double getRupMeanMag(int ithRup) {
        return this.rupMeanMag[ithRup];
    }

    public double getRupArea(int ithRup) {
        return this.rupArea[ithRup];
    }

    public String getLongRupName(int ithRup) {
        return this.rupNameLong[ithRup];
    }

    public String getShortRupName(int ithRup) {
        return this.rupNameShort[ithRup];
    }

    private void computeSegSlipDist(double[][] segRupSlipFactor) {
        this.segSlipDist = new ArbDiscrEmpiricalDistFunc[this.num_seg];
        for (int seg = 0; seg < this.num_seg; ++seg) {
            this.segSlipDist[seg] = new ArbDiscrEmpiricalDistFunc();
            for (int rup = 0; rup < this.num_rup; ++rup) {
                if (this.rupInSeg[seg][rup] != 1) continue;
                for (int i = 0; i < this.rupSlipDist[rup].getNum(); ++i) {
                    this.segSlipDist[seg].set(segRupSlipFactor[rup][seg] * this.rupSlipDist[rup].getX(i), this.rupSlipDist[rup].getY(i));
                }
            }
        }
    }

    public double[][] getSegSlipInRupMatrix() {
        return this.segSlipInRup;
    }

    private void computeSegSlipInRupMatrix() {
        this.segSlipInRup = new double[this.num_seg][this.num_rup];
        if (this.slipModelType.equals(CHAR_SLIP_MODEL)) {
            for (int seg = 0; seg < this.num_seg; ++seg) {
                double segCharSlip = this.segmentData.getSegmentSlipRate(seg) * (1.0 - this.moRateReduction) / this.segRateFromAprioriWithMinRateConstr[seg];
                for (int rup = 0; rup < this.num_rup; ++rup) {
                    this.segSlipInRup[seg][rup] = (double)this.rupInSeg[seg][rup] * segCharSlip;
                }
            }
        } else if (this.slipModelType.equals(UNIFORM_SLIP_MODEL)) {
            for (int rup = 0; rup < this.num_rup; ++rup) {
                double aveSlip = this.rupMeanMo[rup] / (this.rupArea[rup] * 3.0E10);
                for (int seg = 0; seg < this.num_seg; ++seg) {
                    this.segSlipInRup[seg][rup] = (double)this.rupInSeg[seg][rup] * aveSlip;
                }
            }
        } else if (this.slipModelType.equals(WG02_SLIP_MODEL)) {
            for (int rup = 0; rup < this.num_rup; ++rup) {
                int seg;
                double aveSlip = this.rupMeanMo[rup] / (this.rupArea[rup] * 3.0E10);
                double totMoRate = 0.0;
                double totArea = 0.0;
                for (seg = 0; seg < this.num_seg; ++seg) {
                    if (this.rupInSeg[seg][rup] != 1) continue;
                    totMoRate += this.segmentData.getSegmentMomentRate(seg);
                    totArea += this.segmentData.getSegmentArea(seg);
                }
                for (seg = 0; seg < this.num_seg; ++seg) {
                    this.segSlipInRup[seg][rup] = aveSlip * (double)this.rupInSeg[seg][rup] * this.segmentData.getSegmentMomentRate(seg) * totArea / (totMoRate * this.segmentData.getSegmentArea(seg));
                }
            }
        } else if (this.slipModelType.equals(TAPERED_SLIP_MODEL)) {
            A_FaultSegmentedSourceGenerator.mkTaperedSlipFuncs();
            for (int rup = 0; rup < this.num_rup; ++rup) {
                double aveSlip = this.rupMeanMo[rup] / (this.rupArea[rup] * 3.0E10);
                double totRupArea = 0.0;
                for (int seg = 0; seg < this.num_seg; ++seg) {
                    if (this.rupInSeg[seg][rup] != 1) continue;
                    totRupArea += this.segmentData.getSegmentArea(seg);
                }
                double normBegin = 0.0;
                for (int seg = 0; seg < this.num_seg; ++seg) {
                    if (this.rupInSeg[seg][rup] != 1) continue;
                    double normEnd = normBegin + this.segmentData.getSegmentArea(seg) / totRupArea;
                    if (normEnd > 1.0 && normEnd < 1.00001) {
                        normEnd = 1.0;
                    }
                    double scaleFactor = taperedSlipCDF.getInterpolatedY(normEnd) - taperedSlipCDF.getInterpolatedY(normBegin);
                    this.segSlipInRup[seg][rup] = aveSlip * (scaleFactor /= normEnd - normBegin);
                    normBegin = normEnd;
                }
            }
        } else {
            throw new RuntimeException("slip model not supported");
        }
    }

    private void computeRupSlipDist() {
        this.rupSlipDist = new ArbitrarilyDiscretizedFunc[this.num_rup];
        for (int rup = 0; rup < this.num_rup; ++rup) {
            this.rupSlipDist[rup] = new ArbitrarilyDiscretizedFunc();
            for (int imag = 0; imag < this.rupMagFreqDist[rup].getNum(); ++imag) {
                if (this.rupMagFreqDist[rup].getY(imag) == 0.0) continue;
                double moment = MomentMagCalc.getMoment(this.rupMagFreqDist[rup].getX(imag));
                double slip = FaultMomentCalc.getSlip(this.rupArea[rup], moment);
                this.rupSlipDist[rup].set(slip, this.rupMagFreqDist[rup].getY(imag));
            }
        }
    }

    private void computeFinalSegRates() {
        this.finalSegRate = new double[this.num_seg];
        for (int seg = 0; seg < this.num_seg; ++seg) {
            this.finalSegRate[seg] = 0.0;
            for (int rup = 0; rup < this.num_rup; ++rup) {
                if (this.rupInSeg[seg][rup] != 1) continue;
                int n = seg;
                this.finalSegRate[n] = this.finalSegRate[n] + this.totRupRate[rup];
            }
        }
    }

    private void computeSegRatesFromAprioriRates() {
        this.segRateFromApriori = new double[this.num_seg];
        this.segRateFromAprioriWithMinRateConstr = new double[this.num_seg];
        for (int seg = 0; seg < this.num_seg; ++seg) {
            this.segRateFromApriori[seg] = 0.0;
            for (int rup = 0; rup < this.num_rup; ++rup) {
                if (this.rupInSeg[seg][rup] != 1) continue;
                int n = seg;
                this.segRateFromApriori[n] = this.segRateFromApriori[n] + this.aPrioriRupRates[rup].getValue();
                int n2 = seg;
                this.segRateFromAprioriWithMinRateConstr[n2] = this.segRateFromAprioriWithMinRateConstr[n2] + Math.max(this.aPrioriRupRates[rup].getValue(), this.minRates[rup]);
            }
        }
    }

    public double computeSegProbAboveMag(double mag, int segIndex) {
        double segProbAboveMag = 1.0;
        for (int rup = 0; rup < this.num_rup; ++rup) {
            if (!this.rupSrcMapping.containsKey(rup) || this.rupInSeg[segIndex][rup] != 1) continue;
            FaultRuptureSource src = this.sourceList.get(this.rupSrcMapping.get(rup));
            segProbAboveMag *= 1.0 - src.computeTotalProbAbove(mag);
        }
        return 1.0 - segProbAboveMag;
    }

    public static final String[] getAllShortRuptureNames(FaultSegmentData segmentData) {
        int nSeg = segmentData.getNumSegments();
        int nRup = A_FaultSegmentedSourceGenerator.getNumRuptureSurfaces(segmentData);
        int[][] rupInSeg = segmentData.getFaultName().equals("San Jacinto") ? A_FaultSegmentedSourceGenerator.getSanJacintoRupInSeg() : A_FaultSegmentedSourceGenerator.getRupInSegMatrix(nSeg);
        String[] rupNameShort = new String[nRup];
        for (int rup = 0; rup < nRup; ++rup) {
            boolean isFirst = true;
            for (int seg = 0; seg < nSeg; ++seg) {
                if (rupInSeg[seg][rup] != 1) continue;
                if (isFirst) {
                    rupNameShort[rup] = "" + (seg + 1);
                    isFirst = false;
                    continue;
                }
                int n = rup;
                rupNameShort[n] = rupNameShort[n] + (seg + 1);
            }
        }
        return rupNameShort;
    }

    public static final String[] getAllLongRuptureNames(FaultSegmentData segmentData) {
        int nSeg = segmentData.getNumSegments();
        int nRup = A_FaultSegmentedSourceGenerator.getNumRuptureSurfaces(segmentData);
        int[][] rupInSeg = segmentData.getFaultName().equals("San Jacinto") ? A_FaultSegmentedSourceGenerator.getSanJacintoRupInSeg() : A_FaultSegmentedSourceGenerator.getRupInSegMatrix(nSeg);
        String[] rupNameLong = new String[nRup];
        for (int rup = 0; rup < nRup; ++rup) {
            boolean isFirst = true;
            for (int seg = 0; seg < nSeg; ++seg) {
                if (rupInSeg[seg][rup] != 1) continue;
                if (isFirst) {
                    rupNameLong[rup] = segmentData.getSegmentName(seg);
                    isFirst = false;
                    continue;
                }
                int n = rup;
                rupNameLong[n] = rupNameLong[n] + "+" + segmentData.getSegmentName(seg);
            }
        }
        return rupNameLong;
    }

    private void computeRupAreas() {
        this.rupArea = new double[this.num_rup];
        for (int rup = 0; rup < this.num_rup; ++rup) {
            this.rupArea[rup] = 0.0;
            for (int seg = 0; seg < this.num_seg; ++seg) {
                if (this.rupInSeg[seg][rup] != 1) continue;
                int n = rup;
                this.rupArea[n] = this.rupArea[n] + this.segmentData.getSegmentArea(seg);
            }
        }
    }

    public int getNumRupSources() {
        return this.num_rup;
    }

    public static final int getNumRuptureSurfaces(FaultSegmentData segmentData) {
        int nSeg = segmentData.getNumSegments();
        if (segmentData.getFaultName().equals("San Jacinto")) {
            return 25;
        }
        return nSeg * (nSeg + 1) / 2;
    }

    public void setName(String name) {
        this.NAME = name;
    }

    public FaultSegmentData getFaultSegmentData() {
        return this.segmentData;
    }

    public String getName() {
        return this.NAME;
    }

    private static double[] getNNLS_solution(double[][] C, double[] d) {
        int nRow = C.length;
        int nCol = C[0].length;
        double[] A = new double[nRow * nCol];
        double[] x = new double[nCol];
        int k = 0;
        for (int j = 0; j < nCol; ++j) {
            for (int i = 0; i < nRow; ++i) {
                A[k] = C[i][j];
                ++k;
            }
        }
        nnls.update(A, nRow, nCol);
        boolean converged = nnls.solve(d, x);
        if (!converged) {
            throw new RuntimeException("ERROR:  NNLS Inversion Failed");
        }
        return x;
    }

    private static void mkTaperedSlipFuncs() {
        double y;
        int i;
        if (taperedSlipCDF != null) {
            return;
        }
        taperedSlipCDF = new EvenlyDiscretizedFunc(0.0, 51, 0.02);
        taperedSlipPDF = new EvenlyDiscretizedFunc(0.0, 51, 0.02);
        double sum = 0.0;
        int num = taperedSlipPDF.getNum();
        for (i = 0; i < num; ++i) {
            double x = taperedSlipPDF.getX(i);
            y = Math.pow(Math.sin(x * Math.PI), 0.5);
            taperedSlipPDF.set(i, y);
            sum += y;
        }
        y = 0.0;
        for (i = 0; i < num; ++i) {
            taperedSlipCDF.set(i, (y += taperedSlipPDF.getY(i)) / sum);
            taperedSlipPDF.set(i, taperedSlipPDF.getY(i) / sum);
        }
    }

    private void setAveSlipCorrection() {
        if (this.magSigma == 0.0 || this.magTruncLevel == 0.0) {
            this.aveSlipCorr = 1.0;
        } else {
            double sum = 0.0;
            int num = 0;
            for (double mag = 7.0; mag < 7.098999999999999; mag += 0.01) {
                GaussianMagFreqDist magFreqDist = new GaussianMagFreqDist(5.05, 8.95, NUM_MAG, mag, this.magSigma, 1.0, this.magTruncLevel, 2);
                double temp = magFreqDist.getTotalMomentRate() / (magFreqDist.getTotalIncrRate() * MomentMagCalc.getMoment(mag));
                ++num;
                sum += temp;
            }
            this.aveSlipCorr = sum / (double)num;
        }
    }

    private static void testNNLS_SolutionLimits(int num) {
        int i;
        double[] d = new double[num];
        d[0] = 1.0;
        for (int i2 = 1; i2 < num; ++i2) {
            d[i2] = i2;
        }
        double[][] C = new double[num][num];
        C[0][0] = 1.0;
        for (i = 1; i < num - 1; ++i) {
            C[0][i] = 0.0;
        }
        for (i = 0; i < num - 1; ++i) {
            C[i + 1][i] = -1.0;
            C[i + 1][i + 1] = 1.0;
        }
        double[] solution = A_FaultSegmentedSourceGenerator.getNNLS_solution(C, d);
        for (int i3 = 0; i3 < solution.length; ++i3) {
            System.out.println(solution[i3]);
        }
    }

    public static void main(String[] args) {
        A_FaultSegmentedSourceGenerator.testNNLS_SolutionLimits(5000);
    }

    public double[] getNormModSlipRateResids() {
        int numSegments = this.getFaultSegmentData().getNumSegments();
        double[] normResids = new double[numSegments];
        double reduction = 1.0 - this.getMoRateReduction();
        for (int segIndex = 0; segIndex < numSegments; ++segIndex) {
            normResids[segIndex] = this.getFinalSegSlipRate(segIndex) - this.getFaultSegmentData().getSegmentSlipRate(segIndex) * reduction;
            int n = segIndex;
            normResids[n] = normResids[n] / (this.getFaultSegmentData().getSegSlipRateStdDev(segIndex) * reduction);
        }
        return normResids;
    }

    public double[] getNormDataER_Resids() {
        int numSegments = this.getFaultSegmentData().getNumSegments();
        double[] normResids = new double[numSegments];
        for (int segIndex = 0; segIndex < numSegments; ++segIndex) {
            normResids[segIndex] = (this.getFinalSegmentRate(segIndex) - this.getFaultSegmentData().getSegRateMean(segIndex)) / this.getFaultSegmentData().getSegRateStdDevOfMean(segIndex);
        }
        return normResids;
    }

    public double getGeneralizedPredictionError() {
        return this.getNormModSlipRateError() + this.getNormDataER_Error() + this.getA_PrioriModelError();
    }

    public double getNormModSlipRateError() {
        double totError = 0.0;
        double[] errors = this.getNormModSlipRateResids();
        for (int i = 0; i < errors.length; ++i) {
            totError += errors[i] * errors[i];
        }
        return totError;
    }

    public double getNormDataER_Error() {
        double totError = 0.0;
        double[] errors = this.getNormDataER_Resids();
        for (int i = 0; i < errors.length; ++i) {
            if (Double.isNaN(errors[i])) continue;
            totError += errors[i] * errors[i];
        }
        return totError;
    }

    public double getA_PrioriModelError() {
        double totError = 0.0;
        for (int rup = 0; rup < this.num_rup; ++rup) {
            double wt = this.aPrioriRupRates[rup].getValue() > 0.0 ? this.aPrioriRupWt / this.aPrioriRupRates[rup].getValue() : this.aPrioriRupWt / this.minNonZeroAprioriRate;
            double finalRupRate = this.getRupRate(rup);
            double aPrioriRate = this.getAPrioriRupRate(rup);
            totError += (finalRupRate - aPrioriRate) * (finalRupRate - aPrioriRate) * wt * wt;
        }
        return totError;
    }

    public double getTotalAPrioriRate() {
        double total = 0.0;
        for (int rup = 0; rup < this.num_rup; ++rup) {
            total += this.aPrioriRupRates[rup].getValue();
        }
        return total;
    }

    public double getNonNormA_PrioriModelError() {
        double totError = 0.0;
        for (int rup = 0; rup < this.num_rup; ++rup) {
            double finalRupRate = this.getRupRate(rup);
            double aPrioriRate = this.getAPrioriRupRate(rup);
            totError += (finalRupRate - aPrioriRate) * (finalRupRate - aPrioriRate);
        }
        return totError;
    }

    public double[] getFinalSegMoRate() {
        double[] segMoRate = new double[this.num_seg];
        double totMoRate = 0.0;
        for (int i = 0; i < this.num_seg; ++i) {
            segMoRate[i] = this.segmentData.getSegmentMomentRate(i) * (1.0 - this.moRateReduction);
            totMoRate += segMoRate[i];
        }
        return segMoRate;
    }

    public void simulateEvents(int num) {
        double simRate;
        int i;
        if (!this.isTimeDeptendent.booleanValue()) {
            throw new RuntimeException("Error with method simulateEvents(): Source can't be time independent");
        }
        WG02_QkSimulations qkSim = new WG02_QkSimulations();
        qkSim.computeSimulatedEvents(this.totRupRate, this.getFinalSegMoRate(), this.segAperiodicity, this.rupInSeg, num);
        System.out.println("Rup rates: orig, sim, and sim/orig");
        for (i = 0; i < this.totRupRate.length; ++i) {
            simRate = qkSim.getSimAveRupRate(i);
            System.out.println((float)this.totRupRate[i] + "   " + (float)simRate + "   " + (float)(simRate / this.totRupRate[i]));
        }
        System.out.println("Seg rates: orig, sim, and sim/orig");
        for (i = 0; i < this.finalSegRate.length; ++i) {
            simRate = qkSim.getSimAveSegRate(i);
            System.out.println((float)this.finalSegRate[i] + "   " + (float)simRate + "   " + (float)(simRate / this.finalSegRate[i]));
        }
        System.out.println("Tot Moment rates: orig, sim, and sim/orig");
        double simMoRate = qkSim.getSimMoRate(this.rupMeanMag);
        double totMoRate = this.getTotalMoRateFromRups();
        System.out.println((float)totMoRate + "   " + (float)simMoRate + "   " + (float)(simMoRate / totMoRate));
        String[] segNames = new String[this.num_seg];
        for (int i2 = 0; i2 < this.num_seg; ++i2) {
            segNames[i2] = this.segmentData.getSegmentName(i2);
        }
        qkSim.plotSegmentRecurIntPDFs(segNames);
    }

    public double[] tryTimePredProbs(double duration, double startYear, double aperiodicity) {
        double[] segSlipLast = new double[this.num_seg];
        double[] segSlipRate = new double[this.num_seg];
        double[] segArea = new double[this.num_seg];
        double[] segTimeLast = new double[this.num_seg];
        for (int i = 0; i < this.num_seg; ++i) {
            segSlipLast[i] = this.segmentData.getSegAveSlipInLastEvent(i);
            segSlipRate[i] = this.segmentData.getSegmentSlipRate(i) * (1.0 - this.moRateReduction);
            segArea[i] = this.segmentData.getSegmentArea(i);
            segTimeLast[i] = this.segmentData.getSegCalYearOfLastEvent(i);
        }
        return TimePredictableQkProbCalc.getRupProbs(this.totRupRate, segSlipLast, segSlipRate, segArea, segTimeLast, this.rupInSeg, aperiodicity, startYear, duration);
    }

    static {
        nnls = new NNLSWrapper();
        somerville_magAreaRel = new Somerville_2006_MagAreaRel();
    }
}

