/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.griddedSeis;

import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Direction;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class Point2Vert_FaultPoisSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("Point2Vert_SS_FaultPoisSource");
    private boolean D = false;
    private IncrementalMagFreqDist magFreqDist;
    private static final double aveDip = 90.0;
    private double fracStrikeSlip = 0.0;
    private double fracNormal = 0.0;
    private double fracReverse = 0.0;
    private double duration;
    private MagLengthRelationship magLengthRelationship;
    private double magCutOff;
    private PointSurface ptSurface;
    private FrankelGriddedSurface finiteFaultSurface1;
    private FrankelGriddedSurface finiteFaultSurface2;
    private int numRuptures;
    private int ss_firstIndex;
    private int ss_lastIndex;
    private int n_firstIndex;
    private int n_lastIndex;
    private int rv_firstIndex;
    private int rv_lastIndex;
    private boolean isCrossHair = false;

    public Point2Vert_FaultPoisSource(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double duration, double magCutOff, double fracStrikeSlip, double fracNormal, double fracReverse) {
        this.magCutOff = magCutOff;
        this.probEqkRupture = new ProbEqkRupture();
        if (this.D) {
            System.out.println("magCutOff=" + magCutOff);
            System.out.println("num pts in magFreqDist=" + magFreqDist.getNum());
        }
        this.setAll(loc, magFreqDist, magLengthRelationship, strike, duration, fracStrikeSlip, fracNormal, fracReverse);
    }

    public Point2Vert_FaultPoisSource(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double duration, double magCutOff, double fracStrikeSlip, double fracNormal, double fracReverse, boolean isCrossHair) {
        this.magCutOff = magCutOff;
        this.isCrossHair = isCrossHair;
        this.probEqkRupture = new ProbEqkRupture();
        this.setAll(loc, magFreqDist, magLengthRelationship, duration, fracStrikeSlip, fracNormal, fracReverse);
    }

    public void setAll(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double duration, double fracStrikeSlip, double fracNormal, double fracReverse) {
        double strike = (Math.random() - 0.5) * 180.0;
        if (strike < 0.0) {
            strike += 360.0;
        }
        this.setAll(loc, magFreqDist, magLengthRelationship, strike, duration, fracStrikeSlip, fracNormal, fracReverse);
    }

    public void setAll(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double duration, double fracStrikeSlip, double fracNormal, double fracReverse) {
        if (this.D) {
            System.out.println("duration=" + duration);
        }
        if (this.D) {
            System.out.println("strike=" + strike);
        }
        this.duration = duration;
        this.magFreqDist = magFreqDist;
        this.magLengthRelationship = magLengthRelationship;
        this.fracNormal = fracNormal;
        this.fracReverse = fracReverse;
        this.fracStrikeSlip = fracStrikeSlip;
        if (Math.abs(1.0 - (fracNormal + fracReverse + fracStrikeSlip)) > 1.0E-6) {
            throw new RuntimeException("fractions must sum to 1.0");
        }
        int numMags = magFreqDist.getNum();
        this.ss_firstIndex = -1;
        this.ss_lastIndex = -1;
        this.n_firstIndex = -1;
        this.n_lastIndex = -1;
        this.rv_firstIndex = -1;
        this.rv_lastIndex = -1;
        this.numRuptures = 0;
        if (fracStrikeSlip > 0.0) {
            this.ss_firstIndex = 0;
            this.ss_lastIndex = numMags - 1;
            this.numRuptures += numMags;
        }
        if (fracNormal > 0.0) {
            this.n_firstIndex = this.numRuptures;
            this.n_lastIndex = this.n_firstIndex + numMags - 1;
            this.numRuptures += numMags;
        }
        if (fracReverse > 0.0) {
            this.rv_firstIndex = this.numRuptures;
            this.rv_lastIndex = this.rv_firstIndex + numMags - 1;
            this.numRuptures += numMags;
        }
        if (this.isCrossHair) {
            this.numRuptures += this.numRuptures;
        }
        double depth = 1.0;
        Location newLoc = loc.copy();
        newLoc.setDepth(depth);
        this.ptSurface = new PointSurface(newLoc);
        this.ptSurface.setAveDip(90.0);
        this.ptSurface.setAveStrike(strike);
        double maxMag = magFreqDist.getX(magFreqDist.getNum() - 1);
        if (maxMag > this.magCutOff) {
            double halfLength = magLengthRelationship.getMedianLength(maxMag) / 2.0;
            if (this.isCrossHair) {
                strike = 0.0;
            }
            Location loc1 = RelativeLocation.getLocation(loc, new Direction(0.0, halfLength, strike, Double.NaN));
            Direction dir = RelativeLocation.getDirection(loc1, loc);
            dir.setHorzDistance(dir.getHorzDistance() * 2.0);
            Location loc2 = RelativeLocation.getLocation(loc1, dir);
            FaultTrace fault = new FaultTrace("");
            fault.addLocation(loc1);
            fault.addLocation(loc2);
            this.finiteFaultSurface1 = new FrankelGriddedSurface(fault, 90.0, depth, depth, 1.0);
            if (this.isCrossHair) {
                strike = 90.0;
                loc1 = RelativeLocation.getLocation(loc, new Direction(0.0, halfLength, strike, Double.NaN));
                dir = RelativeLocation.getDirection(loc1, loc);
                dir.setHorzDistance(dir.getHorzDistance() * 2.0);
                loc2 = RelativeLocation.getLocation(loc1, dir);
                fault = new FaultTrace("");
                fault.addLocation(loc1);
                fault.addLocation(loc2);
                this.finiteFaultSurface2 = new FrankelGriddedSurface(fault, 90.0, depth, depth, 1.0);
            }
        }
    }

    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        if (this.finiteFaultSurface1 != null) {
            locList = this.finiteFaultSurface1.getLocationList();
        }
        if (this.finiteFaultSurface2 != null) {
            ListIterator it = this.finiteFaultSurface2.getLocationsIterator();
            while (it.hasNext()) {
                locList.addLocation((Location)it.next());
            }
        }
        if (this.ptSurface != null) {
            locList.addLocation(this.ptSurface.getLocation());
        }
        return locList;
    }

    public EvenlyGriddedSurfaceAPI getSourceSurface() {
        throw new RuntimeException("method not supported (not sure what to return)");
    }

    public int getNumRuptures() {
        return this.numRuptures;
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        boolean secondSurface = false;
        if (this.isCrossHair && nthRupture >= this.numRuptures / 2) {
            nthRupture -= this.numRuptures / 2;
            secondSurface = true;
        }
        double fraction = Double.NaN;
        double rake = Double.NaN;
        double dip = Double.NaN;
        int magIndex = -1;
        if (nthRupture >= this.ss_firstIndex && nthRupture <= this.ss_lastIndex) {
            rake = 0.0;
            dip = 90.0;
            magIndex = nthRupture - this.ss_firstIndex;
            fraction = this.fracStrikeSlip;
        } else if (nthRupture >= this.n_firstIndex && nthRupture <= this.n_lastIndex) {
            rake = -90.0;
            dip = 50.0;
            magIndex = nthRupture - this.n_firstIndex;
            fraction = this.fracNormal;
        } else if (nthRupture >= this.rv_firstIndex && nthRupture <= this.rv_lastIndex) {
            rake = 90.0;
            dip = 50.0;
            magIndex = nthRupture - this.rv_firstIndex;
            fraction = this.fracReverse;
        }
        double mag = this.magFreqDist.getX(magIndex);
        double depth = mag <= 6.5 ? 5.0 : 1.0;
        this.probEqkRupture.setMag(mag);
        this.probEqkRupture.setAveRake(rake);
        if (this.isCrossHair) {
            fraction /= 2.0;
        }
        double prob = 1.0 - Math.exp(-this.duration * fraction * this.magFreqDist.getY(magIndex));
        this.probEqkRupture.setProbability(prob);
        if (mag <= this.magCutOff) {
            if (this.ptSurface.getDepth() != depth) {
                this.ptSurface.setDepth(depth);
            }
            this.ptSurface.setAveDip(dip);
            this.probEqkRupture.setRuptureSurface(this.ptSurface);
        } else {
            FrankelGriddedSurface finiteFault = secondSurface ? this.finiteFaultSurface2 : this.finiteFaultSurface1;
            if (finiteFault.getLocation(0, 0).getDepth() != depth) {
                ListIterator it = finiteFault.getLocationsIterator();
                while (it.hasNext()) {
                    Location loc = (Location)it.next();
                    loc.setDepth(depth);
                }
            }
            if (magIndex == this.magFreqDist.getNum() - 1) {
                this.probEqkRupture.setRuptureSurface(finiteFault);
            } else {
                double rupLen = this.magLengthRelationship.getMedianLength(mag);
                double startPoint = (double)finiteFault.getNumCols() / 2.0 - 0.5 - rupLen / 2.0;
                GriddedSubsetSurface rupSurf = new GriddedSubsetSurface(1, Math.round((float)rupLen + 1.0f), 0, Math.round((float)startPoint), finiteFault);
                this.probEqkRupture.setRuptureSurface(rupSurf);
            }
        }
        return this.probEqkRupture;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    public double getMinDistance(Site site) {
        return RelativeLocation.getHorzDistance(site.getLocation(), this.ptSurface);
    }

    public String getName() {
        return C;
    }

    public static void main(String[] args) {
        Location loc = new Location(34.0, -118.0, 0.0);
        GutenbergRichterMagFreqDist dist = new GutenbergRichterMagFreqDist(5.0, 16, 0.2, 1.0E17, 0.9);
        WC1994_MagLengthRelationship wc_rel = new WC1994_MagLengthRelationship();
        double fracStrikeSlip = 0.3333333333333333;
        double fracNormal = 0.3333333333333333;
        double fracReverse = 0.3333333333333333;
        double duration = 1.0;
        Point2Vert_FaultPoisSource src = new Point2Vert_FaultPoisSource(loc, (IncrementalMagFreqDist)dist, (MagLengthRelationship)wc_rel, duration, 6.0, fracStrikeSlip, fracNormal, fracReverse, false);
        System.out.println("num rups =" + src.getNumRuptures() + "\ttotProb=" + src.computeTotalProb());
        System.out.println("Rupture mags and end locs:");
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            ProbEqkRupture rup = src.getRupture(r);
            System.out.println(r + "\t" + (float)rup.getMag() + "\t" + rup.getAveRake() + "\t" + rup.getProbability());
        }
    }
}

