/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.ValueWeight;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_PrioriRupRates;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.EventRates;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.SegRateConstraint;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.SegmentTimeDepData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.PrefFaultSectionDataFinal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class A_FaultsFetcher
extends FaultsFetcher
implements Serializable {
    private static final String RUP_RATE_FILE_NAME = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/A_Faults_aPrioriRates.xls";
    private static final String SEG_RATE_FILE_NAME = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/Appendix_C_Table7_091807.xls";
    private static final String SEG_TIME_DEP_FILE_NAME = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/SegmentTimeDepData_v06.xls";
    private HashMap<String, A_PrioriRupRates> aPrioriRupRatesMap;
    private HashMap<String, ArrayList> segEventRatesMap;
    private HashMap<String, ArrayList> segTimeDepDataMap;
    public static final String MIN_RATE_RUP_MODEL = "Min Rate Model";
    public static final String MAX_RATE_RUP_MODEL = "Max Rate Model";
    public static final String GEOL_INSIGHT_RUP_MODEL = "Geol Insight Solution";
    private PrefFaultSectionDataFinal faultSectionPrefDataFinal = new PrefFaultSectionDataFinal();
    private static final String A_FAULT_SEGMENTS_MODEL = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/SegmentModels.txt";
    private static final String UNSEGMENTED_MODEL = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/A_FaultUnsegmentedModels.txt";
    private ArrayList<EventRates> eventRatesList;

    public A_FaultsFetcher() {
        this.aPrioriRupRatesMap = new HashMap();
        this.readA_PrioriRupRates();
    }

    public void setDeformationModel(DeformationModelSummary defModelSummary, boolean isUnsegmented) {
        this.deformationModelId = defModelSummary.getDeformationModelId();
        this.isUnsegmented = isUnsegmented;
        String fileName = null;
        fileName = isUnsegmented ? UNSEGMENTED_MODEL : A_FAULT_SEGMENTS_MODEL;
        this.loadSegmentModels(fileName);
        this.readSegEventRates();
        this.readSegTimeDepData();
    }

    private void readA_PrioriRupRates() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(RUP_RATE_FILE_NAME));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int lastIndex = sheet.getLastRowNum();
            for (int r = 1; r <= lastIndex; ++r) {
                int i;
                HSSFRow row = sheet.getRow(r);
                HSSFCell cell = row.getCell((short)0);
                String faultName = cell.getStringCellValue().trim();
                this.faultModelNames.add(faultName);
                A_PrioriRupRates aPrioriRupRates = new A_PrioriRupRates(faultName);
                ArrayList<String> rupNames = new ArrayList<String>();
                row = sheet.getRow(++r);
                int lastColIndex = 0;
                ArrayList<String> rupModelTypes = new ArrayList<String>();
                int i2 = 1;
                while ((cell = row.getCell((short)i2)) != null && cell.getCellType() != 3) {
                    rupModelTypes.add(row.getCell((short)i2).getStringCellValue());
                    ++i2;
                    ++lastColIndex;
                }
                block4: while (true) {
                    int n = ++r;
                    ++r;
                    row = sheet.getRow(n);
                    cell = row.getCell((short)0);
                    String name = cell.getStringCellValue().trim();
                    if (name.equalsIgnoreCase("Total")) break;
                    rupNames.add(name);
                    i = 1;
                    while (true) {
                        if (i > lastColIndex) continue block4;
                        aPrioriRupRates.putRupRate((String)rupModelTypes.get(i - 1), row.getCell((short)i).getNumericCellValue());
                        ++i;
                    }
                    break;
                }
                ++r;
                String[] ruptureNames = new String[rupNames.size()];
                for (i = 0; i < rupNames.size(); ++i) {
                    ruptureNames[i] = (String)rupNames.get(i);
                }
                this.aPrioriRupRatesMap.put(faultName, aPrioriRupRates);
                this.segmentNamesMap.put(faultName, ruptureNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readSegEventRates() {
        this.segEventRatesMap = new HashMap();
        Iterator it = this.faultModelNames.iterator();
        while (it.hasNext()) {
            this.segEventRatesMap.put((String)it.next(), new ArrayList());
        }
        this.eventRatesList = new ArrayList();
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(SEG_RATE_FILE_NAME));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int lastRowIndex = sheet.getLastRowNum();
            for (int r = 1; r <= lastRowIndex; ++r) {
                HSSFCell cell;
                HSSFRow row = sheet.getRow(r);
                if (row == null || (cell = row.getCell((short)1)) == null || cell.getCellType() == 1) continue;
                double lat = cell.getNumericCellValue();
                String siteName = row.getCell((short)0).getStringCellValue().trim();
                double lon = row.getCell((short)2).getNumericCellValue();
                double rate = row.getCell((short)3).getNumericCellValue();
                double sigma = row.getCell((short)4).getNumericCellValue();
                double lower95Conf = row.getCell((short)7).getNumericCellValue();
                double upper95Conf = row.getCell((short)8).getNumericCellValue();
                int faultSectionId = this.getClosestFaultSectionId(new Location(lat, lon));
                if (faultSectionId == -1) continue;
                String faultName = this.setRecurIntv(faultSectionId, rate, sigma, lower95Conf, upper95Conf);
                this.eventRatesList.add(new EventRates(siteName, faultName, lat, lon, rate, sigma, lower95Conf, upper95Conf));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readSegTimeDepData() {
        this.segTimeDepDataMap = new HashMap();
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(SEG_TIME_DEP_FILE_NAME));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int lastIndex = sheet.getLastRowNum();
            for (int r = 1; r <= lastIndex; ++r) {
                HSSFRow row = sheet.getRow(r);
                HSSFCell cell = row.getCell((short)0);
                String faultName = cell.getStringCellValue().trim();
                int segIndex = -1;
                ArrayList<SegmentTimeDepData> segTimeDepDataList = new ArrayList<SegmentTimeDepData>();
                while (true) {
                    int n = ++r;
                    row = sheet.getRow(n);
                    if (row == null || (cell = row.getCell((short)0)) == null || cell.getCellType() == 3) break;
                    ++segIndex;
                    cell = row.getCell((short)1);
                    double lastEventYr = cell == null || cell.getCellType() == 3 ? Double.NaN : (double)((int)cell.getNumericCellValue());
                    cell = row.getCell((short)2);
                    double slip = cell == null || cell.getCellType() == 3 ? Double.NaN : cell.getNumericCellValue();
                    cell = row.getCell((short)3);
                    double aperiodicity = cell == null || cell.getCellType() == 3 ? Double.NaN : cell.getNumericCellValue();
                    SegmentTimeDepData segTimeDepData = new SegmentTimeDepData();
                    segTimeDepData.setAll(faultName, segIndex, lastEventYr, slip, aperiodicity);
                    segTimeDepDataList.add(segTimeDepData);
                }
                this.segTimeDepDataMap.put(faultName, segTimeDepDataList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList<SegmentTimeDepData> getSegTimeDepData(String faultName) {
        return this.segTimeDepDataMap.get(faultName);
    }

    public ArrayList<EventRates> getEventRatesList() {
        return this.eventRatesList;
    }

    private int getClosestFaultSectionId(Location loc) {
        ArrayList<Integer> faultSectionIdList = this.getAllFaultSectionsIdList();
        double minDist = Double.MAX_VALUE;
        FaultSectionPrefData closestFaultSection = null;
        for (int i = 0; i < faultSectionIdList.size(); ++i) {
            FaultSectionPrefData prefFaultSectionData = this.faultSectionPrefDataFinal.getFaultSectionPrefData(faultSectionIdList.get(i));
            double dist = prefFaultSectionData.getFaultTrace().getMinHorzDistToLine(loc);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closestFaultSection = prefFaultSectionData;
        }
        if (minDist > 2.0) {
            return -1;
        }
        return closestFaultSection.getSectionId();
    }

    private String setRecurIntv(int faultSectionId, double rate, double sigma, double lower95Conf, double upper95Conf) {
        for (String faultName : this.faultModels.keySet()) {
            ArrayList segRatesList = this.segEventRatesMap.get(faultName);
            ArrayList segmentsList = (ArrayList)this.faultModels.get(faultName);
            for (int i = 0; i < segmentsList.size(); ++i) {
                ArrayList segment = (ArrayList)segmentsList.get(i);
                for (int segIndex = 0; segIndex < segment.size(); ++segIndex) {
                    if (faultSectionId != ((FaultSectionSummary)segment.get(segIndex)).getSectionId()) continue;
                    SegRateConstraint segRateConstraint = new SegRateConstraint(faultName);
                    segRateConstraint.setSegRate(i, rate, sigma, lower95Conf, upper95Conf);
                    segRatesList.add(segRateConstraint);
                    return faultName;
                }
            }
        }
        throw new RuntimeException("The location cannot be mapped to a A-Fault segment");
    }

    @Override
    public ArrayList<SegRateConstraint> getSegRateConstraints(String faultName) {
        return this.segEventRatesMap.get(faultName);
    }

    public ArrayList<SegRateConstraint> getSegRateConstraints(String faultName, int segIndex) {
        ArrayList<SegRateConstraint> segRateConstraintList = this.getSegRateConstraints(faultName);
        ArrayList<SegRateConstraint> segmentRates = new ArrayList<SegRateConstraint>();
        for (int i = 0; i < segRateConstraintList.size(); ++i) {
            SegRateConstraint segRateConstraint = segRateConstraintList.get(i);
            if (segRateConstraint.getSegIndex() != segIndex) continue;
            segmentRates.add(segRateConstraint);
        }
        return segmentRates;
    }

    public ValueWeight[] getAprioriRupRates(String faultName, String rupModelType) {
        A_PrioriRupRates aPrioriRatesList = this.aPrioriRupRatesMap.get(faultName);
        ArrayList<Double> aPrioriRates = aPrioriRatesList.getA_PrioriRates(rupModelType);
        ValueWeight[] rupRates = new ValueWeight[aPrioriRates.size()];
        for (int i = 0; i < aPrioriRates.size(); ++i) {
            rupRates[i] = new ValueWeight(aPrioriRates.get(i), 1.0);
        }
        return rupRates;
    }

    public ArrayList<String> getRupModels(String faultName) {
        return this.aPrioriRupRatesMap.get(faultName).getSupportedModelNames();
    }
}

