/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.opensha.commons.data.Location;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultTrace;

public class PrefFaultSectionDataFinal
implements Serializable {
    private static ArrayList<FaultSectionPrefData> faultSectionsList;
    private static ArrayList<FaultSectionPrefData> dbFaultSectionsList;
    private static HashMap indexForID_Map;
    private static HashMap dbMap;
    private static final String XML_DATA_FILENAME = "PrefFaultSectionData.xml";
    int numSections = 0;
    ArrayList<Integer> faultNums = new ArrayList();

    public PrefFaultSectionDataFinal() {
        this.readFaultSectionDataFromXML();
    }

    private void test() {
        System.out.println("TESTING!");
        for (Integer num : this.faultNums) {
            int i = num;
            FaultSectionPrefData dbFault = dbFaultSectionsList.get((Integer)dbMap.get(new Integer(i)));
            FaultSectionPrefData fileFault = faultSectionsList.get((Integer)dbMap.get(new Integer(i)));
            if (dbFault.getSectionId() != fileFault.getSectionId()) {
                System.out.println("ERROR: Id's not equal!");
            }
            if (dbFault.getAseismicSlipFactor() != fileFault.getAseismicSlipFactor()) {
                System.out.println("ERROR: Test Failed 1");
            }
            if (dbFault.getAveDip() != fileFault.getAveDip()) {
                System.out.println("ERROR: Test Failed 2");
            }
            if (dbFault.getAveLowerDepth() != fileFault.getAveLowerDepth()) {
                System.out.println("ERROR: Test Failed 4");
            }
            if (dbFault.getAveUpperDepth() != fileFault.getAveUpperDepth()) {
                System.out.println("ERROR: Test Failed 6");
            }
            if (dbFault.getDipDirection() != fileFault.getDipDirection()) {
                System.out.println("ERROR: Test Failed 7");
            }
            if (dbFault.getSectionId() != fileFault.getSectionId()) {
                System.out.println("ERROR: Test Failed 9");
            }
            if (!dbFault.getSectionName().equals(fileFault.getSectionName())) {
                System.out.println("ERROR: Test Failed 10");
            }
            if (dbFault.getLength() != fileFault.getLength()) {
                System.out.println("ERROR: Test Failed 12");
            }
            if (dbFault.getDownDipWidth() != fileFault.getDownDipWidth()) {
                System.out.println("ERROR: Test Failed 13");
            }
            if (dbFault.getSlipRateStdDev() != fileFault.getSlipRateStdDev()) {
                System.out.println("ERROR: Test Failed 14");
            }
            FaultTrace dbTrace = dbFault.getFaultTrace();
            FaultTrace fileTrace = fileFault.getFaultTrace();
            for (int j = 0; j < dbTrace.getNumLocations(); ++j) {
                Location fileLoc;
                Location dbLoc = dbTrace.getLocationAt(j);
                if (dbLoc.equals(fileLoc = fileTrace.getLocationAt(j))) continue;
                System.out.println("Loc on fault trace is bad!");
                System.out.println(dbLoc);
                System.out.println(fileLoc);
            }
        }
    }

    private void writeFaultSectionDataFromDatabaseTo_XML() {
        PrefFaultSectionDataDB_DAO faultSectionDAO = new PrefFaultSectionDataDB_DAO(DB_AccessAPI.dbConnection);
        ArrayList faultSectionDataListFromDatabase = faultSectionDAO.getAllFaultSectionPrefData();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("PrefFaultSectionData");
        indexForID_Map = new HashMap();
        dbMap = new HashMap();
        for (int i = 0; i < faultSectionDataListFromDatabase.size(); ++i) {
            FaultSectionPrefData fspd = (FaultSectionPrefData)faultSectionDataListFromDatabase.get(i);
            root = fspd.toXMLMetadata(root);
            indexForID_Map.put(fspd.getSectionId(), new Integer(i));
            dbMap.put(fspd.getSectionId(), new Integer(i));
            this.faultNums.add(new Integer(fspd.getSectionId()));
            dbFaultSectionsList.add(fspd);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            System.out.println("Writing Pref Fault Section Data to PrefFaultSectionData.xml");
            XMLWriter writer = new XMLWriter(new FileWriter(XML_DATA_FILENAME), format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        faultSectionsList = faultSectionDataListFromDatabase;
    }

    private void readFaultSectionDataFromXML() {
        SAXReader reader = new SAXReader();
        faultSectionsList = new ArrayList();
        indexForID_Map = new HashMap();
        try {
            URL xmlURL = PrefFaultSectionDataFinal.class.getResource(XML_DATA_FILENAME);
            Document document = reader.read(xmlURL);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                try {
                    FaultSectionPrefData data = FaultSectionPrefData.fromXMLMetadata(el);
                    faultSectionsList.add(data);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            for (int i = 0; i < faultSectionsList.size(); ++i) {
                FaultSectionPrefData fspd = faultSectionsList.get(i);
                indexForID_Map.put(fspd.getSectionId(), new Integer(i));
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public ArrayList getAllFaultSectionPrefData() {
        return faultSectionsList;
    }

    public FaultSectionPrefData getFaultSectionPrefData(int faultSectionId) {
        int index = (Integer)indexForID_Map.get(faultSectionId);
        return faultSectionsList.get(index);
    }

    public static void main(String[] args) {
        PrefFaultSectionDataFinal test = new PrefFaultSectionDataFinal();
        ArrayList junk = test.getAllFaultSectionPrefData();
        FaultSectionPrefData faultSectionPrefData = (FaultSectionPrefData)junk.get(5);
        int id = faultSectionPrefData.getSectionId();
        System.out.println(id);
        FaultSectionPrefData faultSectionPrefData2 = test.getFaultSectionPrefData(id);
        System.out.println(faultSectionPrefData2.getSectionId());
        test.test();
    }

    static {
        dbFaultSectionsList = new ArrayList();
    }
}

