/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;

public class PointSurface
extends Location
implements EvenlyGriddedSurfaceAPI {
    protected double aveStrike = Double.NaN;
    protected double aveDip = Double.NaN;
    protected String name;

    public PointSurface() {
    }

    public PointSurface(double lat, double lon, double depth) {
        super(lat, lon, depth);
    }

    public PointSurface(Location loc) {
        super(loc.getLatitude(), loc.getLongitude(), loc.getDepth());
    }

    public void setAveStrike(double aveStrike) throws InvalidRangeException {
        FaultUtils.assertValidStrike(aveStrike);
        this.aveStrike = aveStrike;
    }

    public void setAveDip(double aveDip) throws InvalidRangeException {
        FaultUtils.assertValidDip(aveDip);
        this.aveDip = aveDip;
    }

    public void setLocation(int x, int y, Location location) throws ArrayIndexOutOfBoundsException {
        if (x != 0 || y != 0) {
            throw new ArrayIndexOutOfBoundsException("PointSurface can only have one point, i.e. x=0, y=0.");
        }
        this.setLocation(location);
    }

    public void setLocation(Location location) {
        this.setLatitude(location.getLatitude());
        this.setLongitude(location.getLongitude());
        this.setDepth(location.getDepth());
    }

    public void set(int row, int column, Object obj) throws ArrayIndexOutOfBoundsException, ClassCastException {
        if (row == 0 && column == 0) {
            if (!(obj instanceof Location) && !(obj instanceof PointSurface)) {
                throw new ArrayIndexOutOfBoundsException("Passed in  object must be Location or PointSurface.");
            }
        } else {
            throw new ArrayIndexOutOfBoundsException("PointSurface can only have one point, i.e. x=0, y=0.");
        }
        Location location = (Location)obj;
    }

    public double getAveStrike() {
        return this.aveStrike;
    }

    public double getAveDip() {
        return this.aveDip;
    }

    public Location getLocation() {
        return this.cloneLocation();
    }

    public Location getLocation(int row, int column) {
        return this.getLocation();
    }

    public ListIterator getLocationsIterator() {
        ArrayList<PointSurface> v = new ArrayList<PointSurface>();
        v.add(this);
        return v.listIterator();
    }

    public LocationList getLocationList() {
        LocationList locList = new LocationList();
        locList.addLocation(this);
        return locList;
    }

    public ListIterator getColumnIterator(int row) throws ArrayIndexOutOfBoundsException {
        return this.getLocationsIterator();
    }

    public ListIterator getRowIterator(int column) throws ArrayIndexOutOfBoundsException {
        return this.getLocationsIterator();
    }

    public ListIterator getAllByColumnsIterator() {
        return this.getLocationsIterator();
    }

    public ListIterator getAllByRowsIterator() {
        return this.getLocationsIterator();
    }

    public int getNumRows() {
        return 1;
    }

    public int getNumCols() {
        return 1;
    }

    public Object get(int row, int column) throws ArrayIndexOutOfBoundsException {
        if (row == 0 && column == 0) {
            return this.getLocation();
        }
        throw new ArrayIndexOutOfBoundsException("PointSurface can only have one point, i.e. x=0, y=0.");
    }

    protected Location cloneLocation() {
        Location location = new Location(this.getLatitude(), this.getLongitude(), this.getDepth());
        return location;
    }

    public ListIterator listIterator() {
        return this.getLocationsIterator();
    }

    public void clear() {
    }

    public boolean exist(int row, int column) {
        return row == 0 || column == 0;
    }

    public EvenlyGriddedSurfaceAPI getGridCenteredSurface() {
        return this;
    }

    public long size() {
        return 1L;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void delete(int row, int column) throws ArrayIndexOutOfBoundsException {
        if (row != 0 || column != 0) {
            throw new ArrayIndexOutOfBoundsException("PointSurface can only have one point, i.e. x=0, y=0.");
        }
        this.setLatitude(0.0);
        this.setLongitude(0.0);
        this.setDepth(0.0);
    }

    public double getSurfaceLength() {
        return 0.0;
    }

    public double getSurfaceWidth() {
        return 0.0;
    }

    public double getSurfaceArea() {
        return 0.0;
    }

    public String getSurfaceMetadata() {
        String surfaceMetadata = (float)this.aveDip + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.getSurfaceLength() + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.getSurfaceWidth() + "\t";
        surfaceMetadata = surfaceMetadata + "NaN\t";
        surfaceMetadata = surfaceMetadata + "1\t";
        surfaceMetadata = surfaceMetadata + "1\t";
        surfaceMetadata = surfaceMetadata + "1\n";
        surfaceMetadata = surfaceMetadata + "#Surface locations (Lat Lon Depth) \n";
        surfaceMetadata = surfaceMetadata + (float)this.getLatitude() + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.getLongitude() + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.getDepth();
        return surfaceMetadata;
    }

    public LocationList getSurfacePerimeterLocsList() {
        LocationList locList = new LocationList();
        locList.addLocation(this.getLocation());
        return locList;
    }

    public double getGridSpacing() {
        return Double.NaN;
    }
}

