/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.StringParameter;
import org.opensha.commons.param.editor.ConstrainedDoubleParameterEditor;
import org.opensha.commons.param.editor.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.gui.controls.PlotColorAndLineTypeSelectorControlPanelAPI;
import org.opensha.sha.gui.infoTools.PlotCurveCharacterstics;

public class PlotColorAndLineTypeSelectorControlPanel
extends JFrame
implements ActionListener,
ParameterChangeListener {
    private JPanel jPanel1 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JScrollPane colorAndLineTypeSelectorPanel = new JScrollPane();
    private StringParameter xAxisLabelParam;
    public static final String xAxisLabelParamName = "X-Axis Label";
    private StringParameter yAxisLabelParam;
    public static final String yAxisLabelParamName = "Y-Axis Label";
    private StringParameter plotLabelParam;
    public static final String plotLabelParamName = "Plot Label";
    private String xAxisLabel;
    private String yAxisLabel;
    private String plotLabel;
    private static final String colorChooserString = "Choose Color";
    private static final String lineTypeString = "Choose Line Type";
    public static final String lineWidthParamName = "Size -";
    public static final String SOLID_LINE = "Solid Line";
    public static final String DOTTED_LINE = "Dotted Line";
    public static final String DASHED_LINE = "Dash Line";
    public static final String DOT_DASH_LINE = "Dot and Dash Line";
    public static final String X = "X Symbols";
    public static final String CROSS_SYMBOLS = "+ Symbols";
    public static final String FILLED_CIRCLES = "Filled Circles";
    public static final String CIRCLES = "Circles";
    public static final String FILLED_SQUARES = "Filled Squares";
    public static final String SQUARES = "Squares";
    public static final String FILLED_TRIANGLES = "Filled Triangles";
    public static final String TRIANGLES = "Triangles";
    public static final String FILLED_INV_TRIANGLES = "Filled Inv. Triangles";
    public static final String INV_TRIANGLES = "Inv. Triangles";
    public static final String FILLED_DIAMONDS = "Filled Diamond";
    public static final String DIAMONDS = "Diamond";
    public static final String LINE_AND_CIRCLES = "Line and Circles";
    public static final String LINE_AND_TRIANGLES = "Line and Triangles";
    public static final String HISTOGRAM = "Histograms";
    public static final String STACKED_BAR = "Stacked Bar";
    private StringParameter tickFontSizeParam;
    public static final String tickFontSizeParamName = "Set tick label size";
    private StringParameter axisLabelsFontSizeParam;
    public static final String axislabelsFontSizeParamName = "Set axis label ";
    private StringParameter plotLabelsFontSizeParam;
    public static final String plotlabelsFontSizeParamName = "Set Plot label ";
    private ParameterList plotParamList;
    private ParameterListEditor plotParamEditor;
    private JLabel[] datasetSelector;
    private JButton[] colorChooserButton;
    private JComboBox[] lineTypeSelector;
    private DoubleParameter[] lineWidthParameter;
    private ConstrainedDoubleParameterEditor[] lineWidthParameterEditor;
    private JButton applyButton = new JButton();
    private JButton cancelButton = new JButton();
    private BorderLayout borderLayout1 = new BorderLayout();
    private ArrayList plottingFeatures;
    private ArrayList defaultPlottingFeatures;
    private JButton RevertButton = new JButton();
    private PlotColorAndLineTypeSelectorControlPanelAPI application;
    private JPanel curveFeaturePanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton doneButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private int tickLabelWidth;
    private int axisLabelWidth;
    private int plotLabelWidth;

    public PlotColorAndLineTypeSelectorControlPanel(PlotColorAndLineTypeSelectorControlPanelAPI api, ArrayList curveCharacterstics) {
        this.application = api;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Component parent = (Component)((Object)api);
        this.xAxisLabel = api.getXAxisLabel();
        this.yAxisLabel = api.getYAxisLabel();
        this.plotLabel = api.getPlotLabel();
        this.setLocation(parent.getX() + parent.getWidth() / 3, parent.getY() + parent.getHeight() / 2);
        ArrayList<String> supportedFontSizes = new ArrayList<String>();
        supportedFontSizes.add("8");
        supportedFontSizes.add("10");
        supportedFontSizes.add("12");
        supportedFontSizes.add("14");
        supportedFontSizes.add("16");
        supportedFontSizes.add("18");
        supportedFontSizes.add("20");
        supportedFontSizes.add("22");
        supportedFontSizes.add("24");
        this.tickFontSizeParam = new StringParameter(tickFontSizeParamName, supportedFontSizes, (String)supportedFontSizes.get(1));
        this.axisLabelsFontSizeParam = new StringParameter(axislabelsFontSizeParamName, supportedFontSizes, (String)supportedFontSizes.get(2));
        this.plotLabelsFontSizeParam = new StringParameter(plotlabelsFontSizeParamName, supportedFontSizes, (String)supportedFontSizes.get(2));
        this.tickFontSizeParam.addParameterChangeListener(this);
        this.axisLabelsFontSizeParam.addParameterChangeListener(this);
        this.plotLabelsFontSizeParam.addParameterChangeListener(this);
        this.tickLabelWidth = Integer.parseInt((String)this.tickFontSizeParam.getValue());
        this.axisLabelWidth = Integer.parseInt((String)this.axisLabelsFontSizeParam.getValue());
        this.plotLabelWidth = Integer.parseInt((String)this.plotLabelsFontSizeParam.getValue());
        this.xAxisLabelParam = new StringParameter(xAxisLabelParamName, this.xAxisLabel);
        this.yAxisLabelParam = new StringParameter(yAxisLabelParamName, this.yAxisLabel);
        this.plotLabelParam = new StringParameter(plotLabelParamName, this.plotLabel);
        this.xAxisLabelParam.addParameterChangeListener(this);
        this.yAxisLabelParam.addParameterChangeListener(this);
        this.plotLabelParam.addParameterChangeListener(this);
        this.plotParamList = new ParameterList();
        this.plotParamList.addParameter(this.tickFontSizeParam);
        this.plotParamList.addParameter(this.axisLabelsFontSizeParam);
        this.plotParamList.addParameter(this.xAxisLabelParam);
        this.plotParamList.addParameter(this.yAxisLabelParam);
        this.plotParamList.addParameter(this.plotLabelParam);
        this.plotParamList.addParameter(this.plotLabelsFontSizeParam);
        this.plotParamEditor = new ParameterListEditor(this.plotParamList);
        this.plotParamEditor.setTitle("Plot Label Prefs Setting");
        this.setPlotColorAndLineType(curveCharacterstics);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setFont(new Font("Arial", 0, 18));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setText("Plot Settings");
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotColorAndLineTypeSelectorControlPanel.this.applyButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotColorAndLineTypeSelectorControlPanel.this.cancelButton_actionPerformed(e);
            }
        });
        this.RevertButton.setText("Revert");
        this.RevertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotColorAndLineTypeSelectorControlPanel.this.RevertButton_actionPerformed(e);
            }
        });
        this.curveFeaturePanel.setLayout(this.gridBagLayout2);
        this.doneButton.setText("Done");
        this.doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotColorAndLineTypeSelectorControlPanel.this.doneButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 6, 0, 11), 0, 0));
        this.jPanel1.add((Component)this.colorAndLineTypeSelectorPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 6, 0, 11), 0, 0));
        this.colorAndLineTypeSelectorPanel.getViewport().add((Component)this.curveFeaturePanel, null);
        this.jPanel1.add((Component)this.cancelButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 22, 2, 108), 0, 0));
        this.jPanel1.add((Component)this.RevertButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 21, 2, 0), 0, 0));
        this.jPanel1.add((Component)this.doneButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 22, 2, 0), 0, 0));
        this.jPanel1.add((Component)this.applyButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 99, 2, 0), 0, 0));
        this.jPanel1.setSize(600, 500);
        this.setSize(600, 500);
    }

    public void setPlotColorAndLineType(ArrayList curveCharacterstics) {
        int i;
        int numCurves = curveCharacterstics.size();
        this.plottingFeatures = curveCharacterstics;
        this.defaultPlottingFeatures = new ArrayList();
        for (int i2 = 0; i2 < numCurves; ++i2) {
            PlotCurveCharacterstics curvePlotPref = (PlotCurveCharacterstics)this.plottingFeatures.get(i2);
            this.defaultPlottingFeatures.add(new PlotCurveCharacterstics(curvePlotPref.getCurveType(), curvePlotPref.getCurveColor(), curvePlotPref.getCurveWidth()));
        }
        this.datasetSelector = new JLabel[numCurves];
        this.colorChooserButton = new JButton[numCurves];
        this.lineTypeSelector = new JComboBox[numCurves];
        this.lineWidthParameter = new DoubleParameter[numCurves];
        this.lineWidthParameterEditor = new ConstrainedDoubleParameterEditor[numCurves];
        DoubleConstraint sizeConstraint = new DoubleConstraint(0.0, 20.0);
        for (i = 0; i < numCurves; ++i) {
            PlotCurveCharacterstics curvePlotPref = (PlotCurveCharacterstics)this.plottingFeatures.get(i);
            this.datasetSelector[i] = new JLabel(curvePlotPref.getCurveName());
            this.datasetSelector[i].setForeground(curvePlotPref.getCurveColor());
            this.colorChooserButton[i] = new JButton(colorChooserString);
            this.colorChooserButton[i].addActionListener(this);
            this.lineTypeSelector[i] = new JComboBox();
            this.lineTypeSelector[i].addItem(SOLID_LINE);
            this.lineTypeSelector[i].addItem(DOTTED_LINE);
            this.lineTypeSelector[i].addItem(DASHED_LINE);
            this.lineTypeSelector[i].addItem(DOT_DASH_LINE);
            this.lineTypeSelector[i].addItem(X);
            this.lineTypeSelector[i].addItem(CROSS_SYMBOLS);
            this.lineTypeSelector[i].addItem(FILLED_CIRCLES);
            this.lineTypeSelector[i].addItem(CIRCLES);
            this.lineTypeSelector[i].addItem(FILLED_SQUARES);
            this.lineTypeSelector[i].addItem(SQUARES);
            this.lineTypeSelector[i].addItem(FILLED_TRIANGLES);
            this.lineTypeSelector[i].addItem(TRIANGLES);
            this.lineTypeSelector[i].addItem(FILLED_INV_TRIANGLES);
            this.lineTypeSelector[i].addItem(INV_TRIANGLES);
            this.lineTypeSelector[i].addItem(FILLED_DIAMONDS);
            this.lineTypeSelector[i].addItem(DIAMONDS);
            this.lineTypeSelector[i].addItem(LINE_AND_CIRCLES);
            this.lineTypeSelector[i].addItem(LINE_AND_TRIANGLES);
            this.lineTypeSelector[i].addItem(HISTOGRAM);
            this.lineTypeSelector[i].setSelectedItem(curvePlotPref.getCurveType());
            this.lineTypeSelector[i].addActionListener(this);
            try {
                this.lineWidthParameter[i] = new DoubleParameter(lineWidthParamName + (i + 1), sizeConstraint, new Double(curvePlotPref.getCurveWidth()));
                this.lineWidthParameterEditor[i] = new ConstrainedDoubleParameterEditor(this.lineWidthParameter[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.curveFeaturePanel.removeAll();
        for (i = 0; i < numCurves; ++i) {
            this.curveFeaturePanel.add((Component)this.datasetSelector[i], new GridBagConstraints(0, i + 1, 1, 1, 1.0, 1.0, 17, 17, new Insets(4, 3, 5, 5), 0, 0));
            this.curveFeaturePanel.add((Component)this.colorChooserButton[i], new GridBagConstraints(1, i + 1, 1, 1, 1.0, 1.0, 10, 17, new Insets(4, 3, 5, 5), 0, 0));
            this.curveFeaturePanel.add((Component)this.lineTypeSelector[i], new GridBagConstraints(2, i + 1, 1, 1, 1.0, 1.0, 10, 17, new Insets(4, 3, 5, 5), 0, 0));
            this.curveFeaturePanel.add((Component)this.lineWidthParameterEditor[i], new GridBagConstraints(3, i + 1, 1, 1, 1.0, 1.0, 10, 17, new Insets(4, 3, 5, 5), 0, 0));
        }
        this.curveFeaturePanel.add((Component)this.plotParamEditor, new GridBagConstraints(1, numCurves + 1, 2, 1, 0.75, 1.0, 17, 1, new Insets(4, 3, 5, 5), 0, 0));
    }

    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equals(tickFontSizeParamName)) {
            this.tickLabelWidth = Integer.parseInt((String)this.tickFontSizeParam.getValue());
        } else if (paramName.equals(axislabelsFontSizeParamName)) {
            this.axisLabelWidth = Integer.parseInt((String)this.axisLabelsFontSizeParam.getValue());
        } else if (paramName.equals(plotlabelsFontSizeParamName)) {
            this.plotLabelWidth = Integer.parseInt((String)this.plotLabelsFontSizeParam.getValue());
        } else if (paramName.equals(xAxisLabelParamName)) {
            this.xAxisLabel = (String)this.xAxisLabelParam.getValue();
        } else if (paramName.equals(yAxisLabelParamName)) {
            this.yAxisLabel = (String)this.yAxisLabelParam.getValue();
        } else if (paramName.equals(plotLabelParamName)) {
            this.plotLabel = (String)this.plotLabelParam.getValue();
        }
        this.plotParamEditor.refreshParamEditor();
    }

    public void actionPerformed(ActionEvent e) {
        int numCurves = this.plottingFeatures.size();
        if (e.getSource() instanceof JButton) {
            Object button = e.getSource();
            for (int i = 0; i < numCurves; ++i) {
                Color color;
                PlotCurveCharacterstics curvePlotPref = (PlotCurveCharacterstics)this.plottingFeatures.get(i);
                if (!button.equals(this.colorChooserButton[i]) || (color = JColorChooser.showDialog(this, "Select Color", curvePlotPref.getCurveColor())) == null) continue;
                curvePlotPref.setCurveColor(color);
                this.datasetSelector[i].setForeground(color);
            }
        } else if (e.getSource() instanceof JComboBox) {
            Object comboBox = e.getSource();
            int itemIndex = 0;
            for (int i = 0; i < numCurves; ++i) {
                PlotCurveCharacterstics curvePlotPref = (PlotCurveCharacterstics)this.plottingFeatures.get(i);
                if (!comboBox.equals(this.lineTypeSelector[i])) continue;
                curvePlotPref.setCurveType((String)this.lineTypeSelector[i].getSelectedItem());
                itemIndex = i;
                break;
            }
            this.setStyleSizeBasedOnSelectedShape(itemIndex, (String)this.lineTypeSelector[itemIndex].getSelectedItem());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setStyleSizeBasedOnSelectedShape(int index, String selectedStyle) {
        block4: {
            block3: {
                block2: {
                    if (selectedStyle.equals("Solid Line")) break block2;
                    if (selectedStyle.equals("Dash Line")) break block2;
                    if (selectedStyle.equals("Dotted Line")) break block2;
                    if (!selectedStyle.equals("Dot and Dash Line") && !selectedStyle.equals("Histograms")) break block3;
                }
                this.lineWidthParameterEditor[index].setValue(new Double(1.0));
                break block4;
            }
            if (selectedStyle.equals("Line and Circles")) ** GOTO lbl-1000
            if (selectedStyle.equals("Line and Triangles")) lbl-1000:
            // 2 sources

            {
                this.lineWidthParameterEditor[index].setValue(new Double(1.0));
            } else {
                this.lineWidthParameterEditor[index].setValue(new Double(4.0));
            }
        }
        this.lineWidthParameterEditor[index].refreshParamEditor();
    }

    void applyButton_actionPerformed(ActionEvent e) {
        this.applyChangesToPlot();
    }

    private void applyChangesToPlot() {
        int numCurves = this.plottingFeatures.size();
        for (int i = 0; i < numCurves; ++i) {
            ((PlotCurveCharacterstics)this.plottingFeatures.get(i)).setCurveWidth((Double)this.lineWidthParameterEditor[i].getParameter().getValue());
        }
        this.application.setXAxisLabel(this.xAxisLabel);
        this.application.setYAxisLabel(this.yAxisLabel);
        this.application.setPlotLabel(this.plotLabel);
        this.application.plotGraphUsingPlotPreferences();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.revertPlotToOriginal();
        this.dispose();
    }

    void RevertButton_actionPerformed(ActionEvent e) {
        int flag = JOptionPane.showConfirmDialog(this, "Restore Original Values", "Reverting changes", 2);
        if (flag == 0) {
            this.revertPlotToOriginal();
        }
    }

    private void revertPlotToOriginal() {
        int numCurves = this.defaultPlottingFeatures.size();
        for (int i = 0; i < numCurves; ++i) {
            PlotCurveCharacterstics curveCharacterstics = (PlotCurveCharacterstics)this.defaultPlottingFeatures.get(i);
            this.datasetSelector[i].setForeground(curveCharacterstics.getCurveColor());
            ((PlotCurveCharacterstics)this.plottingFeatures.get(i)).setCurveColor(curveCharacterstics.getCurveColor());
            this.lineTypeSelector[i].setSelectedItem(curveCharacterstics.getCurveType());
            ((PlotCurveCharacterstics)this.plottingFeatures.get(i)).setCurveType(curveCharacterstics.getCurveType());
            this.lineWidthParameterEditor[i].setValue(new Double(curveCharacterstics.getCurveWidth()));
            this.lineWidthParameterEditor[i].refreshParamEditor();
            ((PlotCurveCharacterstics)this.plottingFeatures.get(i)).setCurveWidth(curveCharacterstics.getCurveWidth());
            this.curveFeaturePanel.repaint();
            this.curveFeaturePanel.validate();
            this.application.plotGraphUsingPlotPreferences();
        }
    }

    public int getAxisLabelFontSize() {
        return Integer.parseInt((String)this.axisLabelsFontSizeParam.getValue());
    }

    public void setAxisLabelFontSize(int fontSize) {
        this.axisLabelsFontSizeParam.setValue("" + fontSize);
    }

    public int getPlotLabelFontSize() {
        return Integer.parseInt((String)this.plotLabelsFontSizeParam.getValue());
    }

    public void setPlotLabelFontSize(int fontSize) {
        this.plotLabelsFontSizeParam.setValue("" + fontSize);
    }

    public int getTickLabelFontSize() {
        return Integer.parseInt((String)this.tickFontSizeParam.getValue());
    }

    public void setTickLabelFontSize(int fontSize) {
        this.tickFontSizeParam.setValue("" + fontSize);
    }

    void doneButton_actionPerformed(ActionEvent e) {
        this.applyChangesToPlot();
        this.dispose();
    }

    public String getXAxisLabel() {
        if (this.xAxisLabel != null) {
            return this.xAxisLabel;
        }
        return "";
    }

    public String getYAxisLabel() {
        if (this.yAxisLabel != null) {
            return this.yAxisLabel;
        }
        return "";
    }

    public String getPlotLabel() {
        if (this.plotLabel != null) {
            return this.plotLabel;
        }
        return "";
    }
}

