/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.data.Range;
import org.opensha.sha.gui.controls.AxisLimitsControlPanel;
import org.opensha.sha.gui.controls.AxisLimitsControlPanelAPI;
import org.opensha.sha.gui.controls.PlotColorAndLineTypeSelectorControlPanel;
import org.opensha.sha.gui.controls.PlotColorAndLineTypeSelectorControlPanelAPI;
import org.opensha.sha.gui.infoTools.ButtonControlPanelAPI;
import org.opensha.sha.gui.infoTools.PlotControllerAPI;

public class ButtonControlPanel
extends JPanel
implements AxisLimitsControlPanelAPI,
PlotColorAndLineTypeSelectorControlPanelAPI,
PlotControllerAPI,
ActionListener {
    private static final String AXIS_RANGE_NOT_ALLOWED = new String("First Choose Add Graph. Then choose Axis Scale option");
    ButtonControlPanelAPI application;
    private JPanel buttonPanel;
    private JPanel checkboxPanel;
    private JCheckBox jCheckylog;
    private JCheckBox jCheckxlog;
    private JButton setAxisButton;
    private JButton toggleButton;
    private JButton plotPrefsButton;
    private AxisLimitsControlPanel axisControlPanel;
    private PlotColorAndLineTypeSelectorControlPanel plotControl;
    private boolean customAxis = false;
    private int plotLabelFontSize = 12;
    private int axisLabelFontSize = 12;
    private int tickLabelFontSize = 10;

    public ButtonControlPanel(ButtonControlPanelAPI api) {
        this.application = api;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 4, 0, 4));
        this.plotPrefsButton = new JButton("Plot Prefs");
        this.plotPrefsButton.addActionListener(this);
        this.plotPrefsButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.plotPrefsButton.putClientProperty("JButton.segmentPosition", "first");
        this.plotPrefsButton.putClientProperty("JComponent.sizeVariant", "small");
        this.toggleButton = new JButton("Show Data");
        this.toggleButton.addActionListener(this);
        this.toggleButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.toggleButton.putClientProperty("JButton.segmentPosition", "middle");
        this.toggleButton.putClientProperty("JComponent.sizeVariant", "small");
        this.setAxisButton = new JButton("Set Axis");
        this.setAxisButton.addActionListener(this);
        this.setAxisButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.setAxisButton.putClientProperty("JButton.segmentPosition", "last");
        this.setAxisButton.putClientProperty("JComponent.sizeVariant", "small");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.plotPrefsButton);
        this.buttonPanel.add(this.toggleButton);
        this.buttonPanel.add(this.setAxisButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        JLabel logScale = new JLabel("Log scale: ");
        logScale.putClientProperty("JComponent.sizeVariant", "small");
        this.jCheckxlog = new JCheckBox("X");
        this.jCheckxlog.addActionListener(this);
        this.jCheckxlog.putClientProperty("JComponent.sizeVariant", "small");
        this.jCheckylog = new JCheckBox("Y");
        this.jCheckylog.addActionListener(this);
        this.jCheckylog.putClientProperty("JComponent.sizeVariant", "small");
        this.checkboxPanel = new JPanel();
        this.checkboxPanel.setLayout(new BoxLayout(this.checkboxPanel, 2));
        this.checkboxPanel.add(Box.createHorizontalGlue());
        this.checkboxPanel.add(logScale);
        this.checkboxPanel.add(this.jCheckxlog);
        this.checkboxPanel.add(this.jCheckylog);
        this.checkboxPanel.add(Box.createHorizontalGlue());
        this.add((Component)this.buttonPanel, "Center");
        this.add((Component)this.checkboxPanel, "Last");
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.jCheckxlog)) {
            this.application.setX_Log(this.jCheckxlog.isSelected());
        } else if (src.equals(this.jCheckylog)) {
            this.application.setY_Log(this.jCheckylog.isSelected());
        } else if (src.equals(this.setAxisButton)) {
            this.setAxisAction();
        } else if (src.equals(this.toggleButton)) {
            this.application.togglePlot();
        } else if (src.equals(this.plotPrefsButton)) {
            this.plotPrefsAction();
        }
    }

    public JPanel getButtonRow() {
        return this.buttonPanel;
    }

    public JPanel getCheckboxRow() {
        return this.checkboxPanel;
    }

    public void setToggleButtonText(String text) {
        this.toggleButton.setText(text);
    }

    private void setAxisAction() {
        Range xAxisRange = this.application.getX_AxisRange();
        Range yAxisRange = this.application.getY_AxisRange();
        if (xAxisRange == null || yAxisRange == null) {
            JOptionPane.showMessageDialog(this, AXIS_RANGE_NOT_ALLOWED);
            return;
        }
        double minX = xAxisRange.getLowerBound();
        double maxX = xAxisRange.getUpperBound();
        double minY = yAxisRange.getLowerBound();
        double maxY = yAxisRange.getUpperBound();
        if (this.customAxis) {
            if (this.axisControlPanel == null) {
                this.axisControlPanel = new AxisLimitsControlPanel(this, this, "Custom Scale", minX, maxX, minY, maxY);
            } else {
                this.axisControlPanel.setParams("Custom Scale", minX, maxX, minY, maxY);
            }
        } else if (this.axisControlPanel == null) {
            this.axisControlPanel = new AxisLimitsControlPanel(this, this, "Auto Scale", minX, maxX, minY, maxY);
        } else {
            this.axisControlPanel.setParams("Auto Scale", minX, maxX, minY, maxY);
        }
        this.axisControlPanel.pack();
        this.axisControlPanel.setVisible(true);
    }

    public void plotGraphUsingPlotPreferences() {
        this.application.plotGraphUsingPlotPreferences();
    }

    public void setAxisRange(double xMin, double xMax, double yMin, double yMax) {
        this.application.setAxisRange(xMin, xMax, yMin, yMax);
        this.customAxis = true;
    }

    public void setAutoRange() {
        this.application.setAutoRange();
        this.customAxis = false;
    }

    public void setXLog(boolean flag) {
        this.jCheckxlog.setSelected(flag);
    }

    public boolean isXLogSelected() {
        return this.jCheckxlog.isSelected();
    }

    public void setYLog(boolean flag) {
        this.jCheckylog.setSelected(flag);
    }

    public boolean isYLogSelected() {
        return this.jCheckylog.isSelected();
    }

    public void setEnabled(boolean flag) {
        this.jCheckxlog.setEnabled(flag);
        this.jCheckylog.setEnabled(flag);
        this.setAxisButton.setEnabled(flag);
        this.toggleButton.setEnabled(flag);
        this.plotPrefsButton.setEnabled(flag);
    }

    private void plotPrefsAction() {
        ArrayList plotFeatures = this.application.getPlottingFeatures();
        if (this.plotControl == null) {
            this.plotControl = new PlotColorAndLineTypeSelectorControlPanel(this, plotFeatures);
            this.plotControl.setTickLabelFontSize(this.tickLabelFontSize);
            this.plotControl.setPlotLabelFontSize(this.plotLabelFontSize);
            this.plotControl.setAxisLabelFontSize(this.axisLabelFontSize);
        } else {
            this.plotControl.setPlotColorAndLineType(plotFeatures);
        }
        this.plotControl.setVisible(true);
    }

    public int getAxisLabelFontSize() {
        if (this.plotControl != null) {
            return this.plotControl.getAxisLabelFontSize();
        }
        return this.axisLabelFontSize;
    }

    public int getTickLabelFontSize() {
        if (this.plotControl != null) {
            return this.plotControl.getTickLabelFontSize();
        }
        return this.tickLabelFontSize;
    }

    public int getPlotLabelFontSize() {
        if (this.plotControl != null) {
            return this.plotControl.getPlotLabelFontSize();
        }
        return this.plotLabelFontSize;
    }

    public void setPlotLabelFontSize(int fontSize) {
        if (this.plotControl != null) {
            this.plotControl.setPlotLabelFontSize(fontSize);
        }
        this.plotLabelFontSize = fontSize;
    }

    public void setTickLabelFontSize(int fontSize) {
        if (this.plotControl != null) {
            this.plotControl.setTickLabelFontSize(fontSize);
        }
        this.tickLabelFontSize = fontSize;
    }

    public void setAxisLabelFontSize(int fontSize) {
        if (this.plotControl != null) {
            this.plotControl.setAxisLabelFontSize(fontSize);
        }
        this.axisLabelFontSize = fontSize;
    }

    public void setPlotPreferencesButtonVisible(boolean flag) {
        this.plotPrefsButton.setVisible(false);
    }

    public String getXAxisLabel() {
        return this.application.getXAxisLabel();
    }

    public String getYAxisLabel() {
        return this.application.getYAxisLabel();
    }

    public String getPlotLabel() {
        return this.application.getPlotLabel();
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.application.setXAxisLabel(xAxisLabel);
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.application.setYAxisLabel(yAxisLabel);
    }

    public void setPlotLabel(String plotTitle) {
        this.application.setPlotLabel(plotTitle);
    }
}

