/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets.siteEffect;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.exceptions.RegionConstraintException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WillsSiteClass {
    public static final String WILLS_FILE = "data/siteType/Wills2000/usgs_cgs_geology_60s_mod.txt";
    ArrayList<Location> locations;
    String willsSiteClassFile;
    boolean loadFromJar = false;
    public static final double GRID_SPACING_FOR_VS30_IN_FILE = 0.0166;
    private Location lastLocation = null;

    public WillsSiteClass(double minLon, double maxLon, double minLat, double maxLat, double gridSpacing, String fileName) throws RegionConstraintException {
        this.prepareSitesInput(minLon, maxLon, minLat, maxLat, gridSpacing);
        this.willsSiteClassFile = fileName;
    }

    public WillsSiteClass(LocationList locList, String fileName) {
        int numLocations = locList.size();
        this.willsSiteClassFile = fileName;
        this.locations = new ArrayList();
        for (int i = 0; i < numLocations; ++i) {
            this.locations.add(locList.getLocationAt(i));
        }
    }

    private void prepareSitesInput(double minLon, double maxLon, double minLat, double maxLat, double gridSpacing) throws RegionConstraintException {
        this.locations = new ArrayList();
        GriddedRegion region = new GriddedRegion(new Location(minLat, minLon), new Location(maxLat, maxLon), gridSpacing, new Location(0.0, 0.0));
        for (Location loc : region.getNodeList()) {
            this.locations.add(loc);
        }
    }

    public void setLoadFromJar(boolean jar) {
        this.loadFromJar = jar;
    }

    public Location getLastLocation() {
        return this.lastLocation;
    }

    public ArrayList<String> getWillsSiteClass() {
        try {
            int i;
            InputStreamReader input = this.loadFromJar ? new InputStreamReader(this.getClass().getResourceAsStream(this.willsSiteClassFile)) : new FileReader(this.willsSiteClassFile);
            BufferedReader iBuf = new BufferedReader(input);
            String str = iBuf.readLine();
            int size = this.locations.size();
            ArrayList<String> vs30 = new ArrayList<String>();
            for (i = 0; i < size; ++i) {
                vs30.add("NA");
            }
            block3: for (i = 0; i < size; ++i) {
                double lat = this.locations.get(i).getLatitude();
                double lon = this.locations.get(i).getLongitude();
                boolean latFlag = false;
                while (str != null) {
                    StringTokenizer st = new StringTokenizer(str);
                    double valLat = Double.parseDouble(st.nextToken());
                    double valLon = Double.parseDouble(st.nextToken());
                    if (valLat - lat > 0.0083) continue block3;
                    if (Math.abs(lat - valLat) <= 0.0083) {
                        latFlag = true;
                    }
                    if (Math.abs(lon - valLon) <= 0.0083 && latFlag) {
                        vs30.set(i, st.nextToken());
                        if (i != size - 1) continue block3;
                        this.lastLocation = new Location(valLat, valLon);
                        continue block3;
                    }
                    if (valLon - lon > 0.0083 && latFlag) continue block3;
                    str = iBuf.readLine();
                }
            }
            return vs30;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

