/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr;

import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.Site;
import org.opensha.commons.param.BooleanParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceX_Parameter;
import org.opensha.sha.imr.param.PropagationEffectParams.WarningDoublePropagationEffectParameter;

public class PropagationEffect
implements Serializable,
ParameterChangeListener {
    private static final String C = "PropagationEffect";
    private static final boolean D = false;
    private boolean APPROX_HORZ_DIST = true;
    private boolean POINT_SRC_CORR = true;
    double seisDepth = 3.0;
    public static final String APPROX_DIST_PARAM_NAME = "Use Approximate Distance";
    private static final String APPROX_DIST_PARAM_INFO = "Horz. dist. calculated as: 111 * ( (lat1-lat2)^2 + (cos(0.5*(lat1+lat2))*(lon1-lon2))^2 )^0.5";
    BooleanParameter approxDistParam;
    public static final String POINT_SRC_CORR_PARAM_NAME = "Point-Source Correction";
    private static final String POINT_SRC_CORR_PARAM_INFO = "Use median distance correction for point sources";
    BooleanParameter pointSrcCorrParam;
    protected ParameterList adjustableParams;
    protected Site site = null;
    protected EqkRupture eqkRupture = null;
    protected double distanceRup;
    protected double distanceJB;
    protected boolean fix_dist_JB = false;
    protected double distanceSeis;
    protected double distanceX;
    protected DistanceX_Parameter distanceX_Parameter = new DistanceX_Parameter();
    protected boolean STALE = true;
    protected boolean DISTANCE_X_STALE = true;

    public PropagationEffect() {
        this.approxDistParam = new BooleanParameter(APPROX_DIST_PARAM_NAME, new Boolean(this.APPROX_HORZ_DIST));
        this.approxDistParam.setInfo(APPROX_DIST_PARAM_INFO);
        this.approxDistParam.addParameterChangeListener(this);
        this.pointSrcCorrParam = new BooleanParameter(POINT_SRC_CORR_PARAM_NAME, new Boolean(this.POINT_SRC_CORR));
        this.pointSrcCorrParam.setInfo(POINT_SRC_CORR_PARAM_INFO);
        this.pointSrcCorrParam.addParameterChangeListener(this);
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.approxDistParam);
        this.adjustableParams.addParameter(this.pointSrcCorrParam);
    }

    public PropagationEffect(Site site, EqkRupture eqkRupture) {
        this();
        this.site = site;
        this.eqkRupture = eqkRupture;
    }

    public Site getSite() {
        return this.site;
    }

    public EqkRupture getEqkRupture() {
        return this.eqkRupture;
    }

    public void setSite(Site site) {
        this.site = site;
        this.STALE = true;
        this.DISTANCE_X_STALE = true;
    }

    public void fixDistanceJB(boolean fixIt) {
        this.fix_dist_JB = fixIt;
    }

    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
        this.STALE = true;
        this.DISTANCE_X_STALE = true;
    }

    public void setAll(EqkRupture eqkRupture, Site site) {
        this.eqkRupture = eqkRupture;
        this.site = site;
        this.STALE = true;
        this.DISTANCE_X_STALE = true;
    }

    public Object getParamValue(String paramName) {
        if (this.STALE) {
            this.computeParamValues();
        }
        if (paramName.equals("DistanceRup")) {
            return new Double(this.distanceRup);
        }
        if (paramName.equals("DistanceJB")) {
            return new Double(this.distanceJB);
        }
        if (paramName.equals("DistanceSeis")) {
            return new Double(this.distanceSeis);
        }
        if (paramName.equals("DistanceX")) {
            if (this.DISTANCE_X_STALE) {
                this.computeDistanceX();
            }
            return new Double(this.distanceX);
        }
        throw new RuntimeException("Parameter not supported");
    }

    public double getDistanceRup() {
        if (this.STALE) {
            this.computeParamValues();
        }
        return this.distanceRup;
    }

    public double getDistanceJB() {
        if (this.STALE) {
            this.computeParamValues();
        }
        return this.distanceJB;
    }

    public double getDistanceSeis() {
        if (this.STALE) {
            this.computeParamValues();
        }
        return this.distanceSeis;
    }

    public double getDistanceX() {
        if (this.DISTANCE_X_STALE) {
            this.computeDistanceX();
        }
        return this.distanceX;
    }

    public void setParamValue(ParameterAPI param) {
        if (param instanceof WarningDoublePropagationEffectParameter) {
            ((WarningDoublePropagationEffectParameter)param).setValueIgnoreWarning(this.getParamValue(param.getName()));
        } else {
            param.setValue(this.getParamValue(param.getName()));
        }
    }

    public boolean isParamSupported(String paramName) {
        if (paramName.equals("DistanceRup")) {
            return true;
        }
        if (paramName.equals("DistanceJB")) {
            return true;
        }
        return paramName.equals("DistanceSeis");
    }

    public boolean isParamSupported(ParameterAPI param) {
        return this.isParamSupported(param.getName());
    }

    private void computeDistanceX() {
        this.distanceX = (Double)this.distanceX_Parameter.getValue(this.eqkRupture, this.site);
    }

    private void computeParamValues() {
        if (this.site != null && this.eqkRupture != null) {
            Location loc2;
            ListIterator it;
            Location loc1 = this.site.getLocation();
            this.distanceJB = Double.MAX_VALUE;
            this.distanceSeis = Double.MAX_VALUE;
            this.distanceRup = Double.MAX_VALUE;
            EvenlyGriddedSurfaceAPI rupSurf = this.eqkRupture.getRuptureSurface();
            int numLocs = rupSurf.getNumCols() * rupSurf.getNumRows();
            boolean projectToDepth = false;
            if (rupSurf.getNumRows() == 1 && rupSurf.getLocation(0, 0).getDepth() < this.seisDepth) {
                projectToDepth = true;
            }
            if (rupSurf.getAveDip() > 89.0) {
                it = rupSurf.getColumnIterator(0);
                if (rupSurf.getLocation(0, 0).getDepth() < this.seisDepth) {
                    projectToDepth = true;
                }
            } else {
                it = rupSurf.getLocationsIterator();
            }
            while (it.hasNext()) {
                double rupDist;
                loc2 = (Location)it.next();
                double vertDist = RelativeLocation.getVertDistance(loc1, loc2);
                double horzDist = this.APPROX_HORZ_DIST ? RelativeLocation.getApproxHorzDistance(loc1, loc2) : RelativeLocation.getHorzDistance(loc1, loc2);
                if (numLocs == 1 && this.POINT_SRC_CORR) {
                    double rupLen = Math.pow(10.0, -3.22 + 0.69 * this.eqkRupture.getMag());
                    double corr = 0.7071 + 0.29290000000000005 / (1.0 + Math.pow(rupLen / (horzDist * 0.87), 1.1));
                    horzDist *= corr;
                }
                if (horzDist < this.distanceJB) {
                    this.distanceJB = horzDist;
                }
                if ((rupDist = horzDist * horzDist + vertDist * vertDist) < this.distanceRup) {
                    this.distanceRup = rupDist;
                }
                if (loc2.getDepth() >= this.seisDepth) {
                    if (!(rupDist < this.distanceSeis)) continue;
                    this.distanceSeis = rupDist;
                    continue;
                }
                if (!projectToDepth || !((rupDist = horzDist * horzDist + this.seisDepth * this.seisDepth) < this.distanceSeis)) continue;
                this.distanceSeis = rupDist;
            }
            this.distanceRup = Math.pow(this.distanceRup, 0.5);
            this.distanceSeis = Math.pow(this.distanceSeis, 0.5);
            if (this.fix_dist_JB && rupSurf.getNumCols() > 1 && rupSurf.getNumRows() > 1) {
                loc1 = rupSurf.getLocation(0, 0);
                loc2 = rupSurf.getLocation(1, 1);
                double d1 = this.APPROX_HORZ_DIST ? RelativeLocation.getApproxHorzDistance(loc1, loc2) : RelativeLocation.getHorzDistance(loc1, loc2);
                loc1 = rupSurf.getLocation(0, 1);
                loc2 = rupSurf.getLocation(1, 0);
                double d2 = this.APPROX_HORZ_DIST ? RelativeLocation.getApproxHorzDistance(loc1, loc2) : RelativeLocation.getHorzDistance(loc1, loc2);
                double min_dist = Math.min(d1, d1) / 2.0;
                if (this.distanceJB <= min_dist) {
                    this.distanceJB = 0.0;
                }
            }
        } else {
            throw new RuntimeException("Site or EqkRupture is null");
        }
        this.STALE = false;
    }

    public void parameterChange(ParameterChangeEvent event) {
        this.APPROX_HORZ_DIST = (Boolean)this.approxDistParam.getValue();
        this.POINT_SRC_CORR = (Boolean)this.pointSrcCorrParam.getValue();
    }

    public ParameterList getAdjustableParameterList() {
        return this.adjustableParams;
    }

    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }
}

