/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Direction;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.DoubleDiscreteConstraint;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.StringParameter;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.PropagationEffect;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;

public class Abrahamson_2000_AttenRel
extends AttenuationRelationship
implements ScalarIntensityMeasureRelationshipAPI,
NamedObjectAPI {
    private static final String C = "Abrahamson_2000_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Abrahamson (2000)";
    public static final String SHORT_NAME = "Abrahamson2000";
    private static final long serialVersionUID = 1234567890987654351L;
    private static final String URL_INFO_STRING = "http://www.opensha.org/documentation/modelsImplemented/attenRel/Abrahamson_2000.html";
    public static final String FLT_TYPE_SS = "Strike Slip";
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_NAME = "AS Site Type";
    public static final String SITE_TYPE_INFO = "Geological conditions at the site";
    public static final String SITE_TYPE_ROCK = "Rock/Shallow-Soil";
    public static final String SITE_TYPE_SOIL = "Deep-Soil";
    public static final String SITE_TYPE_DEFAULT = "Rock/Shallow-Soil";
    protected static final Double MAG_WARN_MIN = new Double(4.5);
    protected static final Double MAG_WARN_MAX = new Double(8.0);
    protected static final Double DISTANCE_RUP_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_RUP_WARN_MAX = new Double(200.0);
    protected DoubleParameter thetaDirParam = null;
    public static final String THETA_NAME = "theta";
    public static final String THETA_UNITS = "degrees";
    protected static final Double THETA_MIN = new Double(-90.0);
    protected static final Double THETA_MAX = new Double(90.0);
    protected static final Double THETA_DEFAULT = new Double(0.0);
    public static final String THETA_INFO = "Angle Between Fault & Ray Path Directivity Parameter";
    protected DoubleParameter xDirParam = null;
    public static final String X_NAME = "X";
    protected static final String X_UNITS = null;
    protected static final Double X_MIN = new Double(0.0);
    protected static final Double X_MAX = new Double(1.0);
    protected static final Double X_DEFAULT = new Double(1.0);
    public static final String X_INFO = "Length Ratio Directivity Parameter";
    private Abrahamson_2000_AttenRelCoefficients coeff = null;
    protected Hashtable horzCoeffs = new Hashtable();
    private double a2;
    private double a4;
    private double a13;
    private double c1;
    private double c5;
    private double n;
    private transient ParameterChangeWarningListener warningListener = null;

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        if (!(rake < 22.5 && rake > -22.5 || rake < -157.5 && rake > 157.5)) {
            throw new InvalidRangeException("Abrahamson (2000) can only be used with strike-slip events (rake must be within 22.5 degrees of 0 or 180)");
        }
        this.fltTypeParam.setValue(FLT_TYPE_SS);
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((String)site.getParameter(SITE_TYPE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    public void setPropagationEffect(PropagationEffect propEffect) throws ParameterException, InvalidRangeException {
        this.site = propEffect.getSite();
        this.eqkRupture = propEffect.getEqkRupture();
        this.siteTypeParam.setValue((String)this.site.getParameter(SITE_TYPE_NAME).getValue());
        this.magParam.setValueIgnoreWarning(new Double(this.eqkRupture.getMag()));
        this.setFaultTypeFromRake(this.eqkRupture.getAveRake());
        propEffect.setParamValue(this.distanceRupParam);
        this.setDirectivityParams();
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
            this.setDirectivityParams();
        }
    }

    protected void setDirectivityParams() {
        double angleDiff;
        double L;
        EvenlyGriddedSurfaceAPI surface = this.eqkRupture.getRuptureSurface();
        Location siteLoc = this.site.getLocation();
        Location hypLoc = this.eqkRupture.getHypocenterLocation();
        if (hypLoc == null) {
            throw new RuntimeException("The hypocenter has not been set for the earthquake rupture!");
        }
        int numTrPts = surface.getNumCols();
        if (numTrPts == 1) {
            throw new RuntimeException("Abrahamson 2000 attenuation cannot compute directivity for point source.");
        }
        double closestDist = Double.MAX_VALUE;
        Location closestLoc = null;
        for (int c = 0; c < numTrPts; ++c) {
            double dist = RelativeLocation.getHorzDistance(siteLoc, surface.getLocation(0, c));
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestLoc = surface.getLocation(0, c);
        }
        double s = RelativeLocation.getHorzDistance(closestLoc, hypLoc);
        double x = s / (L = RelativeLocation.getHorzDistance(surface.getLocation(0, 0), surface.getLocation(0, numTrPts - 1)));
        if (x > 1.0 & x < 1.001) {
            x = 1.0;
        }
        this.xDirParam.setValue(x);
        if (s > 0.01) {
            double angle2;
            Direction dir = RelativeLocation.getDirection(hypLoc, siteLoc);
            double angle1 = dir.getAzimuth();
            if (angle1 < 0.0) {
                angle1 += 360.0;
            }
            if ((angle2 = (dir = RelativeLocation.getDirection(hypLoc, closestLoc)).getAzimuth()) < 0.0) {
                angle2 += 360.0;
            }
            if ((angleDiff = angle2 - angle1) < -90.0) {
                angleDiff += 360.0;
            } else if (angleDiff > 90.0) {
                angleDiff -= 360.0;
            }
        } else {
            angleDiff = 90.0;
        }
        this.thetaDirParam.setValue(angleDiff);
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Abrahamson_2000_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + this.saPeriodParam.getValue());
        }
        this.a2 = 0.512;
        this.a4 = -0.144;
        this.a13 = 0.17;
        this.c1 = 6.4;
        this.c5 = 0.03;
        this.n = 2.0;
        if (!this.horzCoeffs.containsKey(key.toString())) {
            throw new ParameterException("Abrahamson_2000_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + key);
        }
        this.coeff = (Abrahamson_2000_AttenRelCoefficients)this.horzCoeffs.get(key.toString());
    }

    public Abrahamson_2000_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    public double getMean() throws IMRException {
        double mean;
        double theta;
        double x;
        String siteType;
        double dist;
        double mag;
        try {
            mag = (Double)this.magParam.getValue();
            dist = (Double)this.distanceRupParam.getValue();
            String fltType = ((String)this.fltTypeParam.getValue()).toString();
            siteType = ((String)this.siteTypeParam.getValue()).toString();
            String component = ((String)this.componentParam.getValue()).toString();
            x = (Double)this.xDirParam.getValue();
            theta = (Double)this.thetaDirParam.getValue();
        }
        catch (NullPointerException e) {
            throw new IMRException("Abrahamson_2000_AttenRel: getMean(): Not all parameters have been set");
        }
        if (dist > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        double F = 0.0;
        int HW = 0;
        this.a2 = 0.512;
        this.a4 = -0.144;
        this.a13 = 0.17;
        this.c1 = 6.4;
        this.c5 = 0.03;
        this.n = 2.0;
        this.coeff = (Abrahamson_2000_AttenRelCoefficients)this.horzCoeffs.get("PGA");
        double rockMeanPGA = this.calcRockMean(mag, dist, F, HW);
        this.updateCoefficients();
        double rockMean = this.calcRockMean(mag, dist, F, HW);
        if (siteType.equals(SITE_TYPE_SOIL)) {
            double f5 = this.coeff.a10 + this.coeff.a11 * Math.log(Math.exp(rockMeanPGA) + this.c5);
            mean = rockMean + f5;
        } else {
            mean = rockMean;
        }
        double td = dist <= 30.0 ? 1.0 : (dist > 30.0 && dist <= 60.0 ? 1.0 - (dist - 30.0) / 30.0 : 0.0);
        double tm = mag <= 6.0 ? 0.0 : (mag > 6.0 && mag <= 6.5 ? 1.0 + (mag - 6.5) / 0.5 : 1.0);
        double cosTheta = Math.cos(theta * Math.PI / 180.0);
        double yDir = x <= 0.4 ? this.coeff.c1 + 1.88 * this.coeff.c2 * x * cosTheta : this.coeff.c1 + 0.75 * this.coeff.c2 * cosTheta;
        return mean += yDir * td * tm;
    }

    private double calcRockMean(double mag, double dist, double F, int HW) {
        double R = Math.sqrt(dist * dist + this.coeff.c4 * this.coeff.c4);
        double f1 = mag <= this.c1 ? this.coeff.a1 + this.a2 * (mag - this.c1) + this.coeff.a12 * Math.pow(8.5 - mag, this.n) + Math.log(R) * (this.coeff.a3 + this.a13 * (mag - this.c1)) : this.coeff.a1 + this.a4 * (mag - this.c1) + this.coeff.a12 * Math.pow(8.5 - mag, this.n) + Math.log(R) * (this.coeff.a3 + this.a13 * (mag - this.c1));
        double f3 = mag <= 5.8 ? this.coeff.a5 : (mag > 5.8 && mag < this.c1 ? this.coeff.a5 + (this.coeff.a6 - this.coeff.a5) * (mag - 5.8) / (this.c1 - 5.8) : this.coeff.a6);
        if (HW == 1) {
            double fHWM = mag <= 5.5 ? 0.0 : (mag > 5.5 && mag < 6.5 ? mag - 5.5 : 1.0);
            double fHWRrup = dist <= 4.0 ? 0.0 : (dist > 4.0 && dist <= 8.0 ? this.coeff.a9 * (dist - 4.0) / 4.0 : (dist > 8.0 && dist <= 18.0 ? this.coeff.a9 : (dist > 18.0 && dist <= 25.0 ? this.coeff.a9 * (1.0 - (dist - 18.0) / 7.0) : 0.0)));
            return f1 + F * f3 + fHWM * fHWRrup;
        }
        return f1 + F * f3;
    }

    public double getStdDev() throws IMRException {
        if (((String)this.stdDevTypeParam.getValue()).equals("None (zero)")) {
            return 0.0;
        }
        this.updateCoefficients();
        double mag = (Double)this.magParam.getValue();
        double sigma = mag <= 5.0 ? this.coeff.b5 : (mag > 5.0 && mag < 7.0 ? this.coeff.b5 - this.coeff.b6 * (mag - 5.0) : this.coeff.b5 - 2.0 * this.coeff.b6);
        return sigma -= 0.05 * this.coeff.c2 / 1.333;
    }

    public void setParamDefaults() {
        this.siteTypeParam.setValue("Rock/Shallow-Soil");
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.xDirParam.setValue(X_DEFAULT);
        this.thetaDirParam.setValue(THETA_DEFAULT);
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.xDirParam);
        this.meanIndependentParams.addParameter(this.thetaDirParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceRupParam);
        this.exceedProbIndependentParams.addParameter(this.siteTypeParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.xDirParam);
        this.exceedProbIndependentParams.addParameter(this.thetaDirParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString("Rock/Shallow-Soil");
        siteConstraint.addString(SITE_TYPE_SOIL);
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_SS);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_SS);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        DoubleConstraint thetaDirConstraint = new DoubleConstraint(THETA_MIN, THETA_MAX);
        thetaDirConstraint.setNonEditable();
        this.thetaDirParam = new DoubleParameter(THETA_NAME, thetaDirConstraint, THETA_UNITS);
        this.thetaDirParam.setInfo(THETA_INFO);
        this.thetaDirParam.setNonEditable();
        DoubleConstraint xDirConstraint = new DoubleConstraint(X_MIN, X_MAX);
        xDirConstraint.setNonEditable();
        this.xDirParam = new DoubleParameter(X_NAME, xDirConstraint, X_UNITS);
        this.xDirParam.setInfo(X_INFO);
        this.xDirParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.thetaDirParam);
        this.propagationEffectParams.addParameter(this.xDirParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.horzCoeffs.keys();
        while (keys.hasMoreElements()) {
            Abrahamson_2000_AttenRelCoefficients coeff = (Abrahamson_2000_AttenRelCoefficients)this.horzCoeffs.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(new Double(coeff.period));
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.setNonEditable();
        this.componentParam = new ComponentParam(constraint, "Average Horizontal");
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    protected void initCoefficients() {
        String S = "Abrahamson_2000_AttenRel: initCoefficients():";
        this.horzCoeffs.clear();
        Abrahamson_2000_AttenRelCoefficients coeff = new Abrahamson_2000_AttenRelCoefficients("PGA", 0.0, 5.6, 1.64, -1.145, 0.61, 0.26, 0.37, -0.417, -0.23, 0.0, 0.7, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff0 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("5.00"), 5.0, 3.5, -1.46, -0.725, 0.4, -0.2, 0.0, 0.664, 0.04, -0.215, 0.89, 0.087, -0.797, 1.757);
        Abrahamson_2000_AttenRelCoefficients coeff1 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("4.00"), 4.0, 3.5, -1.13, -0.725, 0.4, -0.2, 0.039, 0.64, 0.04, -0.1956, 0.88, 0.092, -0.713, 1.571);
        Abrahamson_2000_AttenRelCoefficients coeff2 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("3.00"), 3.0, 3.5, -0.69, -0.725, 0.4, -0.156, 0.089, 0.63, 0.04, -0.1726, 0.87, 0.097, -0.605, 1.333);
        Abrahamson_2000_AttenRelCoefficients coeff3 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("2.00"), 2.0, 3.5, -0.15, -0.725, 0.4, -0.094, 0.16, 0.61, 0.04, -0.14, 0.85, 0.105, -0.452, 0.998);
        Abrahamson_2000_AttenRelCoefficients coeff4 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("1.50"), 1.5, 3.55, 0.26, -0.7721, 0.438, -0.049, 0.21, 0.6, 0.04, -0.12, 0.84, 0.11, -0.344, 0.759);
        Abrahamson_2000_AttenRelCoefficients coeff5 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("1.00"), 1.0, 3.7, 0.828, -0.8383, 0.49, 0.013, 0.281, 0.423, 0.0, -0.102, 0.83, 0.118, -0.192, 0.423);
        Abrahamson_2000_AttenRelCoefficients coeff7 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.75"), 0.75, 3.9, 1.16, -0.8852, 0.528, 0.057, 0.331, 0.32, -0.05, -0.0862, 0.81, 0.123, -0.084, 0.185);
        Abrahamson_2000_AttenRelCoefficients coeff8 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.60"), 0.6, 4.12, 1.428, -0.9218, 0.557, 0.091, 0.37, 0.194, -0.089, -0.074, 0.81, 0.127, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff9 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.50"), 0.5, 4.3, 1.615, -0.9515, 0.581, 0.119, 0.37, 0.085, -0.121, -0.0635, 0.8, 0.13, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff10 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.46"), 0.46, 4.38, 1.717, -0.9652, 0.592, 0.132, 0.37, 0.02, -0.136, -0.0594, 0.8, 0.132, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff11 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.40"), 0.4, 4.52, 1.86, -0.988, 0.61, 0.154, 0.37, -0.065, -0.16, -0.0518, 0.79, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff12 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.36"), 0.36, 4.62, 1.955, -1.0052, 0.61, 0.17, 0.37, -0.123, -0.173, -0.046, 0.79, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff13 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.30"), 0.3, 4.8, 2.114, -1.035, 0.61, 0.198, 0.37, -0.219, -0.195, -0.036, 0.78, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff14 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.24"), 0.24, 4.97, 2.293, -1.079, 0.61, 0.232, 0.37, -0.35, -0.223, -0.0238, 0.77, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff15 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.20"), 0.2, 5.1, 2.406, -1.115, 0.61, 0.26, 0.37, -0.445, -0.245, -0.0138, 0.77, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff16 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.17"), 0.17, 5.19, 2.43, -1.135, 0.61, 0.26, 0.37, -0.522, -0.265, -0.004, 0.76, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff17 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.15"), 0.15, 5.27, 2.407, -1.145, 0.61, 0.26, 0.37, -0.577, -0.28, 0.005, 0.75, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff18 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.12"), 0.12, 5.39, 2.272, -1.145, 0.61, 0.26, 0.37, -0.591, -0.28, 0.018, 0.75, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff19 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.10"), 0.1, 5.5, 2.16, -1.145, 0.61, 0.26, 0.37, -0.598, -0.28, 0.028, 0.74, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff20 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.09"), 0.09, 5.54, 2.1, -1.145, 0.61, 0.26, 0.37, -0.609, -0.28, 0.03, 0.74, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff21 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.075"), 0.075, 5.58, 2.037, -1.145, 0.61, 0.26, 0.37, -0.628, -0.28, 0.03, 0.73, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff22 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.06"), 0.06, 5.6, 1.94, -1.145, 0.61, 0.26, 0.37, -0.665, -0.28, 0.03, 0.72, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff23 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.05"), 0.05, 5.6, 1.87, -1.145, 0.61, 0.26, 0.37, -0.62, -0.267, 0.028, 0.71, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff24 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.04"), 0.04, 5.6, 1.78, -1.145, 0.61, 0.26, 0.37, -0.555, -0.251, 0.0245, 0.71, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff25 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.03"), 0.03, 5.6, 1.69, -1.145, 0.61, 0.26, 0.37, -0.47, -0.23, 0.0143, 0.7, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff26 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.02"), 0.02, 5.6, 1.64, -1.145, 0.61, 0.26, 0.37, -0.417, -0.23, 0.0, 0.7, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff27 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.01"), 0.01, 5.6, 1.64, -1.145, 0.61, 0.26, 0.37, -0.417, -0.23, 0.0, 0.7, 0.135, 0.0, 0.0);
        Abrahamson_2000_AttenRelCoefficients coeff28 = new Abrahamson_2000_AttenRelCoefficients("SA/" + new Double("0.0"), 0.0, 5.6, 1.64, -1.145, 0.61, 0.26, 0.37, -0.417, -0.23, 0.0, 0.7, 0.135, 0.0, 0.0);
        this.horzCoeffs.put(coeff.getName(), coeff);
        this.horzCoeffs.put(coeff0.getName(), coeff0);
        this.horzCoeffs.put(coeff1.getName(), coeff1);
        this.horzCoeffs.put(coeff2.getName(), coeff2);
        this.horzCoeffs.put(coeff3.getName(), coeff3);
        this.horzCoeffs.put(coeff4.getName(), coeff4);
        this.horzCoeffs.put(coeff5.getName(), coeff5);
        this.horzCoeffs.put(coeff7.getName(), coeff7);
        this.horzCoeffs.put(coeff8.getName(), coeff8);
        this.horzCoeffs.put(coeff9.getName(), coeff9);
        this.horzCoeffs.put(coeff10.getName(), coeff10);
        this.horzCoeffs.put(coeff11.getName(), coeff11);
        this.horzCoeffs.put(coeff12.getName(), coeff12);
        this.horzCoeffs.put(coeff13.getName(), coeff13);
        this.horzCoeffs.put(coeff14.getName(), coeff14);
        this.horzCoeffs.put(coeff15.getName(), coeff15);
        this.horzCoeffs.put(coeff16.getName(), coeff16);
        this.horzCoeffs.put(coeff17.getName(), coeff17);
        this.horzCoeffs.put(coeff18.getName(), coeff18);
        this.horzCoeffs.put(coeff19.getName(), coeff19);
        this.horzCoeffs.put(coeff20.getName(), coeff20);
        this.horzCoeffs.put(coeff21.getName(), coeff21);
        this.horzCoeffs.put(coeff22.getName(), coeff22);
        this.horzCoeffs.put(coeff23.getName(), coeff23);
        this.horzCoeffs.put(coeff24.getName(), coeff24);
        this.horzCoeffs.put(coeff25.getName(), coeff25);
        this.horzCoeffs.put(coeff26.getName(), coeff26);
        this.horzCoeffs.put(coeff27.getName(), coeff27);
        this.horzCoeffs.put(coeff28.getName(), coeff28);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    public URL getInfoURL() throws MalformedURLException {
        return new URL(URL_INFO_STRING);
    }

    class Abrahamson_2000_AttenRelCoefficients
    implements NamedObjectAPI {
        protected static final String C = "Abrahamson_2000_AttenRelCoefficients";
        protected static final boolean D = true;
        private static final long serialVersionUID = 1234567890987654321L;
        protected String name;
        protected double period = -1.0;
        protected double c4;
        protected double a1;
        protected double a3;
        protected double a5;
        protected double a6;
        protected double a9;
        protected double a10;
        protected double a11;
        protected double a12;
        protected double b5;
        protected double b6;
        protected double c1;
        protected double c2;

        public Abrahamson_2000_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public Abrahamson_2000_AttenRelCoefficients(String name, double period, double c4, double a1, double a3, double a5, double a6, double a9, double a10, double a11, double a12, double b5, double b6, double c1, double c2) {
            this.name = name;
            this.period = period;
            this.c4 = c4;
            this.a1 = a1;
            this.a3 = a3;
            this.a5 = a5;
            this.a6 = a6;
            this.a9 = a9;
            this.a10 = a10;
            this.a11 = a11;
            this.a12 = a12;
            this.b5 = b5;
            this.b6 = b6;
            this.c1 = c1;
            this.c2 = c2;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  c4 = " + this.c4);
            b.append("\n  a1 = " + this.a1);
            b.append("\n  a2 = " + Abrahamson_2000_AttenRel.this.a2);
            b.append("\n  a3 = " + this.a3);
            b.append("\n  a4 = " + Abrahamson_2000_AttenRel.this.a4);
            b.append("\n  a5 = " + this.a5);
            b.append("\n  a6 = " + this.a6);
            b.append("\n  a9 = " + this.a9);
            b.append("\n  a10 = " + this.a10);
            b.append("\n  a11 = " + this.a11);
            b.append("\n  a12 = " + this.a12);
            b.append("\n  a13 = " + Abrahamson_2000_AttenRel.this.a13);
            b.append("\n  c1 = " + this.c1);
            b.append("\n  c5 = " + Abrahamson_2000_AttenRel.this.c5);
            b.append("\n  n = " + Abrahamson_2000_AttenRel.this.n);
            b.append("\n  b5 = " + this.b5);
            b.append("\n  b6 = " + this.b6);
            b.append("\n  c1 = " + this.c1);
            b.append("\n  c2 = " + this.c2);
            return b.toString();
        }
    }
}

