/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.DoubleDiscreteConstraint;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.WarningDoubleParameter;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.PropagationEffect;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class Field_2000_AttenRel
extends AttenuationRelationship
implements ScalarIntensityMeasureRelationshipAPI,
NamedObjectAPI {
    private static final String C = "Field_2000_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Field (2000)";
    public static final String SHORT_NAME = "Field2000";
    private static final long serialVersionUID = 1234567890987654362L;
    public static final String FLT_TYPE_OTHER = "Other/Unknown";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    protected WarningDoubleParameter basinDepthParam = null;
    public static final String BASIN_DEPTH_NAME = "Field-Basin-Depth";
    public static final String BASIN_DEPTH_UNITS = "km";
    public static final String BASIN_DEPTH_INFO = "Depth to 2.5 km/sec S-wave-velocity isosurface, from SCEC Phase III Report";
    protected static final Double BASIN_DEPTH_DEFAULT = new Double(0.0);
    protected static final Double BASIN_DEPTH_MIN = new Double(0.0);
    protected static final Double BASIN_DEPTH_MAX = new Double(30.0);
    protected static final Double VS30_WARN_MIN = new Double(180.0);
    protected static final Double VS30_WARN_MAX = new Double(3500.0);
    protected static final Double MAG_WARN_MIN = new Double(5.0);
    protected static final Double MAG_WARN_MAX = new Double(8.0);
    protected static final Double DISTANCE_JB_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_JB_WARN_MAX = new Double(150.0);
    private Field_2000_AttenRelCoefficients coeff = null;
    protected Hashtable coefficients = new Hashtable();
    private transient ParameterChangeWarningListener warningListener = null;

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        if (rake >= 45.0 && rake <= 135.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_OTHER);
        }
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.basinDepthParam.setValueIgnoreWarning((Double)site.getParameter(BASIN_DEPTH_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    public void setPropagationEffect(PropagationEffect propEffect) throws ParameterException, InvalidRangeException {
        this.site = propEffect.getSite();
        this.eqkRupture = propEffect.getEqkRupture();
        this.vs30Param.setValueIgnoreWarning((Double)this.site.getParameter("Vs30").getValue());
        this.basinDepthParam.setValueIgnoreWarning((Double)this.site.getParameter(BASIN_DEPTH_NAME).getValue());
        this.magParam.setValueIgnoreWarning(new Double(this.eqkRupture.getMag()));
        this.setFaultTypeFromRake(this.eqkRupture.getAveRake());
        propEffect.setParamValue(this.distanceJBParam);
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Field_2000_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        if (this.im.getName().equals("PGV")) {
            this.coeff = (Field_2000_AttenRelCoefficients)this.coefficients.get("SA/1.0");
        } else {
            StringBuffer key = new StringBuffer(this.im.getName());
            if (this.im.getName().equalsIgnoreCase("SA")) {
                key.append("/" + this.saPeriodParam.getValue());
            }
            if (this.coefficients.containsKey(key.toString())) {
                this.coeff = (Field_2000_AttenRelCoefficients)this.coefficients.get(key.toString());
            } else {
                throw new ParameterException("Field_2000_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + key);
            }
        }
    }

    public Field_2000_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean() throws IMRException {
        double b1;
        String fltTypeValue;
        double distanceJB;
        double vs30;
        double mag;
        try {
            mag = (Double)this.magParam.getValue();
            vs30 = (Double)this.vs30Param.getValue();
            distanceJB = (Double)this.distanceJBParam.getValue();
            fltTypeValue = ((String)this.fltTypeParam.getValue()).toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("Field_2000_AttenRel: getMean(): Not all parameters have been set");
        }
        if (distanceJB > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        this.updateCoefficients();
        if (fltTypeValue.equals(FLT_TYPE_REVERSE)) {
            b1 = this.coeff.b1rv;
        } else if (fltTypeValue.equals(FLT_TYPE_OTHER)) {
            b1 = this.coeff.b1ss;
        } else {
            throw new ParameterException("Field_2000_AttenRel: getMean(): Invalid EqkRupture Parameter value for : FaultType");
        }
        double mean = b1 + this.coeff.b2 * (mag - 6.0) + this.coeff.b3 * Math.pow(mag - 6.0, 2.0) + this.coeff.b5 * Math.log(Math.pow(distanceJB * distanceJB + this.coeff.h * this.coeff.h, 0.5)) + this.coeff.bv * Math.log(vs30 / 760.0);
        if (this.basinDepthParam.getValue() != null) {
            double depth = (Double)this.basinDepthParam.getValue();
            mean += this.coeff.bdSlope * depth + this.coeff.bdIntercept;
        }
        if (this.im.getName().equals("PGV")) {
            mean += Math.log(94.6658);
        }
        return mean;
    }

    public double getStdDev() throws IMRException {
        double temp_std;
        double mag;
        String stdDevType = ((String)this.stdDevTypeParam.getValue()).toString();
        try {
            mag = (Double)this.magParam.getValue();
        }
        catch (NullPointerException e) {
            throw new IMRException("Field_2000_AttenRel: getMean(): Not all parameters have been set");
        }
        if (mag > 7.0) {
            mag = 7.0;
        }
        this.updateCoefficients();
        if (stdDevType.equals("Total (Mag Dependent)")) {
            temp_std = Math.sqrt(this.coeff.intra_slope * mag + this.coeff.intra_intercept + this.coeff.tau * this.coeff.tau);
        } else if (stdDevType.equals("Total")) {
            temp_std = Math.sqrt(this.coeff.intra_mag_ind * this.coeff.intra_mag_ind + this.coeff.tau * this.coeff.tau);
        } else if (stdDevType.equals("Inter-Event")) {
            temp_std = this.coeff.tau;
        } else if (stdDevType.equals("Intra-Event (Mag Dependent)")) {
            temp_std = Math.sqrt(this.coeff.intra_slope * mag + this.coeff.intra_intercept);
        } else if (stdDevType.equals("Intra-Event")) {
            temp_std = this.coeff.intra_mag_ind;
        } else if (stdDevType.equals("None (zero)")) {
            temp_std = 0.0;
        } else {
            throw new ParameterException("Field_2000_AttenRel: getStdDev(): Invalid StdDevType");
        }
        return temp_std;
    }

    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.distanceJBParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.basinDepthParam.setValue(BASIN_DEPTH_DEFAULT);
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.basinDepthParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceJBParam);
        this.exceedProbIndependentParams.addParameter(this.vs30Param);
        this.exceedProbIndependentParams.addParameter(this.basinDepthParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        DoubleConstraint basinDepthConstraint = new DoubleConstraint(BASIN_DEPTH_MIN, BASIN_DEPTH_MAX);
        basinDepthConstraint.setNullAllowed(true);
        basinDepthConstraint.setNonEditable();
        this.basinDepthParam = new WarningDoubleParameter(BASIN_DEPTH_NAME, basinDepthConstraint, BASIN_DEPTH_UNITS);
        this.basinDepthParam.setInfo(BASIN_DEPTH_INFO);
        this.basinDepthParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.basinDepthParam);
    }

    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_OTHER);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_OTHER);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        this.distanceJBParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.coefficients.keys();
        while (keys.hasMoreElements()) {
            Field_2000_AttenRelCoefficients coeff = (Field_2000_AttenRelCoefficients)this.coefficients.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(new Double(coeff.period));
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.pgvParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.setNonEditable();
        this.componentParam = new ComponentParam(constraint, "Average Horizontal");
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total (Mag Dependent)");
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event (Mag Dependent)");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint, "Total (Mag Dependent)");
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    protected void initCoefficients() {
        String S = "Field_2000_AttenRel: initCoefficients():";
        this.coefficients.clear();
        Field_2000_AttenRelCoefficients coeff = new Field_2000_AttenRelCoefficients("PGA", 0.0, 0.853, 0.872, 0.442, -0.067, -0.96, -0.154, 8.9, 0.067, -0.14, -0.1, 0.8771, 0.23, 0.47);
        Field_2000_AttenRelCoefficients coeff0 = new Field_2000_AttenRelCoefficients("SA/" + new Double("0.0"), 0.0, 0.853, 0.872, 0.442, -0.067, -0.96, -0.154, 8.9, 0.067, -0.14, -0.1, 0.8771, 0.23, 0.47);
        Field_2000_AttenRelCoefficients coeff1 = new Field_2000_AttenRelCoefficients("SA/" + new Double("0.3"), 0.3, 0.995, 1.096, 0.501, -0.112, -0.841, -0.35, 7.2, 0.057, -0.12, -0.11, 0.9924, 0.26, 0.53);
        Field_2000_AttenRelCoefficients coeff2 = new Field_2000_AttenRelCoefficients("SA/" + new Double("1.0"), 1.0, -0.164, -0.267, 0.903, 0.0, -0.914, -0.704, 6.2, 0.12, -0.25, -0.1, 0.9516, 0.22, 0.53);
        Field_2000_AttenRelCoefficients coeff3 = new Field_2000_AttenRelCoefficients("SA/" + new Double("3.0"), 3.0, -2.267, -2.681, 1.083, 0.0, -0.72, -0.674, 3.0, 0.11, -0.18, 0.14, -0.66, 0.3, 0.52);
        this.coefficients.put(coeff.getName(), coeff);
        this.coefficients.put(coeff0.getName(), coeff0);
        this.coefficients.put(coeff1.getName(), coeff1);
        this.coefficients.put(coeff2.getName(), coeff2);
        this.coefficients.put(coeff3.getName(), coeff3);
    }

    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/Field_2000.html");
    }

    class Field_2000_AttenRelCoefficients
    implements NamedObjectAPI {
        protected static final String C = "Field_2000_AttenRelCoefficients";
        protected static final boolean D = false;
        private static final long serialVersionUID = 1234567890987654327L;
        protected String name;
        protected double period = -1.0;
        protected double b1ss;
        protected double b1rv;
        protected double b2;
        protected double b3;
        protected double b5;
        protected double bv;
        protected double h;
        protected double bdSlope;
        protected double bdIntercept;
        protected double intra_slope;
        protected double intra_intercept;
        protected double tau;
        protected double intra_mag_ind;

        public Field_2000_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public Field_2000_AttenRelCoefficients(String name, double period, double b1ss, double b1rv, double b2, double b3, double b5, double bv, double h, double bdSlope, double bdIntercept, double intra_slope, double intra_intercept, double tau, double intra_mag_ind) {
            this.name = name;
            this.period = period;
            this.b1ss = b1ss;
            this.b1rv = b1rv;
            this.b2 = b2;
            this.b3 = b3;
            this.b5 = b5;
            this.bv = bv;
            this.h = h;
            this.bdSlope = bdSlope;
            this.bdIntercept = bdIntercept;
            this.intra_slope = intra_slope;
            this.intra_intercept = intra_intercept;
            this.tau = tau;
            this.intra_mag_ind = intra_mag_ind;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  b1ss = " + this.b1ss);
            b.append("\n  b1rv = " + this.b1rv);
            b.append("\n  b2 = " + this.b2);
            b.append("\n  b3 = " + this.b3);
            b.append("\n  b5 = " + this.b5);
            b.append("\n  bv = " + this.bv);
            b.append("\n  h = " + this.h);
            b.append("\n  bdSlope = " + this.bdSlope);
            b.append("\n  bdIntercept = " + this.bdIntercept);
            b.append("\n  intra_slope = " + this.intra_slope);
            b.append("\n  intra_intercept = " + this.intra_intercept);
            b.append("\n  tau = " + this.tau);
            b.append("\n  intra_mag_ind = " + this.intra_mag_ind);
            return b.toString();
        }
    }
}

