/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import java.io.Serializable;
import org.opensha.commons.calc.MomentMagCalc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.exceptions.DataPoint2DException;
import org.opensha.commons.exceptions.DiscretizedFuncException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.magdist.IncrementalMagFreqDistAPI;

public class IncrementalMagFreqDist
extends EvenlyDiscretizedFunc
implements IncrementalMagFreqDistAPI,
Serializable {
    private boolean D = false;
    protected String defaultInfo;
    protected String defaultName;

    public IncrementalMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
        this.setTolerance(delta / 1000000.0);
    }

    public IncrementalMagFreqDist(double min, double max, int num) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
        this.setTolerance(this.delta / 1000000.0);
    }

    public double getIncrRate(double mag) throws DataPoint2DException {
        int xIndex = this.getXIndex(mag);
        return this.getIncrRate(xIndex);
    }

    public double getIncrRate(int index) {
        return this.getY(index);
    }

    public double getCumRate(double mag) throws DataPoint2DException {
        return this.getCumRate(this.getXIndex(mag));
    }

    public double getCumRate(int index) {
        double sum = 0.0;
        for (int i = index; i < this.num; ++i) {
            sum += this.getIncrRate(i);
        }
        return sum;
    }

    public double getMomentRate(double mag) throws DataPoint2DException {
        return this.getIncrRate(mag) * MomentMagCalc.getMoment(mag);
    }

    public double getMomentRate(int index) {
        return this.getIncrRate(index) * MomentMagCalc.getMoment(this.getX(index));
    }

    public double getTotalMomentRate() {
        double sum = 0.0;
        for (int i = 0; i < this.num; ++i) {
            sum += this.getMomentRate(i);
        }
        return sum;
    }

    public double getTotalIncrRate() {
        double sum = 0.0;
        for (int i = 0; i < this.num; ++i) {
            sum += this.getIncrRate(i);
        }
        return sum;
    }

    public void normalizeByTotalRate() throws DataPoint2DException {
        double totalIncrRate = this.getTotalIncrRate();
        for (int i = 0; i < this.num; ++i) {
            double newRate = this.getIncrRate(i) / totalIncrRate;
            super.set(i, newRate);
        }
    }

    public EvenlyDiscretizedFunc getCumRateDist() throws DataPoint2DException {
        EvenlyDiscretizedFunc cumRateDist = new EvenlyDiscretizedFunc(this.minX, this.num, this.delta);
        double sum = 0.0;
        for (int i = this.num - 1; i >= 0; --i) {
            cumRateDist.set(i, sum += this.getIncrRate(i));
        }
        cumRateDist.setInfo(this.getInfo());
        cumRateDist.setName(this.getName());
        return cumRateDist;
    }

    public EvenlyDiscretizedFunc getCumRateDistWithOffset() throws DataPoint2DException {
        EvenlyDiscretizedFunc cumRateDist = new EvenlyDiscretizedFunc(this.minX - this.delta / 2.0, this.num, this.delta);
        double sum = 0.0;
        for (int i = this.num - 1; i >= 0; --i) {
            cumRateDist.set(i, sum += this.getIncrRate(i));
        }
        cumRateDist.setInfo(this.getInfo());
        cumRateDist.setName(this.getName());
        return cumRateDist;
    }

    public EvenlyDiscretizedFunc getMomentRateDist() throws DataPoint2DException {
        EvenlyDiscretizedFunc momentRateDist = new EvenlyDiscretizedFunc(this.minX, this.num, this.delta);
        for (int i = this.num - 1; i >= 0; --i) {
            momentRateDist.set(i, this.getMomentRate(i));
        }
        momentRateDist.setInfo(this.getInfo());
        momentRateDist.setName(this.getName());
        return momentRateDist;
    }

    public void scaleToTotalMomentRate(double newTotMoRate) throws DataPoint2DException {
        double oldTotMoRate = this.getTotalMomentRate();
        if (this.D) {
            System.out.println("old Mo. Rate = " + oldTotMoRate);
        }
        if (this.D) {
            System.out.println("target Mo. Rate = " + newTotMoRate);
        }
        double scaleRate = newTotMoRate / oldTotMoRate;
        for (int i = 0; i < this.num; ++i) {
            super.set(i, scaleRate * this.getIncrRate(i));
        }
        if (this.D) {
            System.out.println("actual Mo. Rate = " + this.getTotalMomentRate());
        }
    }

    public void scaleToCumRate(double mag, double rate) throws DataPoint2DException {
        int index = this.getXIndex(mag);
        this.scaleToCumRate(index, rate);
    }

    public void scaleToCumRate(int index, double rate) throws DataPoint2DException {
        double temp = this.getCumRate(index);
        double scaleCumRate = rate / temp;
        for (int i = 0; i < this.num; ++i) {
            super.set(i, scaleCumRate * this.getIncrRate(i));
        }
    }

    public void scaleToIncrRate(double mag, double newRate) throws DataPoint2DException {
        int index = this.getXIndex(mag);
        this.scaleToIncrRate(index, newRate);
    }

    public void scaleToIncrRate(int index, double newRate) throws DataPoint2DException {
        double temp = this.getIncrRate(index);
        double scaleIncrRate = newRate / temp;
        for (int i = 0; i < this.num; ++i) {
            super.set(i, scaleIncrRate * this.getIncrRate(i));
        }
    }

    public String getDefaultInfo() {
        return this.defaultInfo;
    }

    public String getDefaultName() {
        this.defaultName = "Incremental Mag Freq Dist";
        return this.defaultName;
    }

    public String getName() {
        if (this.name != null && !this.name.trim().equals("")) {
            return super.getName();
        }
        return this.getDefaultName();
    }

    public String getInfo() {
        if (this.info != null && !this.info.trim().equals("")) {
            return super.getInfo();
        }
        return this.getDefaultInfo();
    }

    public IncrementalMagFreqDist deepClone() throws DataPoint2DException {
        IncrementalMagFreqDist f = new IncrementalMagFreqDist(this.minX, this.num, this.delta);
        f.tolerance = this.tolerance;
        f.setInfo(this.getInfo());
        f.setName(this.getName());
        for (int i = 0; i < this.num; ++i) {
            f.set(i, this.points[i]);
        }
        return f;
    }
}

