/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.util.Arrays;
import java.util.ListIterator;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.step.calc.NoValMatchFoundException;
import org.opensha.step.calc.NoValsFoundException;

public class ListSortingTools {
    public static double getMinVal(double[] valList) {
        double minVal = valList[0];
        int size = valList.length;
        for (int valLoop = 1; valLoop < size; ++valLoop) {
            if (!(valList[valLoop] < minVal)) continue;
            minVal = valList[valLoop];
        }
        return minVal;
    }

    public static double getMaxVal(double[] valList) {
        double maxVal = valList[0];
        int size = valList.length;
        for (int valLoop = 1; valLoop < size; ++valLoop) {
            if (!(valList[valLoop] > maxVal)) continue;
            maxVal = valList[valLoop];
        }
        return maxVal;
    }

    public static int getMaxVal(int[] valList) {
        int maxVal = valList[0];
        int size = valList.length;
        for (int valLoop = 1; valLoop < size; ++valLoop) {
            if (valList[valLoop] <= maxVal) continue;
            maxVal = valList[valLoop];
        }
        return maxVal;
    }

    public static long getMaxVal(long[] valList) {
        Arrays.sort(valList);
        return valList[valList.length - 1];
    }

    public static long getMinVal(long[] valList) {
        Arrays.sort(valList);
        return valList[0];
    }

    public static double getMeanVal(double[] valList) {
        double sum = 0.0;
        int size = valList.length;
        for (int valLoop = 0; valLoop < size; ++valLoop) {
            sum += valList[valLoop];
        }
        return sum / (double)size;
    }

    public static int findIndex(double val, double[] valList) throws NoValMatchFoundException {
        int size = valList.length;
        int indMatch = -1;
        for (int indLoop = 0; indLoop < size; ++indLoop) {
            if (val != valList[indLoop]) continue;
            indMatch = indLoop;
            break;
        }
        if (indMatch != -1) {
            return indMatch;
        }
        throw new NoValMatchFoundException();
    }

    public static int findIndex(double val, int[] valList) throws NoValMatchFoundException {
        int size = valList.length;
        int indMatch = -1;
        for (int indLoop = 0; indLoop < size; ++indLoop) {
            if (val != (double)valList[indLoop]) continue;
            indMatch = indLoop;
        }
        if (indMatch != -1) {
            return indMatch;
        }
        throw new NoValMatchFoundException();
    }

    public static double[] getEvenlyDiscrVals(double minVal, double maxVal, double deltaBin) {
        int vblSize = (int)((maxVal - minVal) / deltaBin) + 1;
        double[] valBinList = new double[vblSize];
        double vLoop = minVal;
        for (int ct = 0; ct < vblSize; ++ct) {
            valBinList[ct] = vLoop;
            vLoop += deltaBin;
        }
        return valBinList;
    }

    public static double[] getValsAbove(double[] valList, double minVal) throws NoValsFoundException {
        int size = valList.length;
        int ct = 0;
        double[] valsAbove = new double[valList.length];
        for (int vLoop = 0; vLoop < size; ++vLoop) {
            if (!(valList[vLoop] >= minVal)) continue;
            valsAbove[ct] = valList[vLoop];
            ++ct;
        }
        if (ct > 0) {
            return valsAbove;
        }
        throw new NoValsFoundException();
    }

    public void getValsAboveMag(ObsEqkRupList obs_eqkList, double minMag) {
        ListIterator eventIt = obs_eqkList.listIterator();
        int numEvents = obs_eqkList.size();
        int ind = 0;
        double[] valList = new double[numEvents];
        while (eventIt.hasNext()) {
            ObsEqkRupture event = (ObsEqkRupture)eventIt.next();
            valList[ind++] = event.getMag();
        }
        ListSortingTools.getValsAbove(valList, minMag);
    }

    public static double getListSum(double[] valList) {
        int size = valList.length;
        double sum = 0.0;
        for (int vLoop = 0; vLoop < size; ++vLoop) {
            sum += valList[vLoop];
        }
        return sum;
    }

    public static int getListSum(int[] valList) {
        int size = valList.length;
        int sum = 0;
        for (int vLoop = 0; vLoop < size; ++vLoop) {
            sum += valList[vLoop];
        }
        return sum;
    }

    public static double[] calcCumSum(double[] valList, boolean flip) {
        int vlLength = valList.length;
        double[] cumSumValList = new double[vlLength];
        if (flip) {
            cumSumValList[vlLength - 1] = valList[vlLength - 1];
            for (int csLoop = vlLength - 2; csLoop >= 0; --csLoop) {
                cumSumValList[csLoop] = cumSumValList[csLoop + 1] + valList[csLoop];
            }
        } else {
            cumSumValList[0] = valList[0];
            for (int csLoop = 1; csLoop < vlLength; ++csLoop) {
                cumSumValList[csLoop] = cumSumValList[csLoop - 1] + valList[csLoop];
            }
        }
        return cumSumValList;
    }

    public static double[] calcCumSum(int[] valList, boolean flip) {
        int vlLength = valList.length;
        double[] cumSumValList = new double[vlLength];
        if (flip) {
            cumSumValList[vlLength - 1] = valList[vlLength - 1];
            for (int csLoop = vlLength - 2; csLoop >= 0; --csLoop) {
                cumSumValList[csLoop] = cumSumValList[csLoop + 1] + (double)valList[csLoop];
            }
        } else {
            cumSumValList[0] = valList[0];
            for (int csLoop = 1; csLoop < vlLength; ++csLoop) {
                cumSumValList[csLoop] = cumSumValList[csLoop - 1] + (double)valList[csLoop];
            }
        }
        return cumSumValList;
    }

    public static void main(String[] args) {
        double[] magList = new double[10];
        boolean flip = true;
        double startMag = 12.0;
        for (int synMag = 0; synMag < 10; ++synMag) {
            magList[synMag] = startMag;
            System.out.print(" " + magList[synMag]);
            startMag -= 1.0;
        }
    }
}

