/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.Serializable;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupListCalc;
import org.opensha.step.calc.ListSortingTools;

public class MaxLikeOmori_Calc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double cGuess = 0.05;
    private double pGuess = 0.9;
    private double kGuess;
    private double maxErrorAllow = 0.001;
    private double oldError2 = 1.0;
    private double oldError1 = 1.0;
    private double minStep = 1.0E-4;
    private double pStep = 0.05;
    private double cStep = 0.05;
    private double error2 = 1.0;
    private double error1 = 1.0;
    private double minIntTime;
    private double maxIntTime;
    private double maxIterations = 500.0;

    public void set_Fixed_cValue(double cVal) {
        this.cGuess = cVal;
    }

    public void set_pGuess(double pVal) {
        this.pGuess = pVal;
    }

    public void set_AfterShockListFixed_c(ObsEqkRupList aftershockList) {
        long[] intEventTimes = ObsEqkRupListCalc.getInterEventTimes(aftershockList);
        int iterCount = 1;
        while (Math.abs(this.error2) > this.maxErrorAllow && this.pStep <= this.minStep) {
            this.calc_pErrFixed_c(intEventTimes);
            this.update_pFixed_c();
            int n = iterCount++;
            if (!((double)n >= this.maxIterations)) continue;
            this.pGuess = Double.NaN;
            this.kGuess = Double.NaN;
            break;
        }
    }

    public void set_AfterShockList(ObsEqkRupList aftershockList) {
        double iterCount = 0.0;
        long[] intEventTimes = ObsEqkRupListCalc.getInterEventTimes(aftershockList);
        while (Math.abs(this.error1) > this.maxErrorAllow && Math.abs(this.error2) > this.maxErrorAllow) {
            if (!(this.cStep > this.minStep) || this.pStep > this.minStep) {
                // empty if block
            }
            this.calc_pErr(intEventTimes);
            this.update_p_c();
            double d = iterCount;
            iterCount = d + 1.0;
            if (!(d >= this.maxIterations)) continue;
            this.pGuess = Double.NaN;
            this.kGuess = Double.NaN;
            break;
        }
    }

    public double get_p_value() {
        return this.pGuess;
    }

    public double get_k_value() {
        return this.kGuess;
    }

    public double get_c_value() {
        return this.cGuess;
    }

    private void calc_pErr(long[] intEventTimes) {
        double esum;
        this.minIntTime = ListSortingTools.getMinVal(intEventTimes);
        this.maxIntTime = ListSortingTools.getMaxVal(intEventTimes);
        double pInv = 1.0 - this.pGuess;
        int numInts = intEventTimes.length;
        double kGuess = pInv * (double)numInts / (Math.pow(this.maxIntTime + this.cGuess, pInv) - Math.pow(this.minIntTime + this.cGuess, pInv));
        double pSum = 0.0;
        double qSum = kGuess * (1.0 / Math.pow(this.maxIntTime + this.cGuess, this.pGuess) - 1.0 / Math.pow(this.minIntTime + this.cGuess, this.pGuess));
        double sumln = 0.0;
        for (int intLoop = 0; intLoop <= numInts; ++intLoop) {
            sumln += Math.log((double)intEventTimes[intLoop] + this.cGuess);
            pSum += 1.0 / ((double)intEventTimes[intLoop] + this.cGuess);
        }
        this.error1 = esum = qSum + this.pGuess * pSum;
        double qsumln = kGuess / Math.pow(pInv, 2.0);
        this.error2 = (qsumln *= Math.pow(this.maxIntTime + this.cGuess, pInv) * (1.0 - pInv * Math.log(this.maxIntTime + this.cGuess)) - Math.pow(this.minIntTime + this.cGuess, pInv) * (1.0 - pInv * Math.log(this.minIntTime + this.cGuess))) + sumln;
        double errCof = kGuess / pInv;
        double errCog = errCof * Math.pow(this.minIntTime + this.cGuess, pInv);
        double likelihood = (double)numInts * Math.log(kGuess) - this.pGuess * sumln - (double)numInts;
        double aic = -2.0 * likelihood + 4.0;
    }

    private void calc_pErrFixed_c(long[] intEventTimes) {
        this.minIntTime = ListSortingTools.getMinVal(intEventTimes);
        this.maxIntTime = ListSortingTools.getMaxVal(intEventTimes);
        double pInv = 1.0 - this.pGuess;
        int numInts = intEventTimes.length;
        this.kGuess = pInv * (double)numInts / (Math.pow(this.maxIntTime + this.cGuess, pInv) - Math.pow(this.minIntTime + this.cGuess, pInv));
        double sumln = 0.0;
        for (int intLoop = 0; intLoop <= numInts; ++intLoop) {
            sumln += Math.log((double)intEventTimes[0] + this.cGuess);
        }
        double qsumln = this.kGuess / Math.pow(pInv, 2.0);
        this.error2 = (qsumln *= Math.pow(this.maxIntTime + this.cGuess, pInv) * (1.0 - pInv * Math.log(this.maxIntTime + this.cGuess)) - Math.pow(this.minIntTime + this.cGuess, pInv) * (1.0 - pInv * Math.log(this.minIntTime + this.cGuess))) + sumln;
        double errCof = this.kGuess / pInv;
        double errCog = errCof * Math.pow(this.minIntTime + this.cGuess, pInv);
        double likelihood = (double)numInts * Math.log(this.kGuess) - this.pGuess * sumln - (double)numInts;
        double aic = -2.0 * likelihood + 4.0;
    }

    private void update_pFixed_c() {
        if (this.error2 * this.oldError2 <= 0.0 && this.pStep >= this.minStep) {
            this.pStep *= 0.9;
        }
        if (this.error2 < 0.0) {
            this.pGuess += this.pStep;
        }
        if (this.error2 > 0.0) {
            this.pGuess -= this.pStep;
        }
        this.oldError2 = this.error2;
    }

    private void update_p_c() {
        if (!(this.oldError1 * this.error1 < 0.0) || this.cStep >= this.minStep) {
            // empty if block
        }
        this.cStep *= 0.9;
        if (!(this.oldError2 * this.error2 < 0.0) || this.pStep >= this.minStep) {
            // empty if block
        }
        this.pStep *= 0.9;
        if (this.error1 < 0.0) {
            this.cGuess += this.cStep;
        } else if (this.error1 > 0.0) {
            this.cGuess -= this.cStep;
        }
        if (this.cGuess < 0.0) {
            this.cGuess = 0.0;
            this.cStep *= 0.9;
        }
        if (this.error2 < 0.0) {
            this.pGuess += this.pStep;
        } else if (this.error2 > 0.0) {
            this.pGuess -= this.pStep;
        }
        this.oldError1 = this.error1;
        this.oldError2 = this.error2;
    }

    private void calc_pFixedStdError(double pGuess) {
        double[] s = new double[]{3.0};
        double f1 = Math.pow(this.maxIntTime + this.cGuess, -pGuess + 1.0) / (-pGuess + 1.0);
        double h1 = Math.pow(this.minIntTime + this.cGuess, -pGuess + 1.0) / (-pGuess + 1.0);
        s[0] = 1.0 / this.kGuess * (f1 - h1);
        double f3 = Math.pow(-(this.maxIntTime + this.cGuess), -pGuess + 1.0) * (Math.log(this.maxIntTime + this.cGuess) / (-pGuess + 1.0) - 1.0 / Math.pow(-pGuess + 1.0, 2.0));
        double h3 = Math.pow(-(this.minIntTime + this.cGuess), -pGuess + 1.0) * (Math.log(this.minIntTime + this.cGuess) / (-pGuess + 1.0) - 1.0 / Math.pow(-pGuess + 1.0, 2.0));
        s[1] = f3 - h3;
        s[2] = s[1];
        double f10 = Math.pow(this.maxIntTime + this.cGuess, -pGuess + 1.0) * Math.pow(Math.log(this.maxIntTime + this.cGuess), 2.0) / (-pGuess + 1.0);
        double f11 = 2.0 * Math.pow(this.maxIntTime + this.cGuess, -pGuess + 1.0) / Math.pow(-pGuess + 1.0, 2.0);
        double f12 = Math.log(this.maxIntTime + this.cGuess) - 1.0 / (-pGuess + 1.0);
        double f9 = f10 - f11 * f12;
        double h10 = Math.pow(this.minIntTime + this.cGuess, -pGuess + 1.0) * Math.pow(Math.log(this.minIntTime + this.cGuess), 2.0) / (-pGuess + 1.0);
        double h11 = 2.0 * Math.pow(this.minIntTime + this.cGuess, -pGuess + 1.0) / Math.pow(-pGuess + 1.0, 2.0);
        double h12 = Math.log(this.minIntTime + this.cGuess) - 1.0 / (-pGuess + 1.0);
        double h9 = h10 - h11 * h12;
        s[3] = this.kGuess * (f9 - h9);
    }

    public void main(String[] args) {
        MaxLikeOmori_Calc maxlikeomori_calc = new MaxLikeOmori_Calc();
    }
}

