/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupListCalc;
import org.opensha.step.calc.ListSortingTools;

public class OgataLogLike_Calc {
    private double k_value;
    private double c_value;
    private double p_value;
    private long[] intEventTimes;
    private double minIntTime;
    private double maxIntTime;
    private double logLikelihood;

    public OgataLogLike_Calc(double[] OmoriParms, ObsEqkRupList aftershockList) {
        this.set_OmoriParms(OmoriParms, aftershockList);
    }

    public void set_OmoriParms(double[] OmoriParms, ObsEqkRupList aftershockList) {
        this.k_value = OmoriParms[0];
        this.c_value = OmoriParms[1];
        this.p_value = OmoriParms[2];
        if (aftershockList.size() <= 1) {
            this.intEventTimes = new long[0];
            this.minIntTime = 0.0;
            this.maxIntTime = 0.0;
        } else {
            this.intEventTimes = ObsEqkRupListCalc.getInterEventTimes(aftershockList);
            this.minIntTime = ListSortingTools.getMinVal(this.intEventTimes);
            this.maxIntTime = ListSortingTools.getMaxVal(this.intEventTimes);
        }
        this.calc_OgataLoglike();
    }

    public double get_OgataLogLikelihood() {
        return this.logLikelihood;
    }

    private void calc_OgataLoglike() {
        double sumInt = 0.0;
        double pInv = 1.0 - this.p_value;
        int numInts = this.intEventTimes.length;
        for (int intLoop = 0; intLoop < numInts; ++intLoop) {
            sumInt += Math.log((double)this.intEventTimes[intLoop] + this.c_value);
        }
        double Acp = this.p_value == 1.0 ? Math.log(this.maxIntTime + this.c_value) - Math.log(this.minIntTime + this.c_value) : (Math.pow(this.maxIntTime + this.c_value, pInv) - Math.pow(this.minIntTime + this.c_value, this.p_value)) / pInv;
        this.logLikelihood = numInts > 0 ? (double)numInts * Math.log(this.k_value) - this.p_value * sumInt - this.k_value * Acp : -this.p_value * sumInt - this.k_value * Acp;
    }

    public static void main(String[] args) {
    }
}

