/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.opensha.sha.earthquake.griddedForecast.STEP_CombineForecastModels;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.step.calc.RegionDefaults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeMainshockList {
    public static void removeModels(ArrayList<STEP_CombineForecastModels> finalModels) {
        int numMs = finalModels.size();
        int msLoop = 0;
        while (msLoop < numMs) {
            STEP_CombineForecastModels mainshockModel = finalModels.get(msLoop);
            double msAge = mainshockModel.getDaysSinceMainshockStart();
            if (msAge <= (double)RegionDefaults.daysFromQDM_Cat) {
                finalModels.remove(msLoop);
                --numMs;
                continue;
            }
            if (!mainshockModel.get_UsedInForecast()) {
                finalModels.remove(msLoop);
                --numMs;
                continue;
            }
            ++msLoop;
        }
    }

    private static void removeAftershocks(STEP_CombineForecastModels mainshockModel) {
        ObsEqkRupList newAfterShocks = new ObsEqkRupList();
        GregorianCalendar cuurentTime = mainshockModel.getCurrentTime();
        for (int index = 0; index < mainshockModel.getAfterShocks().size(); ++index) {
            ObsEqkRupture shock = mainshockModel.getAfterShocks().getObsEqkRuptureAt(index);
            long timeDiff = cuurentTime.getTimeInMillis() - shock.getOriginTime().getTimeInMillis();
            if ((double)timeDiff / 24.0 / 60.0 / 60.0 / 1000.0 <= (double)RegionDefaults.daysFromQDM_Cat) continue;
            newAfterShocks.addObsEqkEvent(shock);
        }
        mainshockModel.getAfterShocks().clear();
        mainshockModel.setAfterShocks(newAfterShocks);
        if (newAfterShocks.size() < 100) {
            // empty if block
        }
    }

    private static void checktypeIAftershockZoneDef(STEP_CombineForecastModels model) {
        if (model.isUseSausageRegion()) {
            model.calcTypeI_AftershockZone();
        }
    }
}

