/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import nz.org.geonet.quakeml.v1_0_1.client.QuakemlFactory;
import nz.org.geonet.quakeml.v1_0_1.client.QuakemlUtils;
import nz.org.geonet.quakeml.v1_0_1.domain.Event;
import nz.org.geonet.quakeml.v1_0_1.domain.Magnitude;
import nz.org.geonet.quakeml.v1_0_1.domain.Origin;
import nz.org.geonet.quakeml.v1_0_1.domain.Quakeml;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.opensha.commons.data.Location;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.step.calc.RegionDefaults;

public class QuakeMLClient {
    private static final String QUAKE_DATA_SOURCE = "GEONET";
    private static final char QUAKE_EVENT_VERSION = '0';
    public QuakemlFactory qkmlFactory = new QuakemlFactory();
    private static Pattern idPattern = Pattern.compile("[0-9]{1,10}");
    public static SimpleDateFormat dateformater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static Logger logger = Logger.getLogger(QuakeMLClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObsEqkRupList retrieveEvents(Calendar startDate, Calendar endDate) {
        if (startDate == null || endDate == null) {
            logger.error("startDate and endDate must be specified for QuakeMl client!!");
            return null;
        }
        ObsEqkRupList eqkRupList = new ObsEqkRupList();
        String request = RegionDefaults.GEONET_QUAKEML_URL + "&cql_filter=origintime%3E='" + dateformater.format(startDate.getTime()) + "'+AND+origintime%3C'" + dateformater.format(endDate.getTime()) + "'";
        logger.info("quakeML request " + request);
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(request);
        try {
            int statusCode = client.executeMethod(method);
            if (statusCode != 200) {
                logger.error("request failed: " + request + " " + method.getStatusLine());
            } else {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonRoot = mapper.readTree(method.getResponseBodyAsStream());
                JsonNode jsonFeatures = jsonRoot.get("features");
                logger.info("1 #### features " + jsonFeatures.size());
                for (int i = 0; i < jsonFeatures.size(); ++i) {
                    JsonNode feature = jsonFeatures.get(i);
                    JsonNode featureProperties = feature.get("properties");
                    Date originDate = dateformater.parse(featureProperties.get("origintime").getTextValue());
                    GregorianCalendar originTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                    originTime.setTimeInMillis(originDate.getTime());
                    double lat = featureProperties.get("latitude").getDoubleValue();
                    double lon = featureProperties.get("longitude").getDoubleValue();
                    double depth = featureProperties.get("depth").getDoubleValue();
                    Location hypoLoc = new Location(lat, lon, depth);
                    String magType = featureProperties.get("magnitudetype").getTextValue();
                    double magval = featureProperties.get("magnitude").getDoubleValue();
                    double horzErr = 0.0;
                    double vertErr = 0.0;
                    double magErr = 0.0;
                    magval = (double)Math.round(magval * 10.0) / 10.0;
                    ObsEqkRupture rupture = new ObsEqkRupture(featureProperties.get("publicid").getTextValue(), QUAKE_DATA_SOURCE, '0', originTime, horzErr, vertErr, magErr, magType, hypoLoc, magval);
                    if (rupture == null || (rupture = this.checkTime(rupture, startDate, endDate)) == null) continue;
                    eqkRupList.addObsEqkEvent(rupture);
                }
            }
        }
        catch (HttpException e) {
            logger.error("Fatal protocol violation: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("Fatal transport error: " + e.getMessage());
        }
        catch (ParseException e) {
            logger.error("Fatal transport error: " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return eqkRupList;
    }

    public ObsEqkRupList retrieveEvents_old(Calendar startDate, Calendar endDate) {
        if (startDate == null || endDate == null) {
            logger.error("startDate and endDate must be specified for QuakeMl client!!");
            return null;
        }
        String request = RegionDefaults.GEONET_QUAKEML_URL + "?startDate=" + dateformater.format(startDate.getTime()) + "&endDate=" + dateformater.format(endDate.getTime());
        logger.info("quakeML request " + request);
        Quakeml qkml = this.qkmlFactory.getQuakeml(request, null, null);
        ObsEqkRupList eqkRupList = new ObsEqkRupList();
        List<Event> events = qkml.getEventParameters().getEvent();
        logger.info("quakeML events=" + events.size());
        for (Event event : events) {
            ObsEqkRupture rupture = this.event2Rupture(event);
            if (rupture == null || (rupture = this.checkTime(rupture, startDate, endDate)) == null) continue;
            eqkRupList.addObsEqkEvent(rupture);
        }
        logger.info("eqkRupList=" + eqkRupList.size());
        return eqkRupList;
    }

    private ObsEqkRupture checkTime(ObsEqkRupture rupture, Calendar start, Calendar end) {
        if (rupture.getOriginTime().before(start)) {
            return null;
        }
        if (rupture.getOriginTime().after(end) || rupture.getOriginTime().equals(end)) {
            return null;
        }
        return rupture;
    }

    public ObsEqkRupture event2Rupture(Event event) {
        try {
            String publicID = event.getPublicID();
            Matcher m = idPattern.matcher(publicID);
            String eventID = publicID;
            if (m.find()) {
                eventID = publicID.substring(m.start(), m.end());
            }
            char eventVersion = '0';
            Origin origin = QuakemlUtils.getPreferredOrigin(event);
            String evalStatus = origin.getEvaluationStatus().value();
            if (evalStatus != null && evalStatus.length() > 0) {
                eventVersion = evalStatus.charAt(0);
            }
            XMLGregorianCalendar oriTime = origin.getTime().getValue();
            GregorianCalendar originTime = oriTime.toGregorianCalendar(TimeZone.getTimeZone("UTC"), null, null);
            double lat = origin.getLatitude().getValue();
            double lon = origin.getLongitude().getValue();
            double depth = origin.getDepth().getValue();
            Location hypoLoc = new Location(lat, lon, depth);
            Magnitude mag = QuakemlUtils.getPreferredMagnitude(event);
            String magType = mag.getType();
            double magval = 0.0;
            if (mag == null || mag.getMag() == null) {
                return null;
            }
            magval = mag.getMag().getValue();
            double horzErr = 0.0;
            double vertErr = 0.0;
            double magErr = 0.0;
            if (mag != null && mag.getMag() != null && mag.getMag().getUncertainty() != null) {
                magErr = mag.getMag().getUncertainty();
            }
            if (origin != null) {
                double latErr = 0.0;
                double lonErr = 0.0;
                if (origin.getLatitude() != null && origin.getLatitude().getUncertainty() != null) {
                    latErr = origin.getLatitude().getUncertainty();
                }
                if (origin.getLongitude() != null && origin.getLongitude().getUncertainty() != null) {
                    lonErr = origin.getLongitude().getUncertainty();
                }
                double d = horzErr = lonErr > latErr ? lonErr : latErr;
                if (origin.getDepth() != null && origin.getDepth().getUncertainty() != null) {
                    vertErr = origin.getDepth().getUncertainty();
                }
            }
            return new ObsEqkRupture(eventID, QUAKE_DATA_SOURCE, eventVersion, originTime, horzErr, vertErr, magErr, magType, hypoLoc, magval);
        }
        catch (Exception e) {
            logger.error("event2Rupture parse event error " + e);
            return null;
        }
    }

    static {
        dateformater.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

