/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.WarningParameterAPI;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.PointEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.step.STEP_BackSiesDataAdditionObject;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.McVerryetal_2000_AttenRel;
import org.opensha.sha.util.SiteTranslator;
import org.opensha.step.calc.RegionDefaults;
import org.opensha.step.calc.STEP_main;

public class STEP_DamageState
implements ParameterChangeWarningListener {
    private boolean willSiteClass = true;
    private AttenuationRelationship attenRel;
    private static final String STEP_BG_FILE_NAME = RegionDefaults.backgroundHazardPath;
    private static final String STEP_HAZARD_OUT_FILE_NAME = RegionDefaults.outputHazardPath;
    private static final String STEP_HAZCURVE_OUT_FILE_NAME = RegionDefaults.outputHazCurvePath;
    private static final double IML_VALUE = Math.log(1.0);
    private static final double SA_PERIOD = 1.0;
    private static final String STEP_AFTERSHOCK_OBJECT_FILE = RegionDefaults.STEP_AftershockObjectFile;
    private DecimalFormat locFormat = new DecimalFormat("0.0000");
    private static final double[] IM_LEVEL_LIST = new double[]{0.0025, 0.00375, 0.00563, 0.00844, 0.0127, 0.019, 0.0285, 0.0427, 0.0641, 0.0961, 0.144, 0.216, 0.324, 0.487, 0.73, 1.09, 1.64, 2.46, 3.69, 5.54};
    private double[][] hazCurveList;
    private static final int NUM_LEVELS = 20;

    public STEP_DamageState(boolean includeWillsSiteClass) {
        this.willSiteClass = includeWillsSiteClass;
    }

    public static void main(String[] args) {
        System.out.println(" DS STEP Starting.");
        STEP_DamageState step = new STEP_DamageState(false);
        step.runDSSTEP();
        System.out.println(" DS STEP is finito!");
    }

    private void runDSSTEP() {
        STEP_main stepMain = new STEP_main();
        stepMain.calc_STEP(null, null);
        System.out.println(" DS STEP earthquake rates are done.");
        this.createShakeMapAttenRelInstance();
        SitesInGriddedRegion sites = null;
        GriddedRegion eggr = new GriddedRegion(new Location(-42.0, 171.0), new Location(-45.0, 174.0), 0.1, new Location(RegionDefaults.grid_anchor, RegionDefaults.grid_anchor));
        sites = new SitesInGriddedRegion(eggr);
        sites.addSiteParams(this.attenRel.getSiteParamsIterator());
        ListIterator<ParameterAPI> it = this.attenRel.getSiteParamsIterator();
        ArrayList<ParameterAPI> defaultSiteParams = new ArrayList<ParameterAPI>();
        SiteTranslator siteTrans = new SiteTranslator();
        while (it.hasNext()) {
            ParameterAPI tempParam = (ParameterAPI)it.next().clone();
            siteTrans.setParameterValue(tempParam, "DE", Double.NaN);
            defaultSiteParams.add(tempParam);
        }
        if (this.willSiteClass) {
            sites.setDefaultSiteParams(defaultSiteParams);
            sites.setSiteParamsForRegionFromServlet(true);
        }
        ArbitrarilyDiscretizedFunc probCurve = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < 20; ++i) {
            probCurve.set(Math.log(IM_LEVEL_LIST[i]), 1.0);
        }
        double[] bgVals = this.getBGVals(sites.getRegion().getNodeCount(), STEP_BG_FILE_NAME);
        double[] probVal = this.getProbVals(this.attenRel, sites, stepMain.getSourceList(), probCurve);
        STEP_BackSiesDataAdditionObject addStepData = new STEP_BackSiesDataAdditionObject();
        double[] stepBothProbVals = addStepData.addDataSet(bgVals, probVal);
        this.createFile(stepBothProbVals, sites);
        this.createHazCurveFile(this.hazCurveList, sites);
    }

    private void createShakeMapAttenRelInstance() {
        this.attenRel = new McVerryetal_2000_AttenRel(this);
        this.attenRel.setParamDefaults();
        this.attenRel.setIntensityMeasure("SA");
        this.attenRel.getParameter("SA Period").setValue(1.0);
    }

    private void createFile(double[] probVals, SitesInGriddedRegion sites) {
        int size = probVals.length;
        LocationList locList = sites.getRegion().getNodeList();
        int numLocations = locList.size();
        try {
            FileWriter fr = new FileWriter(STEP_HAZARD_OUT_FILE_NAME);
            for (int i = 0; i < numLocations; ++i) {
                Location loc = locList.getLocationAt(i);
                fr.write(this.locFormat.format(loc.getLatitude()) + "    " + this.locFormat.format(loc.getLongitude()) + "      " + this.convertToProb(probVals[i]) + "\n");
            }
            fr.close();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    private void createHazCurveFile(double[][] hazCurveList, SitesInGriddedRegion sites) {
        int size = hazCurveList.length;
        LocationList locList = sites.getRegion().getNodeList();
        int numLocations = locList.size();
        try {
            FileWriter fr = new FileWriter(STEP_HAZCURVE_OUT_FILE_NAME);
            for (int i = 0; i < numLocations; ++i) {
                Location loc = locList.getLocationAt(i);
                fr.write(this.locFormat.format(loc.getLatitude()) + "    " + this.locFormat.format(loc.getLongitude()));
                for (int k = 0; k < 20; ++k) {
                    fr.write(" " + this.convertToProb(hazCurveList[i][k]));
                }
                fr.write("\n");
            }
            fr.close();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    private double convertToProb(double rate) {
        return 1.0 - Math.exp(-1.0 * rate * RegionDefaults.forecastLengthDays);
    }

    private double[] getBGVals(int numSites, String fileName) {
        double[] vals = new double[numSites];
        try {
            ArrayList<String> fileLines = FileUtils.loadFile(fileName);
            ListIterator<String> it = fileLines.listIterator();
            int i = 0;
            while (it.hasNext()) {
                StringTokenizer st = new StringTokenizer(it.next());
                st.nextToken();
                st.nextToken();
                String val = st.nextToken().trim();
                double temp = 0.0;
                if (!val.equalsIgnoreCase("NaN")) {
                    temp = new Double(val);
                    vals[i++] = this.convertToRate(temp);
                    continue;
                }
                temp = new Double(Double.NaN);
                vals[i++] = this.convertToRate(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vals;
    }

    private double convertToRate(double prob) {
        return -1.0 * Math.log(1.0 - prob) / RegionDefaults.forecastLengthDays;
    }

    private double[] getProbVals(AttenuationRelationship imr, SitesInGriddedRegion sites, ArrayList sourceList, ArbitrarilyDiscretizedFunc probCurve) {
        double[] probVals = new double[sites.getRegion().getNodeCount()];
        double MAX_DISTANCE = 500.0;
        try {
            int numSources = sourceList.size();
            boolean sourceUsed = false;
            int numSites = sites.getRegion().getNodeCount();
            int numSourcesSkipped = 0;
            long startCalcTime = System.currentTimeMillis();
            this.hazCurveList = new double[numSites][20];
            double[] totInvProb = new double[20];
            for (int j = 0; j < numSites; ++j) {
                int i;
                double hazVal = 1.0;
                double condProb = 0.0;
                for (int d = 0; d < 20; ++d) {
                    totInvProb[d] = 1.0;
                }
                Site site = sites.getSite(j);
                site.setValue("McVerryetal Site Type", "D-Soft-or-Deep-Soil");
                imr.setSite(site);
                for (i = 0; i < numSources; ++i) {
                    ProbEqkSource source = (ProbEqkSource)sourceList.get(i);
                    double distance = source.getMinDistance(sites.getSite(j));
                    if (distance > MAX_DISTANCE) {
                        ++numSourcesSkipped;
                        continue;
                    }
                    sourceUsed = true;
                    hazVal *= 1.0 - imr.getTotExceedProbability((PointEqkSource)source, IML_VALUE);
                    int numRup = source.getNumRuptures();
                    for (int n = 0; n < numRup; ++n) {
                        imr.setEqkRupture(source.getRupture(n));
                        double qkProb = source.getRupture(n).getProbability();
                        imr.getExceedProbabilities(probCurve);
                        for (int kk = 0; kk < 20; ++kk) {
                            int n2 = kk;
                            totInvProb[n2] = totInvProb[n2] * Math.pow(1.0 - qkProb, probCurve.getY(kk));
                        }
                    }
                }
                if (sourceUsed) {
                    hazVal = 1.0 - hazVal;
                    for (i = 0; i < 20; ++i) {
                        double invProb = 1.0 - totInvProb[i];
                        probCurve.set(i, invProb);
                    }
                } else {
                    hazVal = 0.0;
                    for (i = 0; i < 20; ++i) {
                        probCurve.set(i, 0.0);
                    }
                }
                probVals[j] = this.convertToRate(hazVal);
                for (i = 0; i < 20; ++i) {
                    this.hazCurveList[j][i] = this.convertToRate(probCurve.getY(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return probVals;
    }

    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        String S = " : parameterChangeWarning(): ";
        WarningParameterAPI param = e.getWarningParameter();
        param.setValueIgnoreWarning(e.getNewValue());
    }
}

