/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.opensha.commons.util.FileUtils;

public class UpdateCatQDM {
    public static int iLR_Year;
    public static int iLR_Month;
    public static int iLR_Day;
    public static int iLR_Hour;
    public static int iLR_Min;
    public static int iLR_Sec;

    public static int readTimeStamp(String stampFileName) {
        ArrayList<String> lastCatReadTime = null;
        try {
            lastCatReadTime = FileUtils.loadFile(stampFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ListIterator<String> it = lastCatReadTime.listIterator();
        StringTokenizer st = new StringTokenizer(it.next().toString());
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        iLR_Year = Integer.parseInt(st.nextToken());
        iLR_Month = Integer.parseInt(st.nextToken()) - 1;
        iLR_Day = Integer.parseInt(st.nextToken());
        iLR_Hour = Integer.parseInt(st.nextToken());
        iLR_Min = Integer.parseInt(st.nextToken());
        iLR_Sec = Integer.parseInt(st.nextToken());
        return iLR_Year;
    }

    public static int findQDM_Updates(String qdmCatFile, String updatedFile, String tsFile) {
        long dayDiff = 0L;
        int updateCt = 0;
        ArrayList<String> qdmCatLine = null;
        ArrayList<String> updatedEvents = new ArrayList<String>();
        PrintWriter updatePW = null;
        PrintWriter stampOut = null;
        try {
            qdmCatLine = FileUtils.loadFile(qdmCatFile);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(iLR_Year, iLR_Month, iLR_Day, iLR_Hour, iLR_Min, iLR_Sec);
        Date lastReadDate = calendar.getTime();
        ListIterator<String> it = qdmCatLine.listIterator();
        while (it.hasNext()) {
            String cubeLine = new String(it.next().toString());
            int iYear = Integer.parseInt(cubeLine.substring(0, 4));
            int iMonth = Integer.parseInt(cubeLine.substring(5, 7)) - 1;
            int iDay = Integer.parseInt(cubeLine.substring(8, 10));
            int iHour = Integer.parseInt(cubeLine.substring(11, 13));
            int iMin = Integer.parseInt(cubeLine.substring(14, 16));
            int iSec = Integer.parseInt(cubeLine.substring(17, 19));
            calendar.set(iYear, iMonth, iDay, iHour, iMin, iSec);
            Date eventDate = calendar.getTime();
            dayDiff = eventDate.getTime() - lastReadDate.getTime();
            if (dayDiff < 0L) continue;
            System.out.println(eventDate.getTime());
            updatedEvents.add(cubeLine);
            ++updateCt;
        }
        GregorianCalendar curCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        String curDate = new String();
        curDate = "Last QDM Catalogue Read: ";
        int year = curCalendar.get(1);
        curDate = curDate.concat(String.valueOf(year) + " ");
        curDate = curDate.concat(String.valueOf(curCalendar.get(2) + 1) + " ");
        curDate = curDate.concat(String.valueOf(curCalendar.get(5)) + " ");
        curDate = curDate.concat(String.valueOf(curCalendar.get(11)) + " ");
        curDate = curDate.concat(String.valueOf(curCalendar.get(12)) + " ");
        curDate = curDate.concat(String.valueOf(curCalendar.get(13)));
        System.out.println(curDate);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(tsFile));
            stampOut = new PrintWriter(bw);
            stampOut.println(curDate);
            stampOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            BufferedWriter bwout = new BufferedWriter(new FileWriter(updatedFile));
            updatePW = new PrintWriter(bwout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.setProperty("line.separator", "\n");
        ListIterator itUpdate = updatedEvents.listIterator();
        while (itUpdate.hasNext()) {
            String updateLine = new String(itUpdate.next().toString());
            String cutString = updateLine.substring(20, 99);
            updatePW.println(cutString);
        }
        updatePW.close();
        return updateCt;
    }

    public static void main(String[] args) {
        UpdateCatQDM updateCatQDM1 = new UpdateCatQDM();
        String tsFile = "/home/matt/ForecastMap/QDDS/QDMcat/TimeStamp.txt";
        String catFile = "/home/matt/ForecastMap/QDDS/QDMcat/merge.sum";
        String updatedFile = "/home/matt/ForecastMap/UpdatedCat/UpdatedEvents.cat";
        UpdateCatQDM.readTimeStamp(tsFile);
        UpdateCatQDM.findQDM_Updates(catFile, updatedFile, tsFile);
    }
}

