/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.sha.earthquake.griddedForecast.GenericAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.GriddedHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.griddedForecast.STEP_CombineForecastModels;
import org.opensha.sha.earthquake.griddedForecast.SequenceAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.SpatialAfterHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.step.calc.DistDecayFromRupCalc;

public class UpdateSTEP_Forecast {
    private ObsEqkRupList aftershocks;
    private GenericAfterHypoMagFreqDistForecast forecastModelGen;
    private SequenceAfterHypoMagFreqDistForecast forecastModelSeq;
    private SpatialAfterHypoMagFreqDistForecast forecastModelSpa;
    private GriddedRegion backgroundRatesGrid;
    private STEP_CombineForecastModels sequenceModel;
    private static int numGridNodes;
    private HypoMagFreqDistAtLoc genForecastAtLoc;
    private HypoMagFreqDistAtLoc seqForecastAtLoc;
    private HypoMagFreqDistAtLoc spaForecastAtLoc;
    private GriddedHypoMagFreqDistForecast genGriddedForecast;

    public UpdateSTEP_Forecast(STEP_CombineForecastModels sequenceModel) {
        this.sequenceModel = sequenceModel;
        this.initUpdate();
    }

    private void initUpdate() {
        this.forecastModelGen = this.sequenceModel.getGenElement();
        this.aftershocks = this.sequenceModel.getAfterShocks();
        this.backgroundRatesGrid = this.sequenceModel.getBackgroundRatesGrid().getRegion();
        if (this.sequenceModel.isGridIsUpdated()) {
            this.updateGenericModelParms();
        }
        this.sequenceModel.set_useSeqAndSpatial();
        if (this.sequenceModel.get_useSeqAndSpatial()) {
            if (!this.sequenceModel.getExistSeqElement()) {
                this.sequenceModel.createSequenceElement();
            }
            this.forecastModelSeq = this.sequenceModel.getSeqElement();
            this.updateSequenceModelParms();
            if (!this.sequenceModel.getExistSpaElement()) {
                this.sequenceModel.createSpatialElement();
            }
            this.forecastModelSpa = this.sequenceModel.getSpaElement();
            this.updateSpatialModelParms();
        }
        this.updateGenericModelForecast();
        if (this.sequenceModel.get_useSeqAndSpatial()) {
            this.updateSequenceModelForecast();
            this.updateSpatialModelForecast();
        }
    }

    public boolean updateAftershockZone() {
        return this.sequenceModel.updateAftershockZone();
    }

    public void updateGenericModelParms() {
        this.forecastModelGen.setNumGridLocs();
        double[] kScaler = DistDecayFromRupCalc.getDensity(this.sequenceModel.getMainShock(), this.sequenceModel.getAfterShockZone());
        this.sequenceModel.setGridDistanceFromFault(DistDecayFromRupCalc.getRupDistList());
        this.forecastModelGen.set_kScaler(kScaler);
        this.forecastModelGen.set_Gridded_Gen_bValue();
        this.forecastModelGen.set_Gridded_Gen_cValue();
        this.forecastModelGen.set_Gridded_Gen_kValue();
        this.forecastModelGen.set_Gridded_Gen_pValue();
    }

    public void updateSequenceModelParms() {
        double[] kScaler = DistDecayFromRupCalc.getDensity(this.sequenceModel.getMainShock(), this.sequenceModel.getAfterShockZone());
        this.sequenceModel.setGridDistanceFromFault(DistDecayFromRupCalc.getRupDistList());
        this.forecastModelSeq.set_kScaler(kScaler);
        this.forecastModelSeq.calc_SeqNodeCompletenessMag();
        this.forecastModelSeq.set_SequenceRJParms();
        this.forecastModelSeq.set_SequenceOmoriParms();
        this.forecastModelSeq.fillGridWithSeqParms();
        System.out.println("Seq p-value = " + this.forecastModelSeq.get_pValSequence());
        System.out.println("Seq b-value = " + this.forecastModelSeq.get_bValSequence());
        System.out.println("Seq Mc = " + this.forecastModelSeq.getSeqNodeCompletenessMag());
    }

    private void UpdateGridDistFromFault() {
        double[] gridDist = DistDecayFromRupCalc.getRupDistList();
        this.sequenceModel.setGridDistanceFromFault(gridDist);
    }

    public void updateSpatialModelParms() {
        this.forecastModelSpa.calc_GriddedRJParms();
        this.forecastModelSpa.setAllGridedRJ_Parms();
    }

    public void updateGenericModelForecast() {
        this.forecastModelGen.initNumGridInForecast();
        int numGridLocs = this.sequenceModel.getAfterShockZone().getNodeCount();
        int gLoop = 0;
        while (gLoop < numGridLocs) {
            this.genForecastAtLoc = this.forecastModelGen.calcHypoMagFreqDist(gLoop);
            this.forecastModelGen.setGriddedMagFreqDistAtLoc(this.genForecastAtLoc, gLoop++);
        }
    }

    public void updateSequenceModelForecast() {
        this.forecastModelSeq.initNumGridInForecast();
        int numGridLocs = this.sequenceModel.getAfterShockZone().getNodeCount();
        int gLoop = 0;
        while (gLoop < numGridLocs) {
            this.seqForecastAtLoc = this.forecastModelSeq.calcHypoMagFreqDistAtLoc(gLoop);
            this.forecastModelSeq.setGriddedMagFreqDistAtLoc(this.seqForecastAtLoc, gLoop++);
        }
    }

    public void updateSpatialModelForecast() {
        this.forecastModelSpa.initNumGridInForecast();
        int numGridLocs = this.sequenceModel.getAfterShockZone().getNodeCount();
        int gLoop = 0;
        while (gLoop < numGridLocs) {
            this.spaForecastAtLoc = this.forecastModelSpa.calcHypoMagFreqDistAtLoc(gLoop);
            this.forecastModelSpa.setGriddedMagFreqDistAtLoc(this.spaForecastAtLoc, gLoop++);
        }
    }

    public void updateAIC_CombinedModelForecast() {
        this.sequenceModel.createCombinedForecast();
    }

    public void setBackGroundGrid(GriddedRegion backgroundRatesGrid) {
        this.backgroundRatesGrid = backgroundRatesGrid;
        this.updateAftershockZone();
    }

    public GriddedRegion getBackGroundGrid() {
        return this.backgroundRatesGrid;
    }

    public STEP_CombineForecastModels getAftershockModel() {
        return this.sequenceModel;
    }
}

