/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.Serializable;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.opensha.commons.data.Container2D;
import org.opensha.commons.data.Container2DAPI;
import org.opensha.commons.data.Window2D;

public class ContainerSubset2D
implements Container2DAPI,
Serializable {
    protected static final String C = "ContainerSubset2D";
    protected static final boolean D = false;
    protected String name = "";
    protected Window2D window = new Window2D();
    protected Window2D oldWindow = null;
    protected Container2DAPI data = null;
    protected static final char TAB = '\t';

    public ContainerSubset2D(int numRows, int numCols, int startRow, int startCol) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: Constructor():";
        this.window.startRow = startRow;
        this.window.startCol = startCol;
        this.window.numRows = numRows;
        this.window.numCols = numCols;
        this.window.checkLowerBounds(S);
        this.window.calcUpperBounds();
    }

    public ContainerSubset2D(int numRows, int numCols, int startRow, int startCol, Container2DAPI data) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: Constructor2():";
        this.window.startRow = startRow;
        this.window.startCol = startCol;
        this.window.numRows = numRows;
        this.window.numCols = numCols;
        this.window.checkLowerBounds(S);
        this.window.calcUpperBounds();
        this.setContainer2D(data);
    }

    public void setContainer2D(Container2DAPI data) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: setContainer2D():";
        this.initTransaction();
        this.window.maxNumRows = data.getNumRows();
        this.window.maxNumCols = data.getNumCols();
        try {
            this.window.checkUpperBounds(S);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.rollback();
            throw e;
        }
        this.commit();
        this.data = data;
    }

    public void setStartRow(int startRow) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: setStartRow():";
        this.initTransaction();
        this.window.startRow = startRow;
        try {
            this.window.checkLowerBounds(S);
            this.window.calcUpperBounds();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.rollback();
            throw e;
        }
        this.commit();
    }

    protected void validate() throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: validate():";
        this.window.checkLowerBounds(S);
        this.window.calcUpperBounds();
        this.window.checkUpperBounds(S);
        if (this.data == null) {
            throw new ArrayIndexOutOfBoundsException(S + "Data list cannot be null");
        }
    }

    public void setStartCol(int startCol) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: setStartCol():";
        this.initTransaction();
        this.window.startCol = startCol;
        try {
            this.window.checkLowerBounds(S);
            this.window.calcUpperBounds();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.rollback();
            throw e;
        }
        this.commit();
    }

    public void set(int row, int column, Object obj) throws ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This function is not implemented in this subclass");
    }

    public Container2DAPI getContainer2D() {
        return this.data;
    }

    public int getStartRow() {
        return this.window.startRow;
    }

    public int getStartCol() {
        return this.window.startCol;
    }

    public int getNumRows() {
        return this.window.numRows;
    }

    public int getNumCols() {
        return this.window.numCols;
    }

    public int getEndRow() {
        return this.window.endRow;
    }

    public int getEndCol() {
        return this.window.endCol;
    }

    public Object get(int row, int column) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: getColumnIterator(): ";
        if (!this.window.isValidCol(column)) {
            throw new ArrayIndexOutOfBoundsException(S + "The specified column is invalid, either negative or beyond upper index of window. " + column);
        }
        if (!this.window.isValidRow(row)) {
            throw new ArrayIndexOutOfBoundsException(S + "The specified row is invalid, either negative or beyond upper index of window. " + column);
        }
        int transRow = this.window.getTranslatedRow(row);
        int transCol = this.window.getTranslatedCol(column);
        return this.data.get(transRow, transCol);
    }

    public ListIterator getColumnIterator(int row) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: getColumnIterator(): ";
        if (!this.window.isValidRow(row)) {
            throw new ArrayIndexOutOfBoundsException(S + "The specified row is invalid, either negative or beyond upper index of window. " + row);
        }
        this.validate();
        ColumnIterator it = new ColumnIterator(row);
        return it;
    }

    public ListIterator getRowIterator(int column) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: getRowIterator(): ";
        if (!this.window.isValidCol(column)) {
            throw new ArrayIndexOutOfBoundsException(S + "The specified column is invalid, either negative or beyond upper index of window. " + column);
        }
        this.validate();
        RowIterator it = new RowIterator(column);
        return it;
    }

    public ListIterator getAllByColumnsIterator() {
        this.validate();
        AllByColumnsIterator it = new AllByColumnsIterator();
        return it;
    }

    public ListIterator getAllByRowsIterator() {
        this.validate();
        AllByRowsIterator it = new AllByRowsIterator();
        return it;
    }

    public void shiftRows(int delta) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: shiftRows():";
        this.initTransaction();
        try {
            this.window.shiftRows(delta);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.rollback();
            throw e;
        }
        this.commit();
    }

    protected void initTransaction() {
        this.oldWindow = (Window2D)this.window.clone();
    }

    protected void rollback() {
        this.window = this.oldWindow;
        this.oldWindow = null;
    }

    protected void commit() {
        this.oldWindow = null;
    }

    public void shiftCols(int delta) throws ArrayIndexOutOfBoundsException {
        String S = "ContainerSubset2D: shiftCols():";
        this.initTransaction();
        try {
            this.window.shiftCols(delta);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.rollback();
            throw e;
        }
    }

    public long size() {
        return this.window.windowSize();
    }

    public boolean exist(int row, int column) {
        String S = "ContainerSubset2D: exist():";
        if (!this.window.isValidCol(column)) {
            throw new ArrayIndexOutOfBoundsException(S + "The specified column is invalid, either negative or beyond upper index of window. " + column);
        }
        if (!this.window.isValidRow(row)) {
            throw new ArrayIndexOutOfBoundsException(S + "The specified row is invalid, either negative or beyond upper index of window. " + column);
        }
        int transRow = this.window.getTranslatedRow(row);
        int transCol = this.window.getTranslatedCol(column);
        return this.data.exist(transRow, transCol);
    }

    public void clear() {
        throw new UnsupportedOperationException("This function is not implemented in this subclass");
    }

    public void delete(int row, int column) throws ArrayIndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This function is not implemented in this subclass");
    }

    public ListIterator listIterator() {
        this.validate();
        AllByRowsIterator it = new AllByRowsIterator();
        return it;
    }

    public Object[][] toJava2D() {
        Object[][] d = new Object[this.window.numRows][this.window.numCols];
        for (int j = 0; j < this.window.numRows; ++j) {
            for (int i = 0; i < this.window.numCols; ++i) {
                int transRow = this.window.getTranslatedRow(j);
                int transCol = this.window.getTranslatedCol(i);
                d[i][j] = this.data.get(transRow, transCol);
            }
        }
        return d;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('\n');
        if (this.window == null) {
            b.append("No window specified, unable to print out locations");
        } else {
            int counter = 0;
            for (int i = 0; i < this.window.numRows; ++i) {
                for (int j = 0; j < this.window.numCols; ++j) {
                    b.append("" + i + '\t' + j + '\t');
                    Object obj = this.get(i, j);
                    if (obj != null) {
                        b.append(obj.toString());
                        ++counter;
                    } else {
                        b.append("NULL");
                    }
                    b.append('\n');
                }
            }
            b.append("\nNumber of Rows = " + this.window.numRows + '\n');
            b.append("Number of Columns = " + this.window.numCols + '\n');
            b.append("Size = " + this.window.numCols * this.window.numRows + '\n');
            b.append("Number of non-null objects = " + counter + '\n');
            b.append("Start Row of main Surface = " + this.window.startRow + '\n');
            b.append("Start COl of main Surface = " + this.window.startCol + '\n');
        }
        return b.toString();
    }

    public static void main(String[] args) {
        Object obj;
        String S = "ContainerSubset2D: Main(): ";
        System.out.println(S + "Starting");
        int xsize = 5;
        int ysize = 10;
        Container2D data = new Container2D(xsize, ysize);
        for (int x = 0; x < xsize; ++x) {
            for (int y = 0; y < ysize; ++y) {
                data.set(x, y, "[" + x + ", " + y + ']');
                System.out.println(S + data.get(x, y).toString());
            }
        }
        int numRows = 2;
        int numCols = 3;
        int startRow = 1;
        int startCol = 2;
        ContainerSubset2D sub = new ContainerSubset2D(numRows, numCols, startRow, startCol, data);
        sub.validate();
        System.out.println(S + sub.window.toString());
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getColumnIterator");
        ListIterator it = sub.getColumnIterator(0);
        while (it.hasNext()) {
            obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getRowIterator");
        it = sub.getRowIterator(0);
        while (it.hasNext()) {
            obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getAllByRowssIterator");
        it = sub.getAllByRowsIterator();
        while (it.hasNext()) {
            obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getAllByColumnsIterator");
        it = sub.getAllByColumnsIterator();
        while (it.hasNext()) {
            obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "List Iterator");
        it = sub.listIterator();
        while (it.hasNext()) {
            obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "Shifting rows by 2");
        System.out.println(S + "Shifting cols by 1");
        System.out.println(S + "List Iterator");
        sub.shiftCols(1);
        sub.shiftRows(2);
        it = sub.listIterator();
        while (it.hasNext()) {
            obj = it.next();
            if (obj != null) {
                System.out.println(S + obj.toString());
                continue;
            }
            System.out.println(S + obj.toString());
        }
        System.out.println(S + "Ending");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    class AllByRowsIterator
    extends Container2DListIterator
    implements ListIterator {
        int currentCol;
        int currentRow;
        int transRow;
        int transCol;

        public AllByRowsIterator() {
            this.currentCol = 0;
            this.currentRow = 0;
            this.transRow = 0;
            this.transCol = 0;
            this.lastIndex = ContainerSubset2D.this.window.windowSize();
            this.transRow = ContainerSubset2D.this.window.startRow;
            this.transCol = ContainerSubset2D.this.window.startCol;
        }

        public Object next() throws NoSuchElementException {
            try {
                Object object = ContainerSubset2D.this.data.get(this.transRow, this.transCol);
                ++this.currentCol;
                this.transCol = ContainerSubset2D.this.window.getTranslatedCol(this.currentCol);
                if (this.currentCol == ContainerSubset2D.this.window.numCols) {
                    this.currentCol = 0;
                    this.transCol = ContainerSubset2D.this.window.getTranslatedCol(this.currentCol);
                    ++this.currentRow;
                    this.transRow = ContainerSubset2D.this.window.getTranslatedRow(this.currentRow);
                }
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element." + e.toString());
            }
        }
    }

    class AllByColumnsIterator
    extends Container2DListIterator
    implements ListIterator {
        int currentColumn;
        int currentRow;
        int transRow;
        int transCol;

        public AllByColumnsIterator() {
            this.currentColumn = 0;
            this.currentRow = 0;
            this.transRow = 0;
            this.transCol = 0;
            this.lastIndex = ContainerSubset2D.this.window.windowSize();
            this.transRow = ContainerSubset2D.this.window.startRow;
            this.transCol = ContainerSubset2D.this.window.startCol;
        }

        public Object next() throws NoSuchElementException {
            try {
                Object object = ContainerSubset2D.this.data.get(this.transRow, this.transCol);
                ++this.currentRow;
                this.transRow = ContainerSubset2D.this.window.getTranslatedRow(this.currentRow);
                if (this.currentRow == ContainerSubset2D.this.window.numRows) {
                    this.currentRow = 0;
                    this.transRow = ContainerSubset2D.this.window.getTranslatedRow(this.currentRow);
                    ++this.currentColumn;
                    this.transCol = ContainerSubset2D.this.window.getTranslatedCol(this.currentColumn);
                }
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element. " + e.toString());
            }
        }
    }

    class RowIterator
    extends Container2DListIterator
    implements ListIterator {
        static final String C = "RowIterator";
        int translatedPinnedCol;

        public RowIterator(int col) throws ArrayIndexOutOfBoundsException {
            String S = "RowIterator: Constructor():";
            if (!ContainerSubset2D.this.window.isValidRow(col)) {
                throw new ArrayIndexOutOfBoundsException(S + "The specified col is invalid, either negative or beyond upper index of window. " + col);
            }
            this.translatedPinnedCol = ContainerSubset2D.this.window.getTranslatedRow(col);
            this.lastIndex = ContainerSubset2D.this.window.numRows;
        }

        public Object next() throws NoSuchElementException {
            try {
                int transRow = ContainerSubset2D.this.window.getTranslatedRow(this.cursor);
                Object object = ContainerSubset2D.this.data.get(transRow, this.translatedPinnedCol);
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element." + e.toString());
            }
        }
    }

    class ColumnIterator
    extends Container2DListIterator
    implements ListIterator {
        static final String C = "ColumnIterator";
        int translatedPinnedRow;

        public ColumnIterator(int row) throws ArrayIndexOutOfBoundsException {
            String S = "ColumnIterator: Constructor():";
            if (!ContainerSubset2D.this.window.isValidRow(row)) {
                throw new ArrayIndexOutOfBoundsException(S + "The specified row is invalid, either negative or beyond upper index of window. " + row);
            }
            this.translatedPinnedRow = ContainerSubset2D.this.window.getTranslatedRow(row);
            this.lastIndex = ContainerSubset2D.this.window.numCols;
        }

        public Object next() throws NoSuchElementException {
            try {
                int transColumn = ContainerSubset2D.this.window.getTranslatedCol(this.cursor);
                Object object = ContainerSubset2D.this.data.get(this.translatedPinnedRow, transColumn);
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element." + e.toString());
            }
        }
    }

    abstract class Container2DListIterator
    implements ListIterator {
        int cursor = 0;
        int lastRet = -1;
        int lastIndex = 0;

        public void set(Object obj) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("set(Object obj) Not implemented.");
        }

        public boolean hasNext() {
            return this.cursor != this.lastIndex;
        }

        public int nextIndex() {
            return this.cursor;
        }

        public abstract Object next() throws NoSuchElementException;

        public Object previous() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        public int previousIndex() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        public boolean hasPrevious() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        public void add(Object obj) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("add(Object obj) Not implemented.");
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove() Not implemented.");
        }
    }
}

