/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.Serializable;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.data.DataPoint2DComparatorAPI;
import org.opensha.commons.exceptions.InvalidRangeException;

public class DataPoint2DToleranceComparator
implements DataPoint2DComparatorAPI,
Serializable {
    protected double tolerance = 0.0;

    public DataPoint2DToleranceComparator() throws InvalidRangeException {
    }

    public DataPoint2DToleranceComparator(double tolerance) throws InvalidRangeException {
        if (tolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        this.tolerance = tolerance;
    }

    public void setTolerance(double newTolerance) throws InvalidRangeException {
        if (this.tolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        this.tolerance = newTolerance;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public int compare(Object o1, Object o2) throws ClassCastException {
        double x2;
        if (!(o1 instanceof DataPoint2D)) {
            throw new ClassCastException("The first object is not an DataPoint2D, unable to compare");
        }
        if (!(o2 instanceof DataPoint2D)) {
            throw new ClassCastException("The second object is not an DataPoint2D, unable to compare");
        }
        double x1 = ((DataPoint2D)o1).getX();
        if (Math.abs(x1 - (x2 = ((DataPoint2D)o2).getX())) <= this.tolerance) {
            return 0;
        }
        if (x1 > x2) {
            return 1;
        }
        return -1;
    }
}

