/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.estimate;

import org.opensha.commons.data.estimate.DiscretizedFuncEstimate;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;

public class DiscreteValueEstimate
extends DiscretizedFuncEstimate {
    public static final String NAME = "Discrete Values";

    public DiscreteValueEstimate(ArbitrarilyDiscretizedFunc func, boolean isNormalized) {
        super(func, isNormalized);
    }

    public String getName() {
        return NAME;
    }

    public DiscretizedFunc getCDF_Test() {
        ArbitrarilyDiscretizedFunc cdfFunc = new ArbitrarilyDiscretizedFunc();
        int num = this.func.getNum();
        double delta = 0.001;
        for (int i = 0; i < num; ++i) {
            double x = this.func.getX(i);
            cdfFunc.set(x, this.getProbLessThanEqual(x));
            if (i >= num - 1) continue;
            x = this.func.getX(i + 1) - delta;
            cdfFunc.set(x, this.getProbLessThanEqual(x));
        }
        cdfFunc.setInfo("CDF from Discrete Distribution");
        return cdfFunc;
    }

    public double getProbLessThanEqual(double x) {
        if (x < this.cumDistFunc.getX(0)) {
            return 0.0;
        }
        int num = this.cumDistFunc.getNum();
        for (int i = 1; i < num; ++i) {
            if (!(this.cumDistFunc.getX(i) > x)) continue;
            return this.cumDistFunc.getY(i - 1);
        }
        return 1.0;
    }

    public DiscretizedFunc getPDF_Test() {
        return this.func;
    }

    public double getRandomValue() {
        double randomVal = Math.random();
        int num = this.cumDistFunc.getNum();
        for (int i = 0; i < num; ++i) {
            if (!(this.cumDistFunc.getY(i) > randomVal)) continue;
            return this.cumDistFunc.getX(i);
        }
        return Double.NaN;
    }
}

