/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.data.DataPoint2DComparatorAPI;
import org.opensha.commons.data.DataPoint2DToleranceComparator;
import org.opensha.commons.data.DataPoint2DTreeMap;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFuncAPI;
import org.opensha.commons.exceptions.DataPoint2DException;
import org.opensha.commons.exceptions.InvalidRangeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbitrarilyDiscretizedFunc
extends DiscretizedFunc
implements Serializable {
    private static final long serialVersionUID = 253638618L;
    protected static final String C = "ArbitrarilyDiscretizedFunc";
    protected static final boolean D = true;
    protected DataPoint2DTreeMap points = null;
    private static String TAB = "\t";

    public ArbitrarilyDiscretizedFunc(DiscretizedFunc func) {
        this(func.getTolerance());
        Iterator<DataPoint2D> it = func.getPointsIterator();
        while (it.hasNext()) {
            this.set(it.next());
        }
        this.setInfo(func.getInfo());
        this.setName(func.getName());
        this.setXAxisName(func.getXAxisName());
        this.setYAxisName(func.getYAxisName());
    }

    public ArbitrarilyDiscretizedFunc(Comparator comparator) {
        if (!(comparator instanceof DataPoint2DComparatorAPI)) {
            throw new DataPoint2DException("Comparator must implement DataPoint2DComparatorAPI");
        }
        this.points = new DataPoint2DTreeMap(comparator);
    }

    public ArbitrarilyDiscretizedFunc(DataPoint2DComparatorAPI comparator) {
        this.points = new DataPoint2DTreeMap(comparator);
    }

    public ArbitrarilyDiscretizedFunc(double toleranace) {
        DataPoint2DToleranceComparator comparator = new DataPoint2DToleranceComparator();
        comparator.setTolerance(this.tolerance);
        this.points = new DataPoint2DTreeMap(comparator);
    }

    public ArbitrarilyDiscretizedFunc() {
        this.points = new DataPoint2DTreeMap();
    }

    @Override
    public void setTolerance(double newTolerance) throws InvalidRangeException {
        if (newTolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        this.tolerance = newTolerance;
        this.points.setTolerance(newTolerance);
    }

    @Override
    public int getNum() {
        return this.points.size();
    }

    @Override
    public double getMinX() {
        return ((DataPoint2D)this.points.firstKey()).getX();
    }

    @Override
    public double getMaxX() {
        return ((DataPoint2D)this.points.lastKey()).getX();
    }

    @Override
    public double getMinY() {
        return this.points.getMinY();
    }

    @Override
    public double getMaxY() {
        return this.points.getMaxY();
    }

    @Override
    public DataPoint2D get(int index) {
        return this.points.get(index);
    }

    @Override
    public double getX(int index) {
        return this.get(index).getX();
    }

    @Override
    public double getY(int index) {
        return this.get(index).getY();
    }

    @Override
    public double getY(double x) {
        return this.points.get(x).getY();
    }

    @Override
    public int getIndex(DataPoint2D point) {
        return this.points.getIndex(point);
    }

    @Override
    public int getXIndex(double x) {
        return this.points.getIndex(new DataPoint2D(x, 0.0));
    }

    @Override
    public void set(DataPoint2D point) throws DataPoint2DException {
        this.points.put(point);
    }

    @Override
    public void set(double x, double y) throws DataPoint2DException {
        this.set(new DataPoint2D(x, y));
    }

    @Override
    public void set(int index, double y) throws DataPoint2DException {
        DataPoint2D point = this.get(index);
        if (point != null) {
            point.setY(y);
            this.set(point);
        }
    }

    @Override
    public boolean hasPoint(DataPoint2D point) {
        int index = this.getIndex(point);
        return index >= 0;
    }

    @Override
    public boolean hasPoint(double x, double y) {
        return this.hasPoint(new DataPoint2D(x, y));
    }

    @Override
    public Iterator<DataPoint2D> getPointsIterator() {
        Set keys = this.points.keySet();
        if (keys != null) {
            return keys.iterator();
        }
        return null;
    }

    @Override
    public ListIterator<Double> getXValuesIterator() {
        ArrayList<Double> list = new ArrayList<Double>();
        int max = this.points.size();
        for (int i = 0; i < max; ++i) {
            list.add(new Double(this.getX(i)));
        }
        return list.listIterator();
    }

    @Override
    public ListIterator<Double> getYValuesIterator() {
        ArrayList<Double> list = new ArrayList<Double>();
        int max = this.points.size();
        for (int i = 0; i < max; ++i) {
            list.add(new Double(this.getY(i)));
        }
        return list.listIterator();
    }

    @Override
    public double getFirstInterpolatedX(double y) {
        int i;
        int max = this.points.size();
        if (max == 1 && y == this.getY(0)) {
            return this.getX(0);
        }
        double y1 = Double.NaN;
        double y2 = Double.NaN;
        boolean found = false;
        for (i = 0; i < max - 1; ++i) {
            y1 = this.getY(i);
            y2 = this.getY(i + 1);
            if (!(y <= y1 && y >= y2 && y2 <= y1) && (!(y >= y1) || !(y <= y2) || !(y2 >= y1))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidRangeException("Y Value (" + y + ") must be within the range: " + this.getY(0) + " and " + this.getY(max - 1));
        }
        double x1 = this.getX(i);
        double x2 = this.getX(i + 1);
        double x = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
        return x;
    }

    @Override
    public double getFirstInterpolatedX_inLogXLogYDomain(double y) {
        int i;
        int max = this.points.size();
        if (max == 1 && y == this.getY(0)) {
            return this.getX(0);
        }
        double y1 = Double.NaN;
        double y2 = Double.NaN;
        boolean found = false;
        for (i = 0; i < max - 1; ++i) {
            y1 = this.getY(i);
            y2 = this.getY(i + 1);
            if (!(y <= y1 && y >= y2) && (!(y >= y1) || !(y <= y2))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidRangeException("Y Value (" + y + ") must be within the range: " + this.getY(0) + " and " + this.getY(max - 1));
        }
        double x1 = Math.log(this.getX(i));
        double x2 = Math.log(this.getX(i + 1));
        y1 = Math.log(y1);
        y2 = Math.log(y2);
        y = Math.log(y);
        double x = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
        return Math.exp(x);
    }

    @Override
    public double getInterpolatedY(double x) {
        int max = this.points.size();
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        if (x > this.getX(max - 1) || x < this.getX(0)) {
            throw new InvalidRangeException("x Value must be within the range: " + this.getX(0) + " and " + this.getX(max - 1));
        }
        if (x == this.getX(max - 1)) {
            return this.getY(x);
        }
        for (int i = 0; i < max - 1; ++i) {
            x1 = this.getX(i);
            x2 = this.getX(i + 1);
            if (x >= x1 && x <= x2) break;
        }
        double y1 = this.getY(x1);
        double y2 = this.getY(x2);
        double y = (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        return y;
    }

    @Override
    public double getInterpolatedY_inLogXLogYDomain(double x) {
        int max = this.points.size();
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        if (x > this.getX(max - 1) || x < this.getX(0)) {
            throw new InvalidRangeException("x Value must be within the range: " + this.getX(0) + " and " + this.getX(max - 1));
        }
        if (x == this.getX(max - 1)) {
            return this.getY(x);
        }
        for (int i = 0; i < max - 1; ++i) {
            x1 = this.getX(i);
            x2 = this.getX(i + 1);
            if (x >= x1 && x <= x2) break;
        }
        double y1 = this.getY(x1);
        double y2 = this.getY(x2);
        if (y1 == 0.0 && y2 == 0.0) {
            return 0.0;
        }
        if (y1 == 0.0) {
            y1 = Double.MIN_VALUE;
        }
        if (y2 == 0.0) {
            y2 = Double.MIN_VALUE;
        }
        double logY1 = Math.log(y1);
        double logY2 = Math.log(y2);
        x1 = Math.log(x1);
        x2 = Math.log(x2);
        double y = (logY2 - logY1) * ((x = Math.log(x)) - x1) / (x2 - x1) + logY1;
        double expY = Math.exp(y);
        if (expY == Double.MIN_VALUE) {
            expY = 0.0;
        }
        return expY;
    }

    @Override
    public double getInterpolatedY_inLogYDomain(double x) {
        int max = this.points.size();
        double x1 = Double.NaN;
        double x2 = Double.NaN;
        if (x > this.getX(max - 1) || x < this.getX(0)) {
            throw new InvalidRangeException("x Value must be within the range: " + this.getX(0) + " and " + this.getX(max - 1));
        }
        if (x == this.getX(max - 1)) {
            return this.getY(x);
        }
        for (int i = 0; i < max - 1; ++i) {
            x1 = this.getX(i);
            x2 = this.getX(i + 1);
            if (x >= x1 && x <= x2) break;
        }
        double y1 = this.getY(x1);
        double y2 = this.getY(x2);
        if (y1 == 0.0 && y2 == 0.0) {
            return 0.0;
        }
        double logY1 = Math.log(y1);
        double logY2 = Math.log(y2);
        double y = (logY2 - logY1) * (x - x1) / (x2 - x1) + logY1;
        return Math.exp(y);
    }

    private double extrapolate(double x1, double x2, double y1, double y2, double x) {
        double slope = (y2 - y1) / (x2 - x1);
        double intercept = y1 - slope * x1;
        return slope * x + intercept;
    }

    public double getInterpExterpY_inLogYDomain(double x) {
        try {
            double v = this.getInterpolatedY_inLogYDomain(x);
            return v;
        }
        catch (InvalidRangeException irx) {
            if (x < this.getX(0)) {
                return Math.exp(this.extrapolate(this.getX(0), this.getX(1), Math.log(this.getY(0)), Math.log(this.getY(1)), x));
            }
            int max = this.points.size();
            return Math.exp(this.extrapolate(this.getX(max - 2), this.getX(max - 1), Math.log(this.getY(max - 2)), Math.log(this.getY(max - 1)), x));
        }
    }

    @Override
    public ArbitrarilyDiscretizedFunc deepClone() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.setName(this.getName());
        function.setTolerance(this.getTolerance());
        function.setInfo(this.getInfo());
        function.setXAxisName(this.getXAxisName());
        function.setYAxisName(this.getYAxisName());
        Iterator<DataPoint2D> it = this.getPointsIterator();
        if (it != null) {
            while (it.hasNext()) {
                function.set((DataPoint2D)it.next().clone());
            }
        }
        return function;
    }

    public boolean equalXValues(DiscretizedFuncAPI function) {
        if (this.getNum() != function.getNum()) {
            return false;
        }
        Iterator<DataPoint2D> it = this.getPointsIterator();
        while (it.hasNext()) {
            DataPoint2D point = it.next();
            if (function.hasPoint(point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Name: " + this.getName() + '\n');
        b.append("Num Points: " + this.getNum() + '\n');
        b.append("Info: " + this.getInfo() + "\n\n");
        b.append("X, Y Data:\n");
        b.append(this.getMetadataString() + '\n');
        return b.toString();
    }

    @Override
    public String getMetadataString() {
        StringBuffer b = new StringBuffer();
        Iterator<DataPoint2D> it2 = this.getPointsIterator();
        while (it2.hasNext()) {
            DataPoint2D point = it2.next();
            double x = point.getX();
            double y = point.getY();
            b.append((float)x + TAB + (float)y + '\n');
        }
        return b.toString();
    }

    public String toDebugString() {
        StringBuffer b = new StringBuffer();
        b.append("ArbitrarilyDiscretizedFunc: Log values:\n");
        Iterator<DataPoint2D> it = this.getPointsIterator();
        while (it.hasNext()) {
            DataPoint2D point = it.next();
            b.append(point.toString() + '\n');
        }
        return b.toString();
    }

    private void writeObject(ObjectOutputStream s) {
        Iterator<DataPoint2D> it = this.getPointsIterator();
        try {
            s.writeObject(new Integer(this.getNum()));
            while (it.hasNext()) {
                DataPoint2D data = it.next();
                s.writeObject(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) {
        try {
            if (this.points == null) {
                this.points = new DataPoint2DTreeMap();
            }
            int num = (Integer)s.readObject();
            for (int i = 0; i < num; ++i) {
                DataPoint2D data = (DataPoint2D)s.readObject();
                this.set(data);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IO Exception ");
            e.printStackTrace();
        }
    }

    public ArbitrarilyDiscretizedFunc getYY_Function(DiscretizedFuncAPI function) {
        if (this.getNum() != function.getNum()) {
            throw new InvalidRangeException("This operation cannot be performed on functions with different size");
        }
        ArbitrarilyDiscretizedFunc newFunction = new ArbitrarilyDiscretizedFunc();
        int numPoints = function.getNum();
        for (int j = 0; j < numPoints; ++j) {
            newFunction.set(this.getY(j), function.getY(j));
        }
        return newFunction;
    }

    @Override
    public boolean areAllXValuesInteger(double tolerance) {
        int num = this.getNum();
        for (int i = 0; i < num; ++i) {
            double x = this.getX(i);
            double diff = Math.abs(x - Math.rint(x));
            if (!(diff > tolerance)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.points.clear();
    }

    public double[] getXVals() {
        double[] d = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            d[i] = this.getX(i);
        }
        return d;
    }

    public double[] getYVals() {
        double[] d = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            d[i] = this.getY(i);
        }
        return d;
    }
}

