/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.region;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.math.util.MathUtils;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.BorderType;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.exceptions.InvalidRangeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GriddedRegion
extends Region
implements Iterable<Location> {
    private static final long serialVersionUID = 1L;
    public static final String XML_METADATA_NAME = "evenlyGriddedGeographicRegion";
    public static final String XML_METADATA_GRID_SPACING_NAME = "spacing";
    public static final String XML_METADATA_ANCHOR_NAME = "anchor";
    public static final String XML_METADATA_NUM_POINTS_NAME = "numPoints";
    public static final Location ANCHOR_0_0 = Location.immutableLocation(0.0, 0.0);
    private double[] lonNodes;
    private double[] latNodes;
    private double[] lonNodeEdges;
    private double[] latNodeEdges;
    private Location anchor;
    private int[] gridIndices;
    private LocationList nodeList;
    private double spacing;
    private int nodeCount;
    private int gridSize;

    public GriddedRegion(Location loc1, Location loc2, double spacing, Location anchor) {
        super(loc1, loc2);
        this.initGrid(spacing, anchor);
    }

    public GriddedRegion(LocationList border, BorderType type, double spacing, Location anchor) {
        super(border, type);
        this.initGrid(spacing, anchor);
    }

    public GriddedRegion(Location center, double radius, double spacing, Location anchor) {
        super(center, radius);
        this.initGrid(spacing, anchor);
    }

    public GriddedRegion(LocationList line, double buffer, double spacing, Location anchor) {
        super(line, buffer);
        this.initGrid(spacing, anchor);
    }

    public GriddedRegion(Region region, double spacing, Location anchor) {
        super(region);
        this.initGrid(spacing, anchor);
    }

    public double getSpacing() {
        return this.spacing;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public boolean isEmpty() {
        return this.nodeCount == 0;
    }

    public boolean equals(GriddedRegion gr) {
        if (!super.equals(gr)) {
            return false;
        }
        if (!this.anchor.equals(gr.anchor)) {
            return false;
        }
        return this.spacing == gr.spacing;
    }

    public GriddedRegion subRegion(Region region) {
        Region newRegion = Region.intersect(this, region);
        if (newRegion == null) {
            return null;
        }
        return new GriddedRegion(newRegion, this.spacing, this.anchor);
    }

    @Override
    public void addInterior(Region region) {
        throw new UnsupportedOperationException("A GriddedRegion may not have an interior Region set");
    }

    @Override
    public Iterator<Location> iterator() {
        return this.nodeList.iterator();
    }

    public LocationList getNodeList() {
        return this.nodeList;
    }

    public Location locationForIndex(int index) {
        try {
            return this.nodeList.getLocationAt(index);
        }
        catch (InvalidRangeException e) {
            return null;
        }
    }

    public int indexForLocation(Location loc) {
        int lonIndex = GriddedRegion.getNodeIndex(this.lonNodeEdges, loc.getLongitude());
        if (lonIndex == -1) {
            return -1;
        }
        int latIndex = GriddedRegion.getNodeIndex(this.latNodeEdges, loc.getLatitude());
        if (latIndex == -1) {
            return -1;
        }
        int gridIndex = latIndex * this.lonNodes.length + lonIndex;
        return this.gridIndices[gridIndex];
    }

    public double getMinGridLat() {
        return this.latNodes[0];
    }

    public double getMaxGridLat() {
        return this.latNodes[this.latNodes.length - 1];
    }

    public double getMinGridLon() {
        return this.lonNodes[0];
    }

    public double getMaxGridLon() {
        return this.lonNodes[this.lonNodes.length - 1];
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml.addAttribute(XML_METADATA_GRID_SPACING_NAME, this.getSpacing() + "");
        Element xml_anchor = root.addElement(XML_METADATA_ANCHOR_NAME);
        xml = this.anchor.toXMLMetadata(xml_anchor);
        xml.addAttribute(XML_METADATA_NUM_POINTS_NAME, this.getNodeCount() + "");
        xml = super.toXMLMetadata(xml);
        return root;
    }

    public static GriddedRegion fromXMLMetadata(Element root) {
        double gridSpacing = Double.parseDouble(root.attribute(XML_METADATA_GRID_SPACING_NAME).getValue());
        Region geoRegion = Region.fromXMLMetadata(root.element("Region"));
        LocationList outline = geoRegion.getBorder();
        Location xml_anchor = Location.fromXMLMetadata(root.element(XML_METADATA_ANCHOR_NAME).element("Location"));
        return new GriddedRegion(outline, BorderType.MERCATOR_LINEAR, gridSpacing, xml_anchor);
    }

    private static int getNodeIndex(double[] edgeVals, double value) {
        int idx = Arrays.binarySearch(edgeVals, value);
        return idx < -1 ? -idx - 2 : (idx == edgeVals.length - 1 ? -1 : idx);
    }

    private void initGrid(double spacing, Location anchor) {
        this.setSpacing(spacing);
        this.setAnchor(anchor);
        this.initLatLonArrays();
        this.initNodes();
    }

    private void setSpacing(double spacing) {
        if (spacing <= 0.0 || spacing > 5.0) {
            throw new IllegalArgumentException("Grid spacing must be 0\u00b0 > S \u2265 5\u00b0");
        }
        this.spacing = spacing;
    }

    private void setAnchor(Location anchor) {
        if (anchor == null) {
            this.anchor = Location.immutableLocation(this.getMinLat(), this.getMinLon());
        } else {
            double newLat = GriddedRegion.computeAnchor(this.getMinLat(), anchor.getLatitude(), this.spacing);
            double newLon = GriddedRegion.computeAnchor(this.getMinLon(), anchor.getLongitude(), this.spacing);
            this.anchor = Location.immutableLocation(newLat, newLon);
        }
    }

    private static double computeAnchor(double min, double anchor, double spacing) {
        double delta = anchor - min;
        double num_div = Math.floor(delta / spacing);
        double offset = delta - num_div * spacing;
        double newAnchor = min + offset;
        return newAnchor < min ? newAnchor + spacing : newAnchor;
    }

    private void initNodes() {
        this.gridSize = this.lonNodes.length * this.latNodes.length;
        this.gridIndices = new int[this.gridSize];
        this.nodeList = new LocationList();
        int node_idx = 0;
        int grid_idx = 0;
        for (double lat : this.latNodes) {
            for (double lon : this.lonNodes) {
                if (this.contains(lat, lon)) {
                    this.nodeList.addLocation(new Location(lat, lon));
                    this.gridIndices[grid_idx] = node_idx++;
                } else {
                    this.gridIndices[grid_idx] = -1;
                }
                ++grid_idx;
            }
        }
        this.nodeCount = node_idx;
    }

    private void initLatLonArrays() {
        this.lonNodes = GriddedRegion.initNodeCenters(this.anchor.getLongitude(), this.getMaxLon(), this.spacing);
        this.latNodes = GriddedRegion.initNodeCenters(this.anchor.getLatitude(), this.getMaxLat(), this.spacing);
        this.lonNodeEdges = GriddedRegion.initNodeEdges(this.anchor.getLongitude(), this.getMaxLon(), this.spacing);
        this.latNodeEdges = GriddedRegion.initNodeEdges(this.anchor.getLatitude(), this.getMaxLat(), this.spacing);
    }

    private static double[] initNodeCenters(double min, double max, double width) {
        int nodeCount = (int)Math.floor((max - min) / width) + 1;
        double firstCenterVal = min;
        return GriddedRegion.buildArray(firstCenterVal, nodeCount, width);
    }

    private static double[] initNodeEdges(double min, double max, double width) {
        int edgeCount = (int)Math.floor((max - min) / width) + 2;
        double firstEdgeVal = min - width / 2.0;
        return GriddedRegion.buildArray(firstEdgeVal, edgeCount, width);
    }

    private static double[] buildArray(double startVal, int count, double interval) {
        double[] values = new double[count];
        int scale = 5;
        double val = startVal;
        for (int i = 0; i < count; ++i) {
            values[i] = MathUtils.round((double)val, (int)scale);
            val += interval;
        }
        return values;
    }

    public Location getAnchor() {
        return this.anchor;
    }

    public static void main(String[] args) {
    }
}

