/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.opensha.commons.calc.ArcsecondConverter;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.impl.SRTM30PlusTopography;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.exceptions.RegionConstraintException;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRTM30PlusTopoSlope
extends AbstractSiteData<Double> {
    public static final String NAME = "SRTM30 Plus Topographic Slope";
    public static final String SHORT_NAME = "SRTM30_Plus_Slope";
    public static final double arcSecondSpacing = 30.0;
    public static final double spacing = ArcsecondConverter.getDegrees(30.0);
    public static final int nx = 43200;
    public static final int ny = 21600;
    public static final double minLon = 0.0 + spacing / 2.0;
    public static final double minLat = -90.0 + spacing / 2.0;
    public static final String SERVLET_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/SiteData/SRTM30_Plus_Slope";
    private boolean useServlet;
    private Region region;
    private RandomAccessFile file = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private SiteDataServletAccessor<Double> servlet = null;

    public SRTM30PlusTopoSlope() throws IOException {
        this(null, true);
    }

    public SRTM30PlusTopoSlope(String fileName) throws IOException {
        this(fileName, false);
    }

    private SRTM30PlusTopoSlope(String fileName, boolean useServlet) throws IOException {
        this.useServlet = useServlet;
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor(SERVLET_URL);
        } else {
            this.file = new RandomAccessFile(new File(fileName), "r");
            this.recordBuffer = new byte[4];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(3, 43200, 21600, minLat, minLon, spacing);
        this.calc.setStartBottom(true);
        this.calc.setStartLeft(true);
        this.region = Region.getGlobalRegion();
    }

    @Override
    public Region getApplicableRegion() {
        return this.region;
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getMetadata() {
        return "Topographic slope derived from version 5.0 (September 16, 2008) of STRM30_PLUS 30 Arcsecond DigitalElevation Model.\n\nConverted to topographic slope with the Generic Mapping Tools command 'grdgradient':\ngrdgradient topofile.grd -Gtemp.grd -S$gradient.grd -M -D\n\nDEM downloaded from: http://topex.ucsd.edu/WWW_html/srtm30_plus.html\n\n (February, 2009)From the web page:\nLand data are based on the 1-km averages of topography derived from the USGS SRTM30 grided DEM data product created with data from the NASA Shuttle Radar Topography Mission. GTOPO30 data are used for high latitudes where SRTM data are not available.\n\nOcean data are based on the Smith and Sandwell global 1-minute grid between latitudes +/- 81 degrees. Higher resolution grids have been added from the LDEO Ridge Multibeam Synthesis Project, the JAMSTEC Data Site for Research Cruises, and the NGDC Coastal Relief Model. Arctic bathymetry is from the International Bathymetric Chart of the Oceans (IBCAO) [Jakobsson et al., 2003].";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getResolution() {
        return spacing;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getDataType() {
        return "Topographic Slope (m/m)";
    }

    @Override
    public String getDataMeasurementType() {
        return "Measured";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.servlet.getValue(loc);
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos < 0L || pos > this.calc.getMaxFilePos()) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        return val;
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            return this.servlet.getValues(locs);
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val);
    }

    public static void main(String[] args) throws IOException, RegionConstraintException {
        SRTM30PlusTopography tdata = new SRTM30PlusTopography();
        SRTM30PlusTopoSlope data = new SRTM30PlusTopoSlope();
        System.out.println(data.getValue(new Location(34.0, -118.0)));
        System.out.println(tdata.getValue(new Location(34.0, -118.0)));
        System.out.println(data.getValue(new Location(32.0, -118.0)));
        System.out.println(tdata.getValue(new Location(32.0, -118.0)));
        System.out.println(data.getValue(new Location(0.0, 0.0)));
        System.out.println(tdata.getValue(new Location(0.0, 0.0)));
        System.out.println(data.getValue(new Location(0.0, -1.0)));
        System.out.println(tdata.getValue(new Location(0.0, -1.0)));
        GriddedRegion region = new GriddedRegion(new Location(32.0, -121.0), new Location(35.0, -115.0), 0.02, new Location(0.0, 0.0));
    }
}

