/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gridComputing;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.gridComputing.GridCalculationParameters;
import org.opensha.commons.gridComputing.GridResources;
import org.opensha.commons.metadata.XMLSaveable;

public class GridJob
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "GridJob";
    private GridResources resources;
    protected GridCalculationParameters calcParams;
    private String jobID;
    private String jobName;
    private String email;
    private String configFileName;

    public GridJob(GridResources resources, GridCalculationParameters calcParams, String jobID, String jobName, String email, String configFileName) {
        this.resources = resources;
        this.calcParams = calcParams;
        this.jobID = jobID;
        this.jobName = jobName;
        this.email = email;
        this.configFileName = configFileName;
    }

    public GridResources getResources() {
        return this.resources;
    }

    public GridCalculationParameters getCalcParams() {
        return this.calcParams;
    }

    public void setJobID(String jobID) {
        this.jobID = jobID;
    }

    public String getJobID() {
        return this.jobID;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml = this.resources.toXMLMetadata(xml);
        xml = this.calcParams.toXMLMetadata(xml);
        xml.addAttribute("jobID", this.jobID);
        xml.addAttribute("jobName", this.jobName);
        xml.addAttribute("email", this.email);
        xml.addAttribute("configFileName", this.configFileName);
        return root;
    }

    public static GridJob fromXMLMetadata(Element jobElem) {
        GridResources resources = GridResources.fromXMLMetadata(jobElem.element("GridResources"));
        GridCalculationParameters resourceProvider = new GridCalculationParameters(jobElem, XML_METADATA_NAME);
        String jobID = jobElem.attributeValue("jobID");
        Attribute jobNameAtt = jobElem.attribute("jobName");
        String jobName = jobNameAtt == null ? jobID : jobNameAtt.getValue();
        String email = jobElem.attributeValue("email");
        String configFileName = jobElem.attributeValue("configFileName");
        return new GridJob(resources, resourceProvider, jobID, jobName, email, configFileName);
    }

    public String toString() {
        String str = "";
        str = str + "************************\n";
        str = str + "******* Grid Job *******\n";
        str = str + "************************\n";
        str = str + this.resources.toString() + "\n";
        str = str + this.calcParams.toString() + "\n";
        str = str + "jobID: " + this.jobID + "\n";
        str = str + "jobName: " + this.jobName + "\n";
        str = str + "email: " + this.email + "\n";
        str = str + "configFileName: " + this.configFileName;
        return str;
    }

    public static String indentString(String str) {
        str = "\t" + str;
        str = str.replace("\n", "\n\t");
        return str;
    }
}

