/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class SidesBorder
implements Border,
Serializable {
    Color topColor = new Color(120, 160, 100);
    Color bottomColor = Color.yellow;
    Color leftColor = Color.red;
    Color rightColor = Color.blue;
    private int height = 0;
    private int width = 0;
    private boolean drawLeft = true;
    private boolean drawRight = true;
    private boolean drawTop = true;
    private boolean drawBottom = true;

    public SidesBorder() {
    }

    public SidesBorder(Color topColor, Color bottomColor, Color leftColor, Color rightColor) {
        this.topColor = topColor;
        this.bottomColor = bottomColor;
        this.leftColor = leftColor;
        this.rightColor = rightColor;
    }

    public void setLeftColor(Color a) {
        this.leftColor = a;
    }

    public Color getLeftColor() {
        return this.leftColor;
    }

    public void setRightColor(Color a) {
        this.rightColor = a;
    }

    public Color getRightColor() {
        return this.rightColor;
    }

    public void setTopColor(Color a) {
        this.topColor = a;
    }

    public Color getTopColor() {
        return this.topColor;
    }

    public void setBottomColor(Color a) {
        this.bottomColor = a;
    }

    public Color getBottomColor() {
        return this.bottomColor;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int a) {
        this.width = a;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int a) {
        this.height = a;
    }

    public void setDrawLeft(boolean a) {
        this.drawLeft = a;
    }

    public boolean isDrawLeft() {
        return this.drawLeft;
    }

    public void setDrawRight(boolean a) {
        this.drawRight = a;
    }

    public boolean isDrawRight() {
        return this.drawRight;
    }

    public void setDrawTop(boolean a) {
        this.drawTop = a;
    }

    public boolean isDrawTop() {
        return this.drawTop;
    }

    public void setDrawBottom(boolean a) {
        this.drawBottom = a;
    }

    public boolean isDrawBottom() {
        return this.drawBottom;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.height, this.width, this.height, this.width);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        --w;
        --h;
        if (this.isDrawTop()) {
            g.setColor(this.topColor);
            if (this.width > 0 || this.height > 0) {
                g.drawArc(x, y, 2 * this.width, 2 * this.height, 180, -90);
                g.drawArc(x + w - 2 * this.width, y, 2 * this.width, 2 * this.height, 90, -90);
            }
            g.drawLine(x + this.width, y, x + w - this.width, y);
        }
        if (this.isDrawLeft()) {
            g.setColor(this.leftColor);
            g.drawLine(x, y + h - this.height, x, y + this.height);
        }
        if (this.isDrawBottom()) {
            g.setColor(this.bottomColor);
            if (this.width > 0 || this.height > 0) {
                g.drawArc(x + w - 2 * this.width, y + h - 2 * this.height, 2 * this.width, 2 * this.height, 0, -90);
                g.drawArc(x, y + h - 2 * this.height, 2 * this.width, 2 * this.height, -90, -90);
            }
            g.drawLine(x + this.width, y + h, x + w - this.width, y + h);
        }
        if (this.isDrawRight()) {
            g.setColor(this.rightColor);
            g.drawLine(x + w, y + this.height, x + w, y + h - this.height);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Custom Border: SideBorder");
        JLabel label = new JLabel("SideBorder");
        ((JPanel)frame.getContentPane()).setBorder(new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new SidesBorder(Color.blue, Color.black, Color.red, Color.yellow)));
        frame.getContentPane().add(label);
        frame.setBounds(0, 0, 300, 150);
        frame.setVisible(true);
    }

    public String toString() {
        StringBuffer b = new StringBuffer("SidesBorder:\n");
        b.append("\tDraw Top = ");
        b.append(this.drawTop);
        b.append("\tDraw Bottom = ");
        b.append(this.drawBottom);
        b.append("\tDraw Left = ");
        b.append(this.drawLeft);
        b.append("\tDraw Right = ");
        b.append(this.drawRight);
        return b.toString();
    }
}

