/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart;

import java.util.ArrayList;
import java.util.ListIterator;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.function.DiscretizedFuncAPI;
import org.opensha.commons.data.function.DiscretizedFuncList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;

public class DiscretizedFunctionXYDataSet
extends AbstractXYDataset
implements NamedObjectAPI,
IntervalXYDataset,
TableXYDataset {
    protected static final String C = "DiscretizedFunctionXYDataSet";
    protected static final boolean D = false;
    protected boolean yLog = false;
    protected boolean xLog = false;
    protected DiscretizedFuncList functions = null;
    protected ArrayList listeners = new ArrayList();
    private double minVal = Double.MIN_VALUE;
    private boolean convertZeroToMin = false;
    private DatasetGroup group = new DatasetGroup();
    private int series;
    private int item;

    public boolean isYLog() {
        return this.yLog;
    }

    public void setYLog(boolean yLog) {
        this.yLog = yLog;
    }

    public boolean isXLog() {
        return this.xLog;
    }

    public void setXLog(boolean xLog) {
        this.xLog = xLog;
    }

    public void setName(String name) {
        this.functions.setName(name);
    }

    public String getName() {
        return this.functions.getName();
    }

    public ListIterator listIterator() {
        return this.functions.listIterator();
    }

    public int getSeriesCount() {
        return this.functions.size();
    }

    public String getSeriesName(int series) {
        if (series < this.functions.size()) {
            String str = this.functions.get(series).getInfo();
            return str;
        }
        return "";
    }

    public int getItemCount(int series) {
        int num = -1;
        if (series < this.functions.size()) {
            DiscretizedFuncAPI f = this.functions.get(series);
            num = f.getNum();
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(f, this.xLog, this.yLog)) {
                --num;
            }
        }
        return num;
    }

    public int getItemCount() {
        return this.getItemCount(0);
    }

    public double getXValue(int series, int item) {
        DiscretizedFuncAPI obj;
        if (series < this.functions.size() && (obj = this.functions.get(series)) != null && obj instanceof DiscretizedFuncAPI) {
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(obj, this.xLog, this.yLog)) {
                ++item;
            }
            double x = obj.getX(item);
            return x;
        }
        return Double.NaN;
    }

    public double getYValue(int series, int item) {
        DiscretizedFuncAPI obj;
        if (series < this.functions.size() && (obj = this.functions.get(series)) != null && obj instanceof DiscretizedFuncAPI) {
            if (DiscretizedFunctionXYDataSet.isAdjustedIndexIfFirstXZero(obj, this.xLog, this.yLog)) {
                ++item;
            }
            double y = obj.getY(item);
            if (this.convertZeroToMin && y <= this.minVal && this.yLog) {
                return this.minVal;
            }
            return y;
        }
        return Double.NaN;
    }

    protected static final boolean isAdjustedIndexIfFirstXZero(DiscretizedFuncAPI func, boolean xLog, boolean yLog) {
        return xLog && (func.getX(0) == 0.0 || func.getX(0) == Double.MIN_VALUE) || yLog && func.getY(0) == 0.0;
    }

    public void clear() {
        this.functions.clear();
    }

    public int size() {
        return this.functions.size();
    }

    public boolean equals(DiscretizedFunctionXYDataSet list) {
        return list.getFunctions().equals(this.functions);
    }

    public void setSeriesAndItem(int series, int item) {
        this.series = series;
        this.item = item;
    }

    public DiscretizedFunctionXYDataSet deepClone() {
        DiscretizedFunctionXYDataSet set = new DiscretizedFunctionXYDataSet();
        DiscretizedFuncList list = this.functions.deepClone();
        set.setFunctions(list);
        return set;
    }

    public void addChangeListener(DatasetChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(DatasetChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public DiscretizedFuncList getFunctions() {
        return this.functions;
    }

    public void setFunctions(DiscretizedFuncList functions) {
        this.functions = functions;
    }

    public void setConvertZeroToMin(boolean zeroToMin) {
        this.convertZeroToMin = zeroToMin;
    }

    public void setConvertZeroToMin(boolean zeroMin, double minVal) {
        this.convertZeroToMin = zeroMin;
        this.minVal = minVal;
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup group) {
        this.group = group;
    }

    public double getStartXValue(int series, int item) {
        double x = this.getXValue(series, item);
        DiscretizedFuncAPI obj = this.functions.get(series);
        if (obj != null && obj instanceof EvenlyDiscretizedFunc) {
            x -= ((EvenlyDiscretizedFunc)obj).getDelta() / 2.0;
        }
        return x;
    }

    public double getEndXValue(int series, int item) {
        double x = this.getXValue(series, item);
        DiscretizedFuncAPI obj = this.functions.get(series);
        if (obj != null && obj instanceof EvenlyDiscretizedFunc) {
            x += ((EvenlyDiscretizedFunc)obj).getDelta() / 2.0;
        }
        return x;
    }

    public double getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public double getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndX(int series, int item) {
        return new Double(this.getEndXValue(series, item));
    }

    public Number getEndY(int series, int item) {
        return new Double(this.getEndYValue(series, item));
    }

    public Number getStartX(int series, int item) {
        return new Double(this.getStartXValue(series, item));
    }

    public Number getStartY(int series, int item) {
        return new Double(this.getStartYValue(series, item));
    }

    public Number getX(int series, int item) {
        return new Double(this.getXValue(series, item));
    }

    public Number getY(int series, int item) {
        return new Double(this.getYValue(series, item));
    }

    public Comparable getSeriesKey(int series) {
        return new String(this.getSeriesName(series));
    }
}

