/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class JFreeLogarithmicAxis
extends NumberAxis {
    private static final long serialVersionUID = 2902912699004103054L;
    public static final double LOG10_VALUE = Math.log(10.0);
    public static final double SMALL_LOG_VALUE = 1.0E-100;
    protected boolean strictValuesFlag = true;
    protected final NumberFormat numberFormatterObj = NumberFormat.getInstance();
    protected boolean expTickLabelsFlag = false;
    protected boolean log10TickLabelsInPowerFlag = true;
    protected boolean minorAxisTickLabelFlag = true;

    public JFreeLogarithmicAxis(String label) {
        super(label);
        this.setupNumberFmtObj();
    }

    public void setStrictValuesFlag(boolean flgVal) {
        this.strictValuesFlag = flgVal;
    }

    public boolean getStrictValuesFlag() {
        return this.strictValuesFlag;
    }

    public void setExpTickLabelsFlag() {
        this.expTickLabelsFlag = true;
        this.log10TickLabelsInPowerFlag = false;
        this.setupNumberFmtObj();
    }

    public boolean getExpTickLabelsFlag() {
        return this.expTickLabelsFlag;
    }

    public void setLog10TickLabelsInPowerFlag() {
        this.log10TickLabelsInPowerFlag = true;
        this.expTickLabelsFlag = false;
    }

    public boolean getLog10TickLabelsInPowerFlag() {
        return this.log10TickLabelsInPowerFlag;
    }

    public void setMinorAxisTickLabelFlag(boolean flag) {
        this.minorAxisTickLabelFlag = flag;
    }

    public boolean getMinorAxisTickLabelFlag() {
        return this.minorAxisTickLabelFlag;
    }

    public void setRange(Range range) {
        super.setRange(range);
        if (this.log10TickLabelsInPowerFlag) {
            double lower = range.getLowerBound();
            if (this.strictValuesFlag && lower <= 0.0) {
                throw new RuntimeException("Values less than or equal to zero not allowed with logarithmic axis");
            }
        }
    }

    protected void setupNumberFmtObj() {
        if (this.numberFormatterObj instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormatterObj).applyPattern(this.expTickLabelsFlag ? "0E0" : "0.###");
        }
    }

    protected double switchedLog10(double val) {
        return StrictMath.log(val) / LOG10_VALUE;
    }

    protected double computeLogFloor(double lower) {
        double logFloor = Math.log(lower) / LOG10_VALUE;
        logFloor = Math.floor(logFloor);
        logFloor = Math.pow(10.0, logFloor);
        return logFloor;
    }

    protected double computeLogCeil(double upper) {
        double logCeil = Math.log(upper) / LOG10_VALUE;
        logCeil = Math.ceil(logCeil);
        logCeil = Math.pow(10.0, logCeil);
        return logCeil;
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double minRange;
            double lower;
            ValueAxisPlot vap = (ValueAxisPlot)plot;
            Range r = vap.getDataRange((ValueAxis)this);
            if (r == null) {
                r = new Range(0.0, 1.0);
                lower = r.getLowerBound();
            } else {
                lower = r.getLowerBound();
                if (this.strictValuesFlag && lower <= 0.0) {
                    throw new RuntimeException("Values less than or equal to zero not allowed with logarithmic axis");
                }
            }
            lower = this.computeLogFloor(lower);
            if (lower > 0.0 && lower < 1.0E-100) {
                lower = r.getLowerBound();
            }
            double upper = r.getUpperBound();
            if ((upper = this.computeLogCeil(upper)) - lower < (minRange = this.getAutoRangeMinimumSize()) && (upper = (upper + lower + minRange) / 2.0) - (lower = (upper + lower - minRange) / 2.0) < minRange) {
                double absUpper = Math.abs(upper);
                double adjVal = absUpper > 1.0E-100 ? absUpper / 100.0 : 0.01;
                upper = (upper + lower + adjVal) / 2.0;
                lower = (upper + lower - adjVal) / 2.0;
            }
            this.setRange(new Range(lower, upper), false, false);
        }
    }

    public double valueToJava2D(double value, Rectangle2D plotArea, RectangleEdge edge) {
        Range range = this.getRange();
        double axisMin = this.switchedLog10(range.getLowerBound());
        double axisMax = this.switchedLog10(range.getUpperBound());
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            min = plotArea.getMinX();
            max = plotArea.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            min = plotArea.getMaxY();
            max = plotArea.getMinY();
        }
        value = this.switchedLog10(value);
        if (this.isInverted()) {
            return max - (value - axisMin) / (axisMax - axisMin) * (max - min);
        }
        return min + (value - axisMin) / (axisMax - axisMin) * (max - min);
    }

    public double java2DtoValue(float java2DValue, Rectangle2D plotArea, RectangleEdge edge) {
        Range range = this.getRange();
        double axisMin = this.switchedLog10(range.getLowerBound());
        double axisMax = this.switchedLog10(range.getUpperBound());
        double plotMin = 0.0;
        double plotMax = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            plotMin = plotArea.getX();
            plotMax = plotArea.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            plotMin = plotArea.getMaxY();
            plotMax = plotArea.getMinY();
        }
        if (this.isInverted()) {
            return Math.pow(10.0, axisMax - ((double)java2DValue - plotMin) / (plotMax - plotMin) * (axisMax - axisMin));
        }
        return Math.pow(10.0, axisMin + ((double)java2DValue - plotMin) / (plotMax - plotMin) * (axisMax - axisMin));
    }

    public List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        double x0 = 0.0;
        ArrayList<Double> ticksXVals = new ArrayList<Double>();
        double lowerBoundVal = this.getRange().getLowerBound();
        if (lowerBoundVal < 1.0E-100) {
            lowerBoundVal = 1.0E-100;
        }
        double upperBoundVal = this.getRange().getUpperBound();
        int iBegCount = (int)StrictMath.floor(this.switchedLog10(lowerBoundVal));
        int iEndCount = (int)StrictMath.ceil(this.switchedLog10(upperBoundVal));
        String tickLabel = "";
        if (iBegCount == iEndCount) {
            --iBegCount;
        }
        if (iEndCount - iBegCount == 1 && upperBoundVal != Double.parseDouble("1e" + iEndCount)) {
            this.setRange(Double.parseDouble("1e" + iBegCount), upperBoundVal);
        }
        for (int i = iBegCount; i <= iEndCount; ++i) {
            int jEndCount = 9;
            if (i == iEndCount) {
                jEndCount = 1;
            }
            for (int j = 0; j < jEndCount; ++j) {
                double tickVal = Double.parseDouble("1e" + i) * (double)(1 + j);
                if (j == 0) {
                    if (this.log10TickLabelsInPowerFlag) {
                        tickLabel = "10E" + i;
                    } else if (this.expTickLabelsFlag) {
                        tickLabel = "1e" + i;
                    }
                } else {
                    tickLabel = this.log10TickLabelsInPowerFlag && this.minorAxisTickLabelFlag ? "" + (j + 1) : "";
                }
                if (tickVal > upperBoundVal) {
                    return ticks;
                }
                if (!(tickVal >= lowerBoundVal - 1.0E-100)) continue;
                TextAnchor anchor = null;
                TextAnchor rotationAnchor = null;
                double angle = 0.0;
                double xx = this.valueToJava2D(tickVal, dataArea, edge);
                Rectangle2D tickLabelBounds = this.getTickLabelFont().getStringBounds(tickLabel, g2.getFontRenderContext());
                float x = 0.0f;
                float y = 0.0f;
                RectangleInsets tickLabelInsets = this.getTickLabelInsets();
                if (this.isVerticalTickLabels()) {
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                    x = (float)(xx + tickLabelBounds.getHeight() / 2.0);
                    if (edge == RectangleEdge.TOP) {
                        angle = 1.5707963267948966;
                        y = (float)(dataArea.getMinY() - tickLabelInsets.getBottom() - tickLabelBounds.getWidth());
                    } else {
                        angle = -1.5707963267948966;
                        y = (float)(dataArea.getMaxY() + tickLabelInsets.getTop() + tickLabelBounds.getWidth());
                    }
                } else {
                    x = (float)(xx - tickLabelBounds.getWidth() / 2.0);
                    if (edge == RectangleEdge.TOP) {
                        anchor = TextAnchor.BOTTOM_CENTER;
                        rotationAnchor = TextAnchor.BOTTOM_CENTER;
                        y = (float)(dataArea.getMinY() - tickLabelInsets.getBottom());
                    } else {
                        anchor = TextAnchor.TOP_CENTER;
                        rotationAnchor = TextAnchor.TOP_CENTER;
                        y = (float)(dataArea.getMaxY() + tickLabelInsets.getTop() + tickLabelBounds.getHeight());
                    }
                }
                if (this.log10TickLabelsInPowerFlag) {
                    if (((double)x < x0 || iEndCount - iBegCount > 3) && j != 0 && this.minorAxisTickLabelFlag) {
                        tickLabel = "";
                    } else {
                        if (j == 0) {
                            int size = ticks.size();
                            --size;
                            while ((double)x <= x0 && size > 0) {
                                Tick tempTick = (Tick)ticks.get(size);
                                if (!tempTick.getText().equals("")) {
                                    this.removePreviousTick(ticks);
                                }
                                x0 = (Double)ticksXVals.get(size) + 3.0;
                                --size;
                            }
                        }
                        x0 = (double)x + tickLabelBounds.getWidth() + 3.0;
                    }
                }
                NumberTick tick = new NumberTick((Number)tickVal, tickLabel, anchor, rotationAnchor, angle);
                ticks.add(tick);
                ticksXVals.add(new Double(x));
            }
        }
        return ticks;
    }

    public List refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        int iEndCount;
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        ArrayList<Double> ticksYVals = new ArrayList<Double>();
        double y0 = 9999.0;
        double lowerBoundVal = this.getRange().getLowerBound();
        if (lowerBoundVal < 1.0E-100) {
            lowerBoundVal = 1.0E-100;
        }
        double upperBoundVal = this.getRange().getUpperBound();
        int iBegCount = (int)StrictMath.floor(this.switchedLog10(lowerBoundVal));
        if (iBegCount == (iEndCount = (int)StrictMath.ceil(this.switchedLog10(upperBoundVal)))) {
            --iBegCount;
        }
        if (iEndCount - iBegCount == 1 && upperBoundVal != Double.parseDouble("1e" + iEndCount)) {
            this.setRange(Double.parseDouble("1e" + iBegCount), upperBoundVal);
        }
        String tickLabel = "";
        for (int i = iBegCount; i <= iEndCount; ++i) {
            int jEndCount = 9;
            if (i == iEndCount) {
                jEndCount = 1;
            }
            for (int j = 0; j < jEndCount; ++j) {
                float x;
                double tickVal = Double.parseDouble("1e" + i) * (double)(1 + j);
                if (j == 0) {
                    if (this.log10TickLabelsInPowerFlag) {
                        tickLabel = "10E" + i;
                    } else if (this.expTickLabelsFlag) {
                        tickLabel = "1e" + i;
                    }
                } else {
                    tickLabel = this.log10TickLabelsInPowerFlag && this.minorAxisTickLabelFlag ? "" + (j + 1) : "";
                }
                if (tickVal > upperBoundVal) {
                    return ticks;
                }
                if (!(tickVal >= lowerBoundVal - 1.0E-100)) continue;
                TextAnchor anchor = null;
                TextAnchor rotationAnchor = null;
                double angle = 0.0;
                double yy = this.valueToJava2D(tickVal, dataArea, edge);
                Rectangle2D tickLabelBounds = this.getTickLabelFont().getStringBounds(tickLabel, g2.getFontRenderContext());
                if (this.isVerticalTickLabels()) {
                    x = (float)(dataArea.getX() - tickLabelBounds.getWidth() - this.getTickLabelInsets().getRight());
                    if (edge == RectangleEdge.LEFT) {
                        anchor = TextAnchor.BOTTOM_CENTER;
                        rotationAnchor = TextAnchor.BOTTOM_CENTER;
                        angle = -1.5707963267948966;
                    } else {
                        anchor = TextAnchor.BOTTOM_CENTER;
                        rotationAnchor = TextAnchor.BOTTOM_CENTER;
                        angle = 1.5707963267948966;
                    }
                } else {
                    x = (float)(dataArea.getMaxX() + this.getTickLabelInsets().getLeft());
                    if (edge == RectangleEdge.LEFT) {
                        anchor = TextAnchor.CENTER_RIGHT;
                        rotationAnchor = TextAnchor.CENTER_RIGHT;
                    } else {
                        anchor = TextAnchor.CENTER_LEFT;
                        rotationAnchor = TextAnchor.CENTER_LEFT;
                    }
                }
                float y = (float)(yy + tickLabelBounds.getHeight() / 3.0);
                if (this.log10TickLabelsInPowerFlag) {
                    if (((double)y > y0 || iEndCount - iBegCount > 3) && j != 0 && this.minorAxisTickLabelFlag) {
                        tickLabel = "";
                    } else {
                        if (j == 0) {
                            int size = ticks.size();
                            --size;
                            while ((double)y >= y0 && size > 0) {
                                Tick tempTick = (Tick)ticks.get(size);
                                if (!tempTick.getText().equals("")) {
                                    this.removePreviousTick(ticks);
                                }
                                y0 = (Double)ticksYVals.get(size) - 3.0;
                                --size;
                            }
                        }
                        y0 = (double)y - tickLabelBounds.getHeight() - 3.0;
                    }
                }
                ticks.add(new NumberTick((Number)tickVal, tickLabel, anchor, rotationAnchor, angle));
                ticksYVals.add(new Double(y));
            }
        }
        return ticks;
    }

    private void removePreviousTick(List ticks) {
        int size = ticks.size();
        for (int i = size - 1; i > 0; --i) {
            Tick tick = (Tick)ticks.get(i);
            if (tick.getText().trim().equalsIgnoreCase("")) continue;
            TextAnchor anchor = tick.getTextAnchor();
            TextAnchor rotationAnchor = tick.getRotationAnchor();
            double angle = tick.getAngle();
            ticks.remove(i);
            ticks.add(new NumberTick((Number)((ValueTick)tick).getValue(), "", anchor, rotationAnchor, angle));
            return;
        }
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        AxisState state = new AxisState(cursor);
        if (!this.log10TickLabelsInPowerFlag) {
            return super.drawTickMarksAndLabels(g2, cursor, plotArea, dataArea, edge);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(g2, cursor, dataArea, edge);
        }
        double ol = this.getTickMarkOutsideLength();
        double il = this.getTickMarkInsideLength();
        List ticks = this.refreshTicks(g2, state, dataArea, edge);
        state.setTicks(ticks);
        g2.setFont(this.getTickLabelFont());
        for (ValueTick tick : ticks) {
            int eIndex = -1;
            if (this.log10TickLabelsInPowerFlag) {
                eIndex = tick.getText().indexOf("E");
            }
            if (eIndex != -1) {
                g2.setFont(new Font(this.getTickLabelFont().getName(), this.getTickLabelFont().getStyle(), this.getTickLabelFont().getSize() + (int)((double)this.getTickLabelFont().getSize() * 0.2)));
            } else {
                g2.setFont(new Font(this.getTickLabelFont().getName(), this.getTickLabelFont().getStyle(), this.getTickLabelFont().getSize()));
            }
            if (this.isTickLabelsVisible()) {
                g2.setPaint(this.getTickLabelPaint());
                float[] anchorPoint = this.calculateAnchorPoint(tick, cursor, dataArea, edge);
                if (this.isVerticalTickLabels()) {
                    TextUtilities.drawRotatedString((String)tick.getText(), (Graphics2D)g2, (float)anchorPoint[0], (float)anchorPoint[1], (TextAnchor)tick.getTextAnchor(), (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
                } else if (eIndex == -1) {
                    TextUtilities.drawRotatedString((String)tick.getText(), (Graphics2D)g2, (float)anchorPoint[0], (float)anchorPoint[1], (TextAnchor)tick.getTextAnchor(), (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
                } else {
                    TextUtilities.drawRotatedString((String)"10", (Graphics2D)g2, (float)(anchorPoint[0] - 7.0f), (float)anchorPoint[1], (TextAnchor)tick.getTextAnchor(), (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
                    g2.setFont(new Font(this.getTickLabelFont().getName(), this.getTickLabelFont().getStyle(), this.getTickLabelFont().getSize() - (int)((double)this.getTickLabelFont().getSize() * 0.2)));
                    TextUtilities.drawRotatedString((String)tick.getText().substring(eIndex + 1), (Graphics2D)g2, (float)(anchorPoint[0] + (float)((int)(0.3 * (double)this.getTickLabelFont().getSize()))), (float)(anchorPoint[1] - 3.0f - (float)((int)(0.4 * (double)this.getTickLabelFont().getSize()))), (TextAnchor)tick.getTextAnchor(), (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
                }
            }
            if (!this.isTickMarksVisible()) continue;
            float xx = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
            Line2D.Double mark = null;
            g2.setStroke(this.getTickMarkStroke());
            g2.setPaint(this.getTickMarkPaint());
            if (edge == RectangleEdge.LEFT) {
                mark = new Line2D.Double(cursor - ol, xx, cursor + il, xx);
            } else if (edge == RectangleEdge.RIGHT) {
                mark = new Line2D.Double(cursor + ol, xx, cursor - il, xx);
            } else if (edge == RectangleEdge.TOP) {
                mark = new Line2D.Double(xx, cursor - ol, xx, cursor + il);
            } else if (edge == RectangleEdge.BOTTOM) {
                mark = new Line2D.Double(xx, cursor + ol, xx, cursor - il);
            }
            g2.draw(mark);
        }
        double used = 0.0;
        if (this.isTickLabelsVisible()) {
            if (edge == RectangleEdge.LEFT) {
                state.cursorLeft(used += this.findMaximumTickLabelWidth(ticks, g2, plotArea, this.isVerticalTickLabels()));
            } else if (edge == RectangleEdge.RIGHT) {
                used = this.findMaximumTickLabelWidth(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorRight(used);
            } else if (edge == RectangleEdge.TOP) {
                used = this.findMaximumTickLabelHeight(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorUp(used);
            } else if (edge == RectangleEdge.BOTTOM) {
                used = this.findMaximumTickLabelHeight(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorDown(used);
            }
        }
        return state;
    }

    protected String makeTickLabel(double val, boolean forceFmtFlag) {
        if (this.expTickLabelsFlag || forceFmtFlag) {
            return this.numberFormatterObj.format(val).toLowerCase();
        }
        return this.getTickUnit().valueToString(val);
    }

    protected String makeTickLabel(double val) {
        return this.makeTickLabel(val, false);
    }
}

