/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.elements;

import java.util.ArrayList;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.mapping.gmt.elements.PSXYElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSXYPolygon
extends PSXYElement {
    private static final long serialVersionUID = 1L;
    private ArrayList<DataPoint2D> points = new ArrayList();

    public PSXYPolygon(DataPoint2D point1, DataPoint2D point2) {
        this.points.add(point1);
        this.points.add(point2);
    }

    public PSXYPolygon(Location loc1, Location loc2) {
        this.points.add(new DataPoint2D(loc1.getLongitude(), loc1.getLatitude()));
        this.points.add(new DataPoint2D(loc2.getLongitude(), loc2.getLatitude()));
    }

    public PSXYPolygon(ArrayList<DataPoint2D> points) {
        this.points = points;
    }

    public PSXYPolygon(LocationList locs) {
        for (Location loc : locs) {
            this.points.add(new DataPoint2D(loc.getLongitude(), loc.getLatitude()));
        }
    }

    public PSXYPolygon() {
    }

    public ArrayList<DataPoint2D> getPoints() {
        return this.points;
    }

    public void addPoint(DataPoint2D point) {
        this.points.add(point);
    }

    public boolean isValid() {
        return this.points != null && this.points.size() >= 2;
    }

    public int size() {
        return this.points.size();
    }
}

