/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.metadata;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.calc.hazardMap.HazardMapJob;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.imr.IntensityMeasureRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataLoader
implements ParameterChangeWarningListener {
    public static Object createClassInstance(String className) throws InvocationTargetException {
        return MetadataLoader.createClassInstance(className, null, null);
    }

    public static Object createClassInstance(String className, ArrayList<Object> args) throws InvocationTargetException {
        return MetadataLoader.createClassInstance(className, null, null);
    }

    public static Object createClassInstance(String className, ArrayList<Object> args, ArrayList<String> argNames) throws InvocationTargetException {
        try {
            Class[] params;
            Object[] paramObjects;
            if (args == null) {
                paramObjects = new Object[]{};
                params = new Class[]{};
            } else {
                paramObjects = new Object[args.size()];
                params = new Class[args.size()];
                for (int i = 0; i < args.size(); ++i) {
                    Object obj;
                    paramObjects[i] = obj = args.get(i);
                    if (argNames == null) {
                        params[i] = obj.getClass();
                        continue;
                    }
                    String name = argNames.get(i);
                    params[i] = Class.forName(name);
                }
            }
            Class<?> newClass = Class.forName(className);
            Constructor<?> con = newClass.getConstructor(params);
            Object obj = con.newInstance(paramObjects);
            return obj;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File("output.xml"));
            IntensityMeasureRelationship imr = IntensityMeasureRelationship.fromXMLMetadata(document.getRootElement().element("IMR"), new MetadataLoader());
            System.out.println("Name: " + imr.getName());
            System.out.println("IMT: " + imr.getIntensityMeasure().getName());
            System.out.println("Period: " + imr.getParameter("SA Period").getValue());
            EqkRupForecast erf = EqkRupForecast.fromXMLMetadata(document.getRootElement().element("ERF"));
            System.out.println("Name: " + erf.getName());
            HazardMapJob job = HazardMapJob.fromXMLMetadata(document.getRootElement().element("GridJob"));
            System.out.println(job.toString());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent event) {
    }
}

