/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DependentParameterAPI;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.ParameterList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependentParameter<E>
extends Parameter<E>
implements DependentParameterAPI<E> {
    protected ArrayList<ParameterAPI<?>> independentParameters = new ArrayList();
    protected String metadataString;

    public DependentParameter() {
    }

    public DependentParameter(String name, ParameterConstraintAPI<E> constraint, String units, E value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public ListIterator<ParameterAPI> getIndependentParametersIterator() {
        return this.getIndependentParameterList().getParametersIterator();
    }

    @Override
    public ParameterAPI getIndependentParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name);
        if (index != -1) {
            ParameterAPI<?> param = this.independentParameters.get(index);
            return param;
        }
        String S = "Parameter: getParameter(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    private int getIndexOf(String paramName) {
        int size = this.independentParameters.size();
        for (int i = 0; i < size; ++i) {
            if (!this.independentParameters.get(i).getName().equals(paramName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getIndependentParametersKey() {
        StringBuffer key = new StringBuffer(this.name);
        Iterator<ParameterAPI<?>> it = this.independentParameters.iterator();
        while (it.hasNext()) {
            Object value = it.next().getValue();
            if (value == null) continue;
            key.append('/');
            key.append(value.toString());
        }
        return key.toString();
    }

    @Override
    public boolean containsIndependentParameter(String paramName) {
        int index = this.getIndexOf(paramName);
        return index != -1;
    }

    @Override
    public void setIndependentParameters(ParameterList list) throws ParameterException, EditableException {
        String S = "Parameter: setIndependentParameters(): ";
        this.checkEditable(S);
        this.independentParameters.clear();
        if (list != null) {
            ListIterator<ParameterAPI> it = list.getParametersIterator();
            while (it.hasNext()) {
                ParameterAPI param = it.next();
                this.independentParameters.add(param);
            }
        }
    }

    @Override
    public String getDependentParamMetadataString() {
        if (this.independentParameters.size() > 0) {
            StringBuffer metadata = new StringBuffer();
            metadata.append(this.getName() + " [ ");
            ListIterator<ParameterAPI> list = this.getIndependentParametersIterator();
            while (list.hasNext()) {
                ParameterAPI tempParam = list.next();
                metadata.append(tempParam.getMetadataString() + " ; ");
            }
            metadata.replace(metadata.length() - 2, metadata.length(), " ]");
            this.metadataString = metadata.toString();
        }
        return this.metadataString;
    }

    public void setDependentParamMetadataString(String dependentParamMedataString) {
        this.metadataString = dependentParamMedataString;
    }

    @Override
    public void addIndependentParameter(ParameterAPI parameter) throws ParameterException, EditableException {
        String S = "Parameter: addIndependentParameter(): ";
        this.checkEditable(S);
        String name = parameter.getName();
        int index = this.getIndexOf(name);
        if (index != -1) {
            throw new ParameterException(S + "A Parameter already exists named " + name);
        }
        this.independentParameters.add(parameter);
    }

    @Override
    public void removeIndependentParameter(String name) throws ParameterException, EditableException {
        String S = "Parameter: removeIndependentParameter(): ";
        this.checkEditable(S);
        int index = this.getIndexOf(name);
        if (index == -1) {
            throw new ParameterException(S + "No Parameter exist named " + name + ", unable to remove");
        }
        this.independentParameters.remove(index);
    }

    public ParameterList getIndependentParameterList() {
        Iterator<ParameterAPI<?>> it = this.independentParameters.iterator();
        ParameterList list = new ParameterList();
        while (it.hasNext()) {
            ParameterAPI<?> param = it.next();
            list.addParameter(param);
        }
        return list;
    }

    @Override
    public int getNumIndependentParameters() {
        return this.independentParameters.size();
    }

    @Override
    public Object clone() {
        return null;
    }

    public abstract boolean setIndividualParamValueFromXML(Element var1);

    @Override
    public final boolean setValueFromXMLMetadata(Element el) {
        boolean success = this.setIndividualParamValueFromXML(el);
        if (!success) {
            return false;
        }
        Element depParamsEl = el.element("IndependentParameters");
        if (depParamsEl == null) {
            return true;
        }
        Iterator it = depParamsEl.elementIterator();
        while (it.hasNext()) {
            Element paramEl = (Element)it.next();
            String name = paramEl.attribute("name").getValue();
            try {
                ParameterAPI param = this.getIndependentParameter(name);
                boolean newSuccess = param.setValueFromXMLMetadata(paramEl);
                System.out.println("Setting indep param " + name + " from XML...success? " + newSuccess);
                if (newSuccess) continue;
                success = false;
            }
            catch (ParameterException e) {
                System.err.println("Parameter '" + this.getName() + "' doesn't have an independent parameter named" + " '" + name + "', and cannot be set from XML");
            }
        }
        return success;
    }
}

