/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DependentParameter;
import org.opensha.commons.param.DependentParameterAPI;
import org.opensha.commons.param.DoubleDiscreteConstraint;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.editor.ConstrainedDoubleDiscreteParameterEditor;
import org.opensha.commons.param.editor.ParameterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleDiscreteParameter
extends DependentParameter<Double>
implements DependentParameterAPI<Double>,
ParameterAPI<Double> {
    protected static final String C = "DoubleDiscreteParameter";
    protected static final boolean D = false;
    private transient ParameterEditor paramEdit = null;

    public DoubleDiscreteParameter(String name) {
        super(name, null, null, null);
    }

    public DoubleDiscreteParameter(String name, String units) {
        super(name, null, units, null);
    }

    public DoubleDiscreteParameter(String name, ArrayList doubles) throws ConstraintException {
        super(name, new DoubleDiscreteConstraint(doubles), null, null);
    }

    public DoubleDiscreteParameter(String name, ArrayList doubles, String units) throws ConstraintException {
        super(name, new DoubleDiscreteConstraint(doubles), units, null);
    }

    public DoubleDiscreteParameter(String name, DoubleDiscreteConstraint constraint) throws ConstraintException {
        super(name, constraint, null, null);
    }

    public DoubleDiscreteParameter(String name, DoubleDiscreteConstraint constraint, String units) throws ConstraintException {
        super(name, constraint, units, null);
    }

    public DoubleDiscreteParameter(String name, Double value) {
        super(name, null, null, value);
    }

    public DoubleDiscreteParameter(String name, String units, Double value) throws ConstraintException {
        super(name, null, units, value);
    }

    public DoubleDiscreteParameter(String name, ArrayList doubles, Double value) throws ConstraintException {
        super(name, new DoubleDiscreteConstraint(doubles), null, value);
    }

    public DoubleDiscreteParameter(String name, ArrayList doubles, String units, Double value) throws ConstraintException {
        super(name, new DoubleDiscreteConstraint(doubles), units, value);
    }

    public DoubleDiscreteParameter(String name, DoubleDiscreteConstraint constraint, Double value) throws ConstraintException {
        super(name, constraint, null, value);
    }

    public DoubleDiscreteParameter(String name, DoubleDiscreteConstraint constraint, String units, Double value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException, EditableException {
        String S = "DoubleDiscreteParameter: setConstraint( ): ";
        this.checkEditable(S);
        if (!(constraint instanceof DoubleDiscreteConstraint)) {
            throw new ParameterException(S + "This parameter only accepts DoubleDiscreteConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    @Override
    public String getType() {
        String type = C;
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public ArrayList getAllowedDoubles() {
        return ((DoubleDiscreteConstraint)this.constraint).getAllowedDoubles();
    }

    @Override
    public int compareTo(Object obj) throws ClassCastException {
        String S = "DoubleDiscreteParameter:compareTo(): ";
        if (!(obj instanceof DoubleParameter) && !(obj instanceof DoubleDiscreteParameter)) {
            throw new ClassCastException(S + "Object not a DoubleParameter, or DoubleDiscreteParameter, unable to compare");
        }
        boolean result = false;
        Double n1 = (Double)this.getValue();
        Double n2 = null;
        if (obj instanceof DoubleParameter) {
            DoubleParameter param = (DoubleParameter)obj;
            n2 = (Double)param.getValue();
        } else if (obj instanceof DoubleDiscreteParameter) {
            DoubleDiscreteParameter param = (DoubleDiscreteParameter)obj;
            n2 = (Double)param.getValue();
        }
        return n1.compareTo(n2);
    }

    @Override
    public boolean equals(Object obj) throws ClassCastException {
        String S = "DoubleDiscreteParameter:equals(): ";
        if (!(obj instanceof DoubleParameter) && !(obj instanceof DoubleDiscreteParameter)) {
            throw new ClassCastException(S + "Object not a DoubleParameter, or DoubleDiscreteParameter, unable to compare");
        }
        String otherName = ((ParameterAPI)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    @Override
    public Object clone() {
        DoubleDiscreteConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (DoubleDiscreteConstraint)this.constraint.clone();
        }
        DoubleDiscreteParameter param = null;
        param = this.value == null ? new DoubleDiscreteParameter(this.name, c1, this.units) : new DoubleDiscreteParameter(this.name, c1, this.units, new Double(((Double)this.value).toString()));
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        try {
            Double val = Double.parseDouble(el.attributeValue("value"));
            this.setValue(val);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public ParameterEditor getEditor() {
        if (this.paramEdit == null && this.constraint != null) {
            try {
                this.paramEdit = new ConstrainedDoubleDiscreteParameterEditor(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.paramEdit;
    }
}

