/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DependentParameter;
import org.opensha.commons.param.DependentParameterAPI;
import org.opensha.commons.param.IntegerConstraint;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.editor.ConstrainedIntegerParameterEditor;
import org.opensha.commons.param.editor.IntegerParameterEditor;
import org.opensha.commons.param.editor.ParameterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerParameter
extends DependentParameter<Integer>
implements DependentParameterAPI<Integer>,
ParameterAPI<Integer> {
    protected static final String C = "IntegerParameter";
    protected static final boolean D = false;
    private transient ParameterEditor paramEdit = null;

    public IntegerParameter(String name) {
        super(name, null, null, null);
    }

    public IntegerParameter(String name, String units) throws ConstraintException {
        this(name, null, units, null);
    }

    public IntegerParameter(String name, int min, int max) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, int min, int max, String units) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, Integer min, Integer max) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, Integer min, Integer max, String units) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, IntegerConstraint constraint) throws ConstraintException {
        super(name, constraint, null, null);
    }

    public IntegerParameter(String name, IntegerConstraint constraint, String units) throws ConstraintException {
        super(name, constraint, units, null);
    }

    public IntegerParameter(String name, Integer value) {
        super(name, null, null, value);
    }

    public IntegerParameter(String name, String units, Integer value) throws ConstraintException {
        super(name, null, units, value);
    }

    public IntegerParameter(String name, int min, int max, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, value);
    }

    public IntegerParameter(String name, Integer min, Integer max, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, value);
    }

    public IntegerParameter(String name, IntegerConstraint constraint, Integer value) throws ConstraintException {
        super(name, constraint, null, value);
    }

    public IntegerParameter(String name, int min, int max, String units, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), units, value);
    }

    public IntegerParameter(String name, Integer min, Integer max, String units, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), units, value);
    }

    public IntegerParameter(String name, IntegerConstraint constraint, String units, Integer value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException {
        String S = "IntegerParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof IntegerConstraint)) {
            throw new ParameterException(S + "This parameter only accepts IntegerConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    @Override
    public boolean isAllowed(int i) {
        return this.isAllowed(new Integer(i));
    }

    public Integer getMin() throws Exception {
        if (this.constraint != null) {
            return ((IntegerConstraint)this.constraint).getMin();
        }
        return null;
    }

    public Integer getMax() {
        if (this.constraint != null) {
            return ((IntegerConstraint)this.constraint).getMax();
        }
        return null;
    }

    @Override
    public String getType() {
        String type = C;
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    @Override
    public int compareTo(Object obj) throws ClassCastException {
        String S = "IntegerParameter:compareTo(): ";
        if (!(obj instanceof IntegerParameter)) {
            throw new ClassCastException(S + "Object not a IntegerParameter, unable to compare");
        }
        IntegerParameter param = (IntegerParameter)obj;
        boolean result = false;
        Integer n1 = (Integer)this.getValue();
        Integer n2 = (Integer)param.getValue();
        return n1.compareTo(n2);
    }

    @Override
    public boolean equals(Object obj) throws ClassCastException {
        String S = "IntegerParameter:equals(): ";
        if (!(obj instanceof IntegerParameter)) {
            throw new ClassCastException(S + "Object not a IntegerParameter, unable to compare");
        }
        String otherName = ((IntegerParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    @Override
    public Object clone() {
        IntegerConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (IntegerConstraint)this.constraint.clone();
        }
        IntegerParameter param = null;
        param = this.value == null ? new IntegerParameter(this.name, c1, this.units) : new IntegerParameter(this.name, c1, this.units, new Integer(((Integer)this.value).toString()));
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        try {
            int val = Integer.parseInt(el.attributeValue("value"));
            this.setValue(val);
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ParameterEditor getEditor() {
        if (this.paramEdit == null) {
            try {
                this.paramEdit = this.constraint == null ? new IntegerParameterEditor(this) : new ConstrainedIntegerParameterEditor(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.paramEdit;
    }
}

