/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DiscreteParameterConstraintAPI;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraintAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterList
implements Serializable,
Iterable<ParameterAPI<?>> {
    private static final long serialVersionUID = -3799009507357699361L;
    protected static final String C = "ParameterList";
    protected static final boolean D = false;
    protected ArrayList<ParameterAPI<?>> params = new ArrayList();
    protected Hashtable<String, String> constraintNameMap = new Hashtable();

    public void addParameterList(ParameterList list2) throws ParameterException {
        ListIterator<ParameterAPI> it = list2.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI param = it.next();
            if (this.containsParameter(param)) continue;
            this.addParameter(param);
        }
    }

    public void addParameter(ParameterAPI param) throws ParameterException {
        String S = "ParameterList: addParameter(): ";
        String name = param.getName();
        String constraintName = param.getConstraintName();
        if (this.getIndexOf(name) != -1) {
            throw new ParameterException(S + "A Parameter already exists named " + name);
        }
        this.params.add(param);
        if (constraintName == null || constraintName.equals("") || constraintName.equals(name)) {
            return;
        }
        if (this.constraintNameMap.containsKey(constraintName)) {
            this.params.remove(name);
            throw new ParameterException(S + "A Parameter already exists with this constraint named " + constraintName);
        }
        this.constraintNameMap.put(constraintName, name);
    }

    public String getParameterName(String name) {
        if (this.constraintNameMap.containsKey(name)) {
            return this.constraintNameMap.get(name);
        }
        return name;
    }

    public ParameterAPI getParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            ParameterAPI<?> param = this.params.get(index);
            return param;
        }
        String S = "ParameterList: getParameter(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public Object getValue(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            ParameterAPI<?> param = this.params.get(index);
            Object obj = param.getValue();
            return obj;
        }
        String S = "ParameterList: getValue(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public void setValue(String name, Object value) throws ParameterException, ConstraintException {
        String S = "ParameterList: setValue(): ";
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index == -1) {
            throw new ParameterException(S + "No parameter exists named " + name);
        }
        ParameterAPI<?> param = this.params.get(index);
        param.setValue(value);
    }

    public String getType(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            ParameterAPI<?> param = this.params.get(index);
            String str = param.getType();
            return str;
        }
        String S = "ParameterList: getType(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public boolean containsParameter(ParameterAPI param) {
        String name = param.getName();
        int index = this.getIndexOf(name);
        return index != -1;
    }

    public boolean containsParameter(String paramName) {
        int index = this.getIndexOf(paramName);
        return index != -1;
    }

    public void removeParameter(ParameterAPI param) throws ParameterException {
        String name = param.getName();
        this.removeParameter(name);
    }

    public void removeParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name);
        if (index == -1) {
            String S = "ParameterList: removeParameter(): ";
            throw new ParameterException(S + "No Parameter exist named " + name + ", unable to remove");
        }
        this.params.remove(index);
    }

    public void updateParameter(ParameterAPI param) throws ParameterException {
        String name = param.getName();
        this.removeParameter(name);
        this.addParameter(param);
    }

    public ListIterator<ParameterAPI> getParametersIterator() {
        ArrayList v = new ArrayList();
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            ParameterAPI<?> obj = this.params.get(i);
            v.add(obj);
        }
        return v.listIterator();
    }

    public void replaceParameter(String parameterName, ParameterAPI param) {
        int index = this.getIndexOf(parameterName = this.getParameterName(parameterName));
        if (index != -1) {
            this.removeParameter(parameterName);
            this.addParameter(param);
        }
    }

    public int compareTo(Object obj) {
        ParameterAPI param1;
        ParameterAPI param2;
        int result = 0;
        if (!(obj instanceof ParameterList)) {
            throw new ClassCastException("ParameterListObject not a ParameterList, unable to compare");
        }
        ParameterList paramList = (ParameterList)obj;
        ListIterator<ParameterAPI> it = paramList.getParametersIterator();
        if (this.size() != paramList.size()) {
            return -1;
        }
        while (it.hasNext() && (result = (param2 = this.getParameter((param1 = it.next()).getName())).compareTo(param1)) == 0) {
        }
        return result;
    }

    public ListIterator<String> getParameterNamesIterator() {
        ArrayList<String> v = new ArrayList<String>();
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            ParameterAPI<?> obj = this.params.get(i);
            v.add(obj.getName());
        }
        return v.listIterator();
    }

    public void clear() {
        this.params.clear();
    }

    public int size() {
        return this.params.size();
    }

    public boolean equals(ParameterList list) {
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator<ParameterAPI> it = this.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI param1 = it.next();
            if (!list.containsParameter(param1.getName())) {
                return false;
            }
            ParameterAPI param2 = list.getParameter(param1.getName());
            if (!((Object)param1).equals(param2)) {
                return false;
            }
            try {
                if (param1.compareTo(param2) == 0) continue;
                return false;
            }
            catch (ClassCastException ee) {
                return false;
            }
        }
        return true;
    }

    public boolean equalNames(ParameterList list) {
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator<ParameterAPI> it = this.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI param1 = it.next();
            if (list.containsParameter(param1.getName())) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        String S = "ParameterList: clone(): ";
        ParameterList list = new ParameterList();
        if (this.size() < 1) {
            return list;
        }
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            ParameterAPI<?> param = this.params.get(i);
            list.addParameter((ParameterAPI)param.clone());
        }
        return list;
    }

    public String toString() {
        String S = "ParameterList: toString():";
        StringBuffer b = new StringBuffer();
        boolean first = true;
        ArrayList<String> v = new ArrayList<String>();
        int vectorSize = this.params.size();
        for (int i = 0; i < vectorSize; ++i) {
            ParameterAPI<?> param = this.params.get(i);
            v.add(param.getName());
        }
        for (String key : v) {
            int size;
            int index = this.getIndexOf(key);
            ParameterAPI<?> param = this.params.get(index);
            ParameterConstraintAPI constraint = param.getConstraint();
            boolean ok = true;
            if (constraint instanceof DiscreteParameterConstraintAPI && (size = ((DiscreteParameterConstraintAPI)constraint).size()) < 2) {
                ok = false;
            }
            if (!ok) continue;
            String val = "N/A";
            Object obj = param.getValue();
            if (obj != null) {
                val = obj.toString();
            }
            if (first) {
                first = false;
                b.append(key + " = " + val);
                continue;
            }
            b.append(", " + key + " = " + val);
        }
        return b.toString();
    }

    public String getParameterListMetadataString() {
        return this.getParameterListMetadataString("; ");
    }

    public String getParameterListMetadataString(String delimiter) {
        int size = this.params.size();
        StringBuffer metaData = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < size; ++i) {
            ParameterAPI<?> tempParam = this.params.get(i);
            if (first) {
                metaData.append(tempParam.getMetadataString());
                first = false;
                continue;
            }
            metaData.append(delimiter + tempParam.getMetadataString());
        }
        return metaData.toString();
    }

    private int getIndexOf(String key) {
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            ParameterAPI<?> param = this.params.get(i);
            if (!key.equalsIgnoreCase(param.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<ParameterAPI<?>> iterator() {
        return this.params.iterator();
    }

    public static boolean setParamsInListFromXML(ParameterList paramList, Element paramListEl) {
        boolean failure = false;
        for (ParameterAPI<?> param : paramList) {
            Iterator it = paramListEl.elementIterator();
            boolean matched = false;
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (!param.getName().equals(el.attribute("name").getValue())) continue;
                matched = true;
                if (param.setValueFromXMLMetadata(el)) continue;
                System.err.println("Parameter could not be set from XML!");
                System.err.println("It is possible that the parameter type doesn't yet support loading from XML");
                failure = true;
            }
            if (matched) continue;
            System.err.println("Parameter '" + param.getName() + "' from XML can not be set because it can't be" + " found in the given ParameterList!");
            failure = true;
        }
        return !failure;
    }
}

