/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JComboBox;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.StringParameter;
import org.opensha.commons.param.editor.ParameterEditor;

public class ConstrainedStringParameterEditor
extends ParameterEditor
implements ItemListener {
    protected static final String C = "ConstrainedStringParameterEditor";
    protected static final boolean D = false;

    public ConstrainedStringParameterEditor() {
        String S = "ConstrainedStringParameterEditor: Constructor(): ";
    }

    public ConstrainedStringParameterEditor(ParameterAPI model) throws ConstraintException {
        super(model);
        String S = "ConstrainedStringParameterEditor: Constructor(model): ";
        this.setParameter(model);
    }

    public void setParameter(ParameterAPI model) {
        String S = "ConstrainedStringParameterEditor: setParameter(): ";
        this.verifyModel(model);
        this.model = model;
        String name = model.getName();
        Object value = model.getValue();
        this.removeWidget();
        this.addWidget();
        this.setWidgetObject(name, value);
    }

    protected void verifyModel(ParameterAPI model) throws ConstraintException {
        String S = "ConstrainedStringParameterEditor: Constructor(model): ";
        if (model == null) {
            throw new NullPointerException(S + "Input Parameter model cannot be null");
        }
        if (!(model instanceof StringParameter)) {
            throw new ConstraintException(S + "Input model parameter must be a StringParameter.");
        }
        ParameterConstraintAPI constraint = model.getConstraint();
        if (!(constraint instanceof StringConstraint)) {
            throw new ConstraintException(S + "Input model constraints must be a StringConstraint.");
        }
        int numConstriants = ((StringConstraint)constraint).size();
        if (numConstriants < 1) {
            throw new ConstraintException(S + "There are no constraints present, unable to build editor selection list.");
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    protected void setWidgetObject(String name, Object obj) {
        String S = "ConstrainedStringParameterEditor: setWidgetObject(): ";
        super.setWidgetObject(name, obj);
        if (obj != null && this.valueEditor != null && this.valueEditor instanceof JComboBox) {
            ((JComboBox)this.valueEditor).setSelectedItem(obj.toString());
        }
    }

    protected void addWidget() {
        String S = "ConstrainedStringParameterEditor: addWidget(): ";
        if (this.model != null) {
            StringConstraint con = (StringConstraint)((StringParameter)this.model).getConstraint();
            ListIterator it = con.listIterator();
            Vector<String> strs = new Vector<String>();
            while (it.hasNext()) {
                String str = it.next().toString();
                if (strs.contains(str)) continue;
                strs.add(str);
            }
            if (strs.size() > 1) {
                JComboBox jcb = new JComboBox(strs);
                jcb.setMaximumRowCount(32);
                this.valueEditor = jcb;
                this.valueEditor.setPreferredSize(JCOMBO_DIM);
                this.valueEditor.setMinimumSize(JCOMBO_DIM);
                this.valueEditor.setFont(JCOMBO_FONT);
                ((JComboBox)this.valueEditor).addItemListener(this);
                this.valueEditor.addFocusListener(this);
                this.widgetPanel.add((Component)this.valueEditor, COMBO_WIDGET_GBC);
                this.widgetPanel.setBackground(null);
                this.widgetPanel.validate();
                this.widgetPanel.repaint();
            } else {
                this.valueEditor = ConstrainedStringParameterEditor.makeConstantEditor(strs.get(0).toString());
                this.widgetPanel.setBackground(STRING_BACK_COLOR);
                this.widgetPanel.add((Component)this.valueEditor, WIDGET_GBC);
            }
        }
    }

    public void refreshParamEditor() {
        Object obj;
        if (this.valueEditor instanceof JComboBox && (obj = this.model.getValue()) != null) {
            ((JComboBox)this.valueEditor).setSelectedItem(obj.toString());
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String S = "ConstrainedStringParameterEditor: itemStateChanged(): ";
        String value = ((JComboBox)this.valueEditor).getSelectedItem().toString();
        this.setValue(value);
    }

    public void focusGained(FocusEvent e) {
        super.focusGained(e);
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
    }
}

