/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.io.EOFException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;

public class DataUtil {
    private String textToPrint;
    private static final int margin = 60;

    public static void save(String fileName, String dataToSave) {
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write(dataToSave);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void print(PrintJob pjob, Graphics pg, String textToPrint) {
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics context not PrintGraphics");
        }
        StringReader sr = new StringReader(textToPrint);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height - 60;
        Font helv = new Font("Monaco", 0, 12);
        pg.setFont(helv);
        FontMetrics fm = pg.getFontMetrics(helv);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = 60;
        try {
            String nextLine;
            do {
                if ((nextLine = lnr.readLine()) == null) continue;
                if (curHeight + fontHeight > pageHeight) {
                    if (linesForThisPage == 0) break;
                    ++pageNum;
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(helv);
                    }
                    curHeight = 0;
                }
                curHeight += fontHeight;
                if (pg == null) continue;
                pg.drawString(nextLine, 60, curHeight - fontDescent);
                ++linesForThisPage;
                ++linesForThisJob;
            } while (nextLine != null);
        }
        catch (EOFException eof) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

