/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class RunScript {
    public static int runScript(String[] command, String outFile, String errFile) {
        int i = 0;
        try {
            System.out.println("Command to execute: " + command[2]);
            Process p = Runtime.getRuntime().exec(command);
            i = RunScript.displayProcessStatus(p, outFile, errFile);
        }
        catch (Exception e) {
            System.out.println("Exception in Executing Shell Script:" + e);
            e.printStackTrace();
        }
        return i;
    }

    public static int runScript(String[] command) {
        return RunScript.runScript(command, "", "");
    }

    public static void displayOutput(InputStream is) throws Exception {
        try {
            String s;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((s = br.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in RunCoreCode:displayOutput:" + e);
            e.printStackTrace();
        }
    }

    public static int displayProcessStatus(Process pr, String outFile, String errFile) throws IOException {
        InputStream is = pr.getErrorStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        InputStream es = pr.getInputStream();
        InputStreamReader esr = new InputStreamReader(es);
        BufferedReader ebr = new BufferedReader(esr);
        String processStr = null;
        String errStr = null;
        FileWriter outWrite = null;
        if (outFile != null && outFile.length() > 0) {
            outWrite = new FileWriter(outFile);
        }
        FileWriter errWrite = null;
        if (errFile != null && errFile.length() > 0) {
            errWrite = new FileWriter(errFile);
        }
        try {
            while ((errStr = ebr.readLine()) != null || (processStr = br.readLine()) != null) {
                if (processStr != null) {
                    System.out.println(processStr);
                    if (outWrite != null) {
                        outWrite.write(processStr + "\n");
                    }
                }
                if (errStr != null) {
                    System.out.println(errStr);
                    if (errWrite != null) {
                        errWrite.write(errStr + "\n");
                    }
                }
                if (processStr != null || errStr != null) continue;
            }
            if (outWrite != null) {
                outWrite.close();
            }
            if (errWrite != null) {
                errWrite.close();
            }
            int exit = pr.waitFor();
            return exit;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (outWrite != null) {
                outWrite.close();
            }
            if (errWrite != null) {
                errWrite.close();
            }
            return -1;
        }
    }
}

