/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DeformationModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ServerDB_Access;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;

public class DeformationModelPrefDataDB_DAO {
    private static final String TABLE_NAME = "Pref_Deformation_Model_Data";
    private static final String DEFORMATION_MODEL_ID = "Deformation_Model_Id";
    private static final String SECTION_ID = "Section_Id";
    private static final String PREF_LONG_TERM_SLIP_RATE = "Pref_Long_Term_Slip_Rate";
    private static final String SLIP_STD_DEV = "Slip_Std_Dev";
    private static final String PREF_ASEISMIC_SLIP = "Pref_Aseismic_Slip";
    private static HashMap slipRateMap;
    private static HashMap aseismicSlipMap;
    private static HashMap stdDevMap;
    private static int selectedDefModelId;
    private DB_AccessAPI dbAccess;
    private PrefFaultSectionDataDB_DAO prefFaultSectionDAO;
    private DeformationModelDB_DAO deformationModelDB_DAO;
    private static ArrayList faultSectionIdList;

    public DeformationModelPrefDataDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(dbAccess);
        this.deformationModelDB_DAO = new DeformationModelDB_DAO(dbAccess);
    }

    public void rePopulatePrefDataTable() {
        this.removeAll();
        DeformationModelSummaryDB_DAO defModelSumDAO = new DeformationModelSummaryDB_DAO(this.dbAccess);
        ArrayList deformationModelList = defModelSumDAO.getAllDeformationModels();
        for (int i = 0; i < deformationModelList.size(); ++i) {
            DeformationModelSummary defModelSummary = (DeformationModelSummary)deformationModelList.get(i);
            int deformationModelId = defModelSummary.getDeformationModelId();
            ArrayList faultSectionIdList = this.deformationModelDB_DAO.getFaultSectionIdsForDeformationModel(deformationModelId);
            for (int j = 0; j < faultSectionIdList.size(); ++j) {
                int faultSectionId = (Integer)faultSectionIdList.get(j);
                double aseismicSlipFactor = FaultSectionData.getPrefForEstimate(this.deformationModelDB_DAO.getAseismicSlipEstimate(deformationModelId, faultSectionId));
                EstimateInstances estimateInstance = this.deformationModelDB_DAO.getSlipRateEstimate(deformationModelId, faultSectionId);
                double slipRate = FaultSectionData.getPrefForEstimate(estimateInstance);
                double slipRateStdDev = Double.NaN;
                if (!Double.isNaN(slipRate) && estimateInstance.getEstimate() instanceof NormalEstimate) {
                    slipRateStdDev = ((NormalEstimate)estimateInstance.getEstimate()).getStdDev();
                }
                this.addToTable(deformationModelId, faultSectionId, aseismicSlipFactor, slipRate, slipRateStdDev);
            }
        }
    }

    private void addToTable(int deformationModelId, int faultSectionId, double aseismicSlipFactor, double slipRate, double slipRateStdDev) {
        String columnNames = "";
        String colVals = "";
        if (!Double.isNaN(slipRate)) {
            columnNames = columnNames + "Pref_Long_Term_Slip_Rate,";
            colVals = colVals + slipRate + ",";
        }
        if (!Double.isNaN(slipRateStdDev)) {
            columnNames = columnNames + "Slip_Std_Dev,";
            colVals = colVals + slipRateStdDev + ",";
        }
        String sql = "insert into Pref_Deformation_Model_Data (Deformation_Model_Id,Section_Id," + columnNames + PREF_ASEISMIC_SLIP + ") values (" + deformationModelId + "," + faultSectionId + "," + colVals + aseismicSlipFactor + ")";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public ArrayList getFaultSectionIdsForDeformationModel(int deformationModelId) {
        if (selectedDefModelId != deformationModelId) {
            this.cache(deformationModelId);
        }
        return faultSectionIdList;
    }

    public FaultSectionPrefData getFaultSectionPrefData(int deformationModelId, int faultSectionId) {
        FaultSectionPrefData faultSectionPrefData = this.prefFaultSectionDAO.getFaultSectionPrefData(faultSectionId);
        faultSectionPrefData.setAseismicSlipFactor(this.getAseismicSlipFactor(deformationModelId, faultSectionId));
        faultSectionPrefData.setAveLongTermSlipRate(this.getSlipRate(deformationModelId, faultSectionId));
        faultSectionPrefData.setSlipRateStdDev(this.getSlipStdDev(deformationModelId, faultSectionId));
        return faultSectionPrefData;
    }

    public double getSlipRate(int deformationModelId, int faultSectionId) {
        Double slipRate;
        if (selectedDefModelId != deformationModelId) {
            this.cache(deformationModelId);
        }
        if ((slipRate = (Double)slipRateMap.get(new Integer(faultSectionId))) == null) {
            return Double.NaN;
        }
        return slipRate;
    }

    public double getSlipStdDev(int deformationModelId, int faultSectionId) {
        Double stdDev;
        if (selectedDefModelId != deformationModelId) {
            this.cache(deformationModelId);
        }
        if ((stdDev = (Double)stdDevMap.get(new Integer(faultSectionId))) == null) {
            return Double.NaN;
        }
        return stdDev;
    }

    public double getAseismicSlipFactor(int deformationModelId, int faultSectionId) {
        Double aseismicSlip;
        if (selectedDefModelId != deformationModelId) {
            this.cache(deformationModelId);
        }
        if ((aseismicSlip = (Double)aseismicSlipMap.get(new Integer(faultSectionId))) == null) {
            return Double.NaN;
        }
        return aseismicSlip;
    }

    private void cache(int defModelId) {
        slipRateMap = new HashMap();
        aseismicSlipMap = new HashMap();
        stdDevMap = new HashMap();
        faultSectionIdList = new ArrayList();
        String sql = "select Section_Id, (Pref_Aseismic_Slip+0) Pref_Aseismic_Slip, (Slip_Std_Dev+0) Slip_Std_Dev, (Pref_Long_Term_Slip_Rate+0) Pref_Long_Term_Slip_Rate from Pref_Deformation_Model_Data where Deformation_Model_Id=" + defModelId;
        double aseismicSlipFactor = Double.NaN;
        double slip = Double.NaN;
        double stdDev = Double.NaN;
        try {
            CachedRowSetImpl rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                aseismicSlipFactor = rs.getFloat(PREF_ASEISMIC_SLIP);
                if (rs.wasNull()) {
                    aseismicSlipFactor = Double.NaN;
                }
                slip = rs.getFloat(PREF_LONG_TERM_SLIP_RATE);
                if (rs.wasNull()) {
                    slip = Double.NaN;
                }
                stdDev = rs.getFloat(SLIP_STD_DEV);
                if (rs.wasNull()) {
                    stdDev = Double.NaN;
                }
                Integer sectionId = new Integer(rs.getInt(SECTION_ID));
                faultSectionIdList.add(sectionId);
                slipRateMap.put(sectionId, new Double(slip));
                aseismicSlipMap.put(sectionId, new Double(aseismicSlipFactor));
                stdDevMap.put(sectionId, new Double(stdDev));
            }
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        selectedDefModelId = defModelId;
    }

    private void removeAll() {
        String sql = "delete from Pref_Deformation_Model_Data";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        ServerDB_Access dbAccessAPI = new ServerDB_Access();
        SessionInfo.setUserName(args[0]);
        SessionInfo.setPassword(args[1]);
        SessionInfo.setContributorInfo();
        DeformationModelPrefDataDB_DAO defModelPrefDataDB_DAO = new DeformationModelPrefDataDB_DAO(dbAccessAPI);
        defModelPrefDataDB_DAO.rePopulatePrefDataTable();
        System.exit(0);
    }

    static {
        selectedDefModelId = -1;
    }
}

