/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.spatial.geometry.JGeometry;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.EstimateInstancesDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SectionSourceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.sha.faultSurface.FaultTrace;

public class FaultSectionVer2_DB_DAO {
    private static final String TABLE_NAME = "Fault_Section";
    private static final String SEQUENCE_NAME = "Fault_Section_Sequence";
    public static final String SECTION_ID = "Section_Id";
    public static final String AVE_LONG_TERM_SLIP_RATE_EST = "Ave_Long_Term_Slip_Rate_Est";
    public static final String AVE_DIP_EST = "Ave_Dip_Est";
    public static final String AVE_RAKE_EST = "Ave_Rake_Est";
    public static final String AVE_UPPER_DEPTH_EST = "Ave_Upper_Depth_Est";
    public static final String AVE_LOWER_DEPTH_EST = "Ave_Lower_Depth_Est";
    public static final String CONTRIBUTOR_ID = "Contributor_Id";
    public static final String SECTION_NAME = "Name";
    public static final String SHORT_NAME = "Short_Name";
    public static final String ENTRY_DATE = "Entry_Date";
    public static final String COMMENTS = "Comments";
    public static final String FAULT_TRACE = "Fault_Section_Trace";
    public static final String ASEISMIC_SLIP_FACTOR_EST = "Average_Aseismic_Slip_Est";
    public static final String DIP_DIRECTION = "Dip_Direction";
    public static final String SECTION_SOURCE_ID = "Section_Source_Id";
    public static final String QFAULT_ID = "QFault_Id";
    private DB_AccessAPI dbAccess;
    private EstimateInstancesDB_DAO estimateInstancesDAO;
    private SectionSourceDB_DAO sectionSourceDAO;
    private static final int SRID = 8307;

    public FaultSectionVer2_DB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.estimateInstancesDAO = new EstimateInstancesDB_DAO(dbAccess);
        this.sectionSourceDAO = new SectionSourceDB_DAO(dbAccess);
    }

    public int addFaultSection(FaultSectionData faultSection) {
        String shortName;
        String qfaultId;
        float dipDirection;
        EstimateInstances aveRakeEst;
        String systemDate;
        int faultSectionId = faultSection.getSectionId();
        try {
            if (faultSectionId <= 0) {
                faultSectionId = this.dbAccess.getNextSequenceNumber(SEQUENCE_NAME);
            }
            systemDate = this.dbAccess.getSystemDate();
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        JGeometry faultSectionTraceGeom = FaultSectionVer2_DB_DAO.getGeomtery(faultSection.getFaultTrace());
        int aveDipEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveDipEst());
        int aveUpperDepthEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveUpperDepthEst());
        int aveLowerDepthEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveLowerDepthEst());
        int aseismicSlipFactorEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAseismicSlipFactorEst());
        int sectionSourceId = this.sectionSourceDAO.getSectionSource(faultSection.getSource()).getSourceId();
        String columnNames = "";
        String columnVals = "";
        EstimateInstances slipRateEst = faultSection.getAveLongTermSlipRateEst();
        if (slipRateEst != null) {
            int aveLongTermSlipRateEstId = this.estimateInstancesDAO.addEstimateInstance(slipRateEst);
            columnNames = columnNames + "Ave_Long_Term_Slip_Rate_Est,";
            columnVals = columnVals + aveLongTermSlipRateEstId + ",";
        }
        if ((aveRakeEst = faultSection.getAveRakeEst()) != null) {
            int aveRakeEstId = this.estimateInstancesDAO.addEstimateInstance(aveRakeEst);
            columnNames = columnNames + "Ave_Rake_Est,";
            columnVals = columnVals + aveRakeEstId + ",";
        }
        if (!Float.isNaN(dipDirection = faultSection.getDipDirection())) {
            columnNames = columnNames + "Dip_Direction,";
            columnVals = columnVals + dipDirection + ",";
        }
        if ((qfaultId = faultSection.getQFaultId()) != null) {
            columnNames = columnNames + "QFault_Id,";
            columnVals = columnVals + "'" + qfaultId + "',";
        }
        if ((shortName = faultSection.getShortName()) != null) {
            columnNames = columnNames + "Short_Name,";
            columnVals = columnVals + "'" + shortName + "',";
        }
        ArrayList<JGeometry> geomteryObjectList = new ArrayList<JGeometry>();
        geomteryObjectList.add(faultSectionTraceGeom);
        String sql = "insert into Fault_Section(Section_Id," + columnNames + AVE_DIP_EST + "," + AVE_UPPER_DEPTH_EST + "," + AVE_LOWER_DEPTH_EST + "," + CONTRIBUTOR_ID + "," + SECTION_NAME + "," + ENTRY_DATE + "," + COMMENTS + "," + FAULT_TRACE + "," + ASEISMIC_SLIP_FACTOR_EST + "," + SECTION_SOURCE_ID + ") values (" + faultSectionId + "," + columnVals + aveDipEst + "," + aveUpperDepthEst + "," + aveLowerDepthEst + "," + SessionInfo.getContributor().getId() + ",'" + faultSection.getSectionName() + "','" + systemDate + "','" + faultSection.getComments() + "',?," + aseismicSlipFactorEst + "," + sectionSourceId + ")";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql, geomteryObjectList);
            return faultSectionId;
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public void update(FaultSectionData faultSection) {
        String systemDate;
        try {
            systemDate = this.dbAccess.getSystemDate();
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        JGeometry faultSectionTraceGeom = FaultSectionVer2_DB_DAO.getGeomtery(faultSection.getFaultTrace());
        int aveDipEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveDipEst());
        int aveUpperDepthEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveUpperDepthEst());
        int aveLowerDepthEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAveLowerDepthEst());
        int aseismicSlipFactorEst = this.estimateInstancesDAO.addEstimateInstance(faultSection.getAseismicSlipFactorEst());
        int sectionSourceId = this.sectionSourceDAO.getSectionSource(faultSection.getSource()).getSourceId();
        String columnNames = "";
        EstimateInstances slipRateEst = faultSection.getAveLongTermSlipRateEst();
        if (slipRateEst != null) {
            int aveLongTermSlipRateEstId = this.estimateInstancesDAO.addEstimateInstance(slipRateEst);
            columnNames = columnNames + "Ave_Long_Term_Slip_Rate_Est=" + aveLongTermSlipRateEstId + ",";
        } else {
            columnNames = columnNames + "Ave_Long_Term_Slip_Rate_Est=NULL,";
        }
        EstimateInstances aveRakeEst = faultSection.getAveRakeEst();
        if (aveRakeEst != null) {
            int aveRakeEstId = this.estimateInstancesDAO.addEstimateInstance(aveRakeEst);
            columnNames = columnNames + "Ave_Rake_Est=" + aveRakeEstId + ",";
        } else {
            columnNames = columnNames + "Ave_Rake_Est=NULL,";
        }
        float dipDirection = faultSection.getDipDirection();
        columnNames = !Float.isNaN(dipDirection) ? columnNames + "Dip_Direction=" + dipDirection + "," : columnNames + "Dip_Direction=NULL,";
        String qfaultId = faultSection.getQFaultId();
        columnNames = qfaultId != null ? columnNames + "QFault_Id='" + qfaultId + "'," : columnNames + "QFault_Id=NULL,";
        String shortName = faultSection.getShortName();
        columnNames = shortName != null ? columnNames + "Short_Name='" + shortName + "'," : columnNames + "Short_Name=NULL,";
        ArrayList<JGeometry> geomteryObjectList = new ArrayList<JGeometry>();
        geomteryObjectList.add(faultSectionTraceGeom);
        String sql = "update Fault_Section set " + columnNames + AVE_DIP_EST + "=" + aveDipEst + "," + AVE_UPPER_DEPTH_EST + "=" + aveUpperDepthEst + "," + AVE_LOWER_DEPTH_EST + "=" + aveLowerDepthEst + "," + CONTRIBUTOR_ID + "=" + SessionInfo.getContributor().getId() + "," + SECTION_NAME + "='" + faultSection.getSectionName() + "'," + ENTRY_DATE + "='" + systemDate + "'," + COMMENTS + "='" + faultSection.getComments() + "'," + FAULT_TRACE + "=?," + ASEISMIC_SLIP_FACTOR_EST + "=" + aseismicSlipFactorEst + "," + SECTION_SOURCE_ID + "=" + sectionSourceId + " where " + SECTION_ID + "=" + faultSection.getSectionId();
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql, geomteryObjectList);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public void updateDipDirection(int faultSectionId, float dipDirection) {
        String sql = "update Fault_Section set Dip_Direction=" + dipDirection + " where " + SECTION_ID + "=" + faultSectionId;
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public FaultSectionData getFaultSection(int faultSectionId) {
        String condition = " where Section_Id=" + faultSectionId;
        ArrayList faultSectionsList = this.query(condition);
        FaultSectionData faultSection = null;
        if (faultSectionsList.size() > 0) {
            faultSection = (FaultSectionData)faultSectionsList.get(0);
        }
        return faultSection;
    }

    public ArrayList getAllFaultSections() {
        return this.query(" ");
    }

    public ArrayList getAllFaultSectionsSummary() {
        return this.getSummary("");
    }

    public FaultSectionSummary getFaultSectionSummary(int faultSectionId) {
        ArrayList faultSectionSummaryList = this.getSummary(" where Section_Id=" + faultSectionId);
        FaultSectionSummary faultSectionSummary = null;
        if (faultSectionSummaryList.size() > 0) {
            faultSectionSummary = (FaultSectionSummary)faultSectionSummaryList.get(0);
        }
        return faultSectionSummary;
    }

    public FaultSectionSummary getFaultSectionSummary(String faultSectionName) {
        ArrayList faultSectionSummaryList = this.getSummary(" where Name='" + faultSectionName + "'");
        FaultSectionSummary faultSectionSummary = null;
        if (faultSectionSummaryList.size() > 0) {
            faultSectionSummary = (FaultSectionSummary)faultSectionSummaryList.get(0);
        }
        return faultSectionSummary;
    }

    private ArrayList getSummary(String condition) {
        ArrayList<FaultSectionSummary> faultSectionsSummaryList = new ArrayList<FaultSectionSummary>();
        String sql = "select Section_Id,Name from Fault_Section " + condition + " order by (" + SECTION_NAME + ")";
        try {
            CachedRowSetImpl rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                FaultSectionSummary faultSectionSummary = new FaultSectionSummary();
                faultSectionSummary.setSectionId(rs.getInt(SECTION_ID));
                faultSectionSummary.setSectionName(rs.getString(SECTION_NAME));
                faultSectionsSummaryList.add(faultSectionSummary);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionsSummaryList;
    }

    public HashMap getSlipRateEstimates() {
        HashMap<Integer, EstimateInstances> sectionSlipRate = new HashMap<Integer, EstimateInstances>();
        try {
            String sql = "select Section_Id,Ave_Long_Term_Slip_Rate_Est from Fault_Section";
            CachedRowSetImpl rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                EstimateInstances slipRateEstInstance = null;
                int slipRateEstId = rs.getInt(AVE_LONG_TERM_SLIP_RATE_EST);
                if (!rs.wasNull()) {
                    slipRateEstInstance = this.estimateInstancesDAO.getEstimateInstance(slipRateEstId);
                }
                sectionSlipRate.put(new Integer(rs.getInt(SECTION_ID)), slipRateEstInstance);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sectionSlipRate;
    }

    private ArrayList query(String condition) {
        ArrayList<FaultSectionData> faultSectionsList = new ArrayList<FaultSectionData>();
        String sqlWithSpatialColumnNames = "select Section_Id,to_char(Entry_Date) as Entry_Date,Ave_Long_Term_Slip_Rate_Est,Ave_Dip_Est,Ave_Rake_Est,Ave_Upper_Depth_Est,Ave_Lower_Depth_Est,Name,Comments,Fault_Section_Trace,Average_Aseismic_Slip_Est,(Dip_Direction+0) Dip_Direction,Section_Source_Id,QFault_Id,Short_Name from Fault_Section" + condition;
        String sqlWithNoSpatialColumnNames = "select Section_Id,to_char(Entry_Date) as Entry_Date,Ave_Long_Term_Slip_Rate_Est,Ave_Dip_Est,Ave_Rake_Est,Ave_Upper_Depth_Est,Ave_Lower_Depth_Est,Name,Comments,Average_Aseismic_Slip_Est,(Dip_Direction+0) Dip_Direction,Section_Source_Id,QFault_Id,Short_Name from Fault_Section" + condition;
        ArrayList<String> spatialColumnNames = new ArrayList<String>();
        spatialColumnNames.add(FAULT_TRACE);
        try {
            SpatialQueryResult spatialQueryResult = this.dbAccess.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
            CachedRowSetImpl rs = spatialQueryResult.getCachedRowSet();
            int i = 0;
            while (rs.next()) {
                FaultSectionData faultSection = new FaultSectionData();
                faultSection.setSectionId(rs.getInt(SECTION_ID));
                faultSection.setComments(rs.getString(COMMENTS));
                faultSection.setEntryDate(rs.getString(ENTRY_DATE));
                faultSection.setSectionName(rs.getString(SECTION_NAME));
                faultSection.setSource(this.sectionSourceDAO.getSectionSource(rs.getInt(SECTION_SOURCE_ID)).getSectionSourceName());
                faultSection.setAseismicSlipFactorEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(ASEISMIC_SLIP_FACTOR_EST)));
                faultSection.setAveDipEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(AVE_DIP_EST)));
                int slipRateEstId = rs.getInt(AVE_LONG_TERM_SLIP_RATE_EST);
                if (!rs.wasNull()) {
                    faultSection.setAveLongTermSlipRateEst(this.estimateInstancesDAO.getEstimateInstance(slipRateEstId));
                }
                int rakeEstId = rs.getInt(AVE_RAKE_EST);
                if (!rs.wasNull()) {
                    faultSection.setAveRakeEst(this.estimateInstancesDAO.getEstimateInstance(rakeEstId));
                }
                float dipDirection = rs.getFloat(DIP_DIRECTION);
                if (rs.wasNull()) {
                    dipDirection = Float.NaN;
                }
                faultSection.setDipDirection(dipDirection);
                faultSection.setAveLowerDepthEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(AVE_LOWER_DEPTH_EST)));
                faultSection.setAveUpperDepthEst(this.estimateInstancesDAO.getEstimateInstance(rs.getInt(AVE_UPPER_DEPTH_EST)));
                String sectionName = faultSection.getSectionName();
                double upperDepth = ((MinMaxPrefEstimate)faultSection.getAveUpperDepthEst().getEstimate()).getPreferred();
                ArrayList geometries = spatialQueryResult.getGeometryObjectsList(i++);
                FaultTrace faultTrace = FaultSectionVer2_DB_DAO.getFaultTrace(sectionName, upperDepth, geometries);
                faultSection.setFaultTrace(faultTrace);
                String qFaultId = rs.getString(QFAULT_ID);
                if (!rs.wasNull()) {
                    faultSection.setQFaultId(qFaultId);
                }
                String shortName = rs.getString(SHORT_NAME);
                if (!rs.wasNull()) {
                    faultSection.setShortName(shortName);
                }
                faultSectionsList.add(faultSection);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionsList;
    }

    public static FaultTrace getFaultTrace(String sectionName, double upperDepth, ArrayList geometries) {
        JGeometry faultSectionGeom = (JGeometry)geometries.get(0);
        FaultTrace faultTrace = new FaultTrace(sectionName);
        int numPoints = faultSectionGeom.getNumPoints();
        double[] ordinatesArray = faultSectionGeom.getOrdinatesArray();
        for (int j = 0; j < numPoints; ++j) {
            faultTrace.addLocation(new Location(ordinatesArray[2 * j + 1], ordinatesArray[2 * j], upperDepth));
        }
        return faultTrace;
    }

    public static JGeometry getGeomtery(FaultTrace faultTrace) {
        int numLocations = faultTrace.getNumLocations();
        Object[] coords = new Object[numLocations];
        for (int j = 0; j < numLocations; ++j) {
            Location loc = faultTrace.getLocationAt(j);
            double[] d = new double[]{loc.getLongitude(), loc.getLatitude()};
            coords[j] = d;
        }
        return JGeometry.createMultiPoint((Object[])coords, (int)2, (int)8307);
    }

    public void removeFaultSection(int faultSectionId) {
        String sql = "delete from Fault_Section where Section_Id=" + faultSectionId;
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }
}

