/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.LogNormalEstimate;
import org.opensha.refFaultParamDb.dao.EstimateDAO_API;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.LogTypeDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;

public class LogNormalEstimateDB_DAO
implements EstimateDAO_API {
    private static final String TABLE_NAME = "Log_Normal_Est";
    private static final String EST_ID = "Est_Id";
    private static final String MEDIAN = "Median";
    private static final String STD_DEV = "Std_Dev";
    private static final String LOG_TYPE_ID = "Log_Type_Id";
    private static final String MIN_X = "Min_X";
    private static final String MAX_X = "Max_X";
    private DB_AccessAPI dbAccessAPI;
    public static final String EST_TYPE_NAME = "LogNormalEstimate";
    private static final String ERR_MSG = "This class just deals with Log Normal Estimates";
    private LogTypeDB_DAO logTypeDB_DAO;

    public LogNormalEstimateDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public LogNormalEstimateDB_DAO() {
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
        this.logTypeDB_DAO = new LogTypeDB_DAO(dbAccessAPI);
    }

    public void addEstimate(int estimateInstanceId, Estimate estimate) throws InsertException {
        double maxX;
        if (!(estimate instanceof LogNormalEstimate)) {
            throw new InsertException(ERR_MSG);
        }
        LogNormalEstimate logNormalEstimate = (LogNormalEstimate)estimate;
        int logTypeId = logNormalEstimate.getIsBase10() ? this.logTypeDB_DAO.getLogTypeId("10") : this.logTypeDB_DAO.getLogTypeId("E");
        String colNames = "";
        String colVals = "";
        double minX = logNormalEstimate.getMin();
        if (minX != 0.0) {
            colNames = colNames + "Min_X,";
            colVals = colVals + minX + ",";
        }
        if (!Double.isInfinite(maxX = logNormalEstimate.getMax())) {
            colNames = colNames + "Max_X,";
            colVals = colVals + maxX + ",";
        }
        String sql = "insert into Log_Normal_Est(Est_Id," + colNames + MEDIAN + "," + STD_DEV + "," + LOG_TYPE_ID + ")" + " values (" + estimateInstanceId + "," + colVals + logNormalEstimate.getLinearMedian() + "," + estimate.getStdDev() + "," + logTypeId + ")";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public Estimate getEstimate(int estimateInstanceId) throws QueryException {
        LogNormalEstimate estimate = null;
        String condition = " where Est_Id=" + estimateInstanceId;
        ArrayList estimateList = this.query(condition);
        if (estimateList.size() > 0) {
            estimate = (LogNormalEstimate)estimateList.get(0);
        }
        return estimate;
    }

    public boolean removeEstimate(int estimateInstanceId) throws UpdateException {
        String sql = "delete from Log_Normal_Est  where Est_Id=" + estimateInstanceId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public String getEstimateTypeName() {
        return EST_TYPE_NAME;
    }

    private ArrayList query(String condition) throws QueryException {
        ArrayList<LogNormalEstimate> estimateList = new ArrayList<LogNormalEstimate>();
        String sql = "select Est_Id,(Median+0) Median,(Min_X+0) Min_X,(Max_X+0) Max_X,(Std_Dev+0) Std_Dev,Log_Type_Id from Log_Normal_Est " + condition;
        try {
            CachedRowSetImpl rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                LogNormalEstimate estimate = new LogNormalEstimate(rs.getFloat(MEDIAN), rs.getFloat(STD_DEV));
                String logBase = this.logTypeDB_DAO.getLogBase(rs.getInt(LOG_TYPE_ID));
                if (logBase.equalsIgnoreCase("10")) {
                    estimate.setIsBase10(true);
                } else {
                    estimate.setIsBase10(false);
                }
                double minX = rs.getFloat(MIN_X);
                if (rs.wasNull()) {
                    minX = 0.0;
                }
                double maxX = rs.getFloat(MAX_X);
                if (rs.wasNull()) {
                    maxX = Double.POSITIVE_INFINITY;
                }
                estimate.setMinMax(minX, maxX);
                estimateList.add(estimate);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return estimateList;
    }
}

