/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.spatial.geometry.JGeometry;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.ServerDB_Access;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefFaultSectionDataDB_DAO
implements Serializable {
    private static final String TABLE_NAME = "Pref_Fault_Section_Data";
    public static final String SECTION_ID = "Section_Id";
    public static final String PREF_SLIP_RATE = "Pref_Slip_Rate";
    public static final String PREF_DIP = "Pref_Dip";
    public static final String PREF_RAKE = "Pref_Rake";
    public static final String PREF_UPPER_DEPTH = "Pref_Upper_Depth";
    public static final String PREF_LOWER_DEPTH = "Pref_Lower_Depth";
    public static final String SECTION_NAME = "Name";
    public static final String SHORT_NAME = "Short_Name";
    public static final String FAULT_TRACE = "Fault_Section_Trace";
    public static final String PREF_ASEISMIC_SLIP = "Pref_Aseismic_Slip";
    public static final String DIP_DIRECTION = "Dip_Direction";
    private DB_AccessAPI dbAccess;
    private static HashMap cachedSections = new HashMap();
    private static ArrayList<FaultSectionPrefData> faultSectionsList;

    public PrefFaultSectionDataDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
    }

    public void rePopulatePrefDataTable() {
        FaultSectionVer2_DB_DAO faultSectionVer2DAO = new FaultSectionVer2_DB_DAO(this.dbAccess);
        ArrayList faultSectionsDataList = faultSectionVer2DAO.getAllFaultSections();
        this.removeAll();
        for (int i = 0; i < faultSectionsDataList.size(); ++i) {
            FaultSectionData faultSection = (FaultSectionData)faultSectionsDataList.get(i);
            this.addFaultSectionPrefData(faultSection.getFaultSectionPrefData());
        }
    }

    public void rePopulatePrefDataTable(int faultSectionId) {
        FaultSectionVer2_DB_DAO faultSectionVer2DAO = new FaultSectionVer2_DB_DAO(this.dbAccess);
        FaultSectionData faultSectionData = faultSectionVer2DAO.getFaultSection(faultSectionId);
        this.removeFaultSection(faultSectionId);
        this.addFaultSectionPrefData(faultSectionData.getFaultSectionPrefData());
    }

    private void addFaultSectionPrefData(FaultSectionPrefData faultSectionPrefData) {
        String shortName;
        float dipDirection;
        double rake;
        JGeometry faultSectionTraceGeom = FaultSectionVer2_DB_DAO.getGeomtery(faultSectionPrefData.getFaultTrace());
        String columnNames = "";
        String columnVals = "";
        double slipRate = faultSectionPrefData.getAveLongTermSlipRate();
        if (!Double.isNaN(slipRate)) {
            columnNames = columnNames + "Pref_Slip_Rate,";
            columnVals = columnVals + slipRate + ",";
        }
        if (!Double.isNaN(rake = faultSectionPrefData.getAveRake())) {
            columnNames = columnNames + "Pref_Rake,";
            columnVals = columnVals + rake + ",";
        }
        if (!Float.isNaN(dipDirection = faultSectionPrefData.getDipDirection())) {
            columnNames = columnNames + "Dip_Direction,";
            columnVals = columnVals + dipDirection + ",";
        }
        if ((shortName = faultSectionPrefData.getShortName()) != null) {
            columnNames = columnNames + "Short_Name,";
            columnVals = columnVals + "'" + shortName + "',";
        }
        ArrayList<JGeometry> geomteryObjectList = new ArrayList<JGeometry>();
        geomteryObjectList.add(faultSectionTraceGeom);
        String sql = "insert into Pref_Fault_Section_Data(Section_Id," + columnNames + PREF_DIP + "," + PREF_UPPER_DEPTH + "," + PREF_LOWER_DEPTH + "," + SECTION_NAME + "," + FAULT_TRACE + "," + PREF_ASEISMIC_SLIP + ") values (" + faultSectionPrefData.getSectionId() + "," + columnVals + faultSectionPrefData.getAveDip() + "," + faultSectionPrefData.getAveUpperDepth() + "," + faultSectionPrefData.getAveLowerDepth() + ",'" + faultSectionPrefData.getSectionName() + "',?," + faultSectionPrefData.getAseismicSlipFactor() + ")";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql, geomteryObjectList);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    private void removeAll() {
        String sql = "delete from Pref_Fault_Section_Data";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    private void removeFaultSection(int faultSectionId) {
        String sql = "delete from Pref_Fault_Section_Data where Section_Id=" + faultSectionId;
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public ArrayList getAllFaultSectionPrefData() {
        if (faultSectionsList == null) {
            faultSectionsList = this.query("");
        }
        return faultSectionsList;
    }

    public FaultSectionPrefData getFaultSectionPrefData(int faultSectionId) {
        String condition = " where Section_Id=" + faultSectionId;
        if (cachedSections.containsKey(new Integer(faultSectionId))) {
            return (FaultSectionPrefData)cachedSections.get(new Integer(faultSectionId));
        }
        ArrayList<FaultSectionPrefData> faultSectionsList = this.query(condition);
        FaultSectionPrefData faultSectionPrefData = null;
        if (faultSectionsList.size() > 0) {
            faultSectionPrefData = faultSectionsList.get(0);
        }
        return faultSectionPrefData;
    }

    private ArrayList<FaultSectionPrefData> query(String condition) {
        ArrayList<FaultSectionPrefData> faultSectionsList = new ArrayList<FaultSectionPrefData>();
        String sqlWithSpatialColumnNames = "select Section_Id, (Pref_Slip_Rate+0) Pref_Slip_Rate, (Pref_Dip+0) Pref_Dip, (Pref_Rake+0) Pref_Rake, (Pref_Upper_Depth+0) Pref_Upper_Depth, (Pref_Lower_Depth+0) Pref_Lower_Depth,Name,Fault_Section_Trace,Short_Name,(Pref_Aseismic_Slip+0) Pref_Aseismic_Slip,(Dip_Direction+0) Dip_Direction from Pref_Fault_Section_Data" + condition + " order by " + SECTION_NAME;
        String sqlWithNoSpatialColumnNames = "select Section_Id, (Pref_Slip_Rate+0) Pref_Slip_Rate, (Pref_Dip+0) Pref_Dip, (Pref_Rake+0) Pref_Rake, (Pref_Upper_Depth+0) Pref_Upper_Depth, (Pref_Lower_Depth+0) Pref_Lower_Depth,Name,Short_Name,(Pref_Aseismic_Slip+0) Pref_Aseismic_Slip,(Dip_Direction+0) Dip_Direction from Pref_Fault_Section_Data" + condition + " order by " + SECTION_NAME;
        ArrayList<String> spatialColumnNames = new ArrayList<String>();
        spatialColumnNames.add(FAULT_TRACE);
        try {
            SpatialQueryResult spatialQueryResult = this.dbAccess.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
            CachedRowSetImpl rs = spatialQueryResult.getCachedRowSet();
            int i = 0;
            while (rs.next()) {
                FaultSectionPrefData faultSectionPrefData = new FaultSectionPrefData();
                faultSectionPrefData.setSectionId(rs.getInt(SECTION_ID));
                faultSectionPrefData.setSectionName(rs.getString(SECTION_NAME));
                faultSectionPrefData.setAseismicSlipFactor(rs.getFloat(PREF_ASEISMIC_SLIP));
                faultSectionPrefData.setAveDip(rs.getFloat(PREF_DIP));
                double slipRate = rs.getFloat(PREF_SLIP_RATE);
                if (rs.wasNull()) {
                    slipRate = Double.NaN;
                }
                faultSectionPrefData.setAveLongTermSlipRate(slipRate);
                double rake = rs.getFloat(PREF_RAKE);
                if (rs.wasNull()) {
                    rake = Double.NaN;
                }
                faultSectionPrefData.setAveRake(rake);
                float dipDirection = rs.getFloat(DIP_DIRECTION);
                if (rs.wasNull()) {
                    dipDirection = Float.NaN;
                }
                faultSectionPrefData.setDipDirection(dipDirection);
                faultSectionPrefData.setAveLowerDepth(rs.getFloat(PREF_LOWER_DEPTH));
                faultSectionPrefData.setAveUpperDepth(rs.getFloat(PREF_UPPER_DEPTH));
                String sectionName = faultSectionPrefData.getSectionName();
                String shortName = rs.getString(SHORT_NAME);
                if (!rs.wasNull()) {
                    faultSectionPrefData.setShortName(shortName);
                }
                ArrayList geometries = spatialQueryResult.getGeometryObjectsList(i++);
                FaultTrace faultTrace = FaultSectionVer2_DB_DAO.getFaultTrace(sectionName, faultSectionPrefData.getAveUpperDepth(), geometries);
                faultSectionPrefData.setFaultTrace(faultTrace);
                faultSectionsList.add(faultSectionPrefData);
                cachedSections.put(new Integer(faultSectionPrefData.getSectionId()), faultSectionPrefData);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionsList;
    }

    public static void main(String[] args) {
        ServerDB_Access dbAccessAPI = new ServerDB_Access();
        SessionInfo.setUserName(args[0]);
        SessionInfo.setPassword(args[1]);
        SessionInfo.setContributorInfo();
        PrefFaultSectionDataDB_DAO prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(dbAccessAPI);
        prefFaultSectionDAO.rePopulatePrefDataTable();
        System.exit(0);
    }

    public double getMaxSlipRate() {
        String sql = "select max(Pref_Slip_Rate) from Pref_Fault_Section_Data";
        double maxSlipRate = 0.0;
        try {
            CachedRowSetImpl rs = this.dbAccess.queryData(sql);
            rs.next();
            maxSlipRate = rs.getFloat(0);
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return maxSlipRate;
    }

    public double getMinSlipRate() {
        String sql = "select min(Pref_Slip_Rate) from Pref_Fault_Section_Data";
        double minSlipRate = 0.0;
        try {
            CachedRowSetImpl rs = this.dbAccess.queryData(sql);
            rs.next();
            minSlipRate = rs.getFloat(0);
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return minSlipRate;
    }
}

