/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.vo;

import org.opensha.commons.data.estimate.DiscreteValueEstimate;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultTrace;

public class FaultSectionData {
    private int sectionId = -1;
    private String sectionName;
    private String shortName;
    private EstimateInstances aveLongTermSlipRateEst;
    private EstimateInstances aveDipEst;
    private EstimateInstances aveRakeEst;
    private EstimateInstances aveUpperDepthEst;
    private EstimateInstances aveLowerDepthEst;
    private EstimateInstances aseismicSlipFactorEst;
    private String entryDate;
    private String source;
    private String comments = "";
    private FaultTrace faultTrace;
    private float dipDirection;
    private String qFaultId;

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getQFaultId() {
        return this.qFaultId;
    }

    public void setQFaultId(String qfaultId) {
        this.qFaultId = qfaultId;
    }

    public EstimateInstances getAseismicSlipFactorEst() {
        return this.aseismicSlipFactorEst;
    }

    public EstimateInstances getAveDipEst() {
        return this.aveDipEst;
    }

    public EstimateInstances getAveLongTermSlipRateEst() {
        return this.aveLongTermSlipRateEst;
    }

    public EstimateInstances getAveLowerDepthEst() {
        return this.aveLowerDepthEst;
    }

    public EstimateInstances getAveRakeEst() {
        return this.aveRakeEst;
    }

    public EstimateInstances getAveUpperDepthEst() {
        return this.aveUpperDepthEst;
    }

    public String getComments() {
        return this.comments;
    }

    public float getDipDirection() {
        return this.dipDirection;
    }

    public String getEntryDate() {
        return this.entryDate;
    }

    public FaultTrace getFaultTrace() {
        return this.faultTrace;
    }

    public int getSectionId() {
        return this.sectionId;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public void setSectionId(int sectionId) {
        this.sectionId = sectionId;
    }

    public void setFaultTrace(FaultTrace faultTrace) {
        this.faultTrace = faultTrace;
    }

    public void setEntryDate(String entryDate) {
        this.entryDate = entryDate;
    }

    public void setDipDirection(float dipDirection) {
        this.dipDirection = dipDirection;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setAveUpperDepthEst(EstimateInstances aveUpperDepthEst) {
        this.aveUpperDepthEst = aveUpperDepthEst;
    }

    public void setAveRakeEst(EstimateInstances aveRakeEst) {
        this.aveRakeEst = aveRakeEst;
    }

    public void setAveLowerDepthEst(EstimateInstances aveLowerDepthEst) {
        this.aveLowerDepthEst = aveLowerDepthEst;
    }

    public void setAveLongTermSlipRateEst(EstimateInstances aveLongTermSlipRateEst) {
        this.aveLongTermSlipRateEst = aveLongTermSlipRateEst;
    }

    public void setAveDipEst(EstimateInstances aveDipEst) {
        this.aveDipEst = aveDipEst;
    }

    public void setAseismicSlipFactorEst(EstimateInstances aseismicSlipFactorEst) {
        this.aseismicSlipFactorEst = aseismicSlipFactorEst;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public FaultSectionPrefData getFaultSectionPrefData() {
        FaultSectionPrefData faultSectionPrefData = new FaultSectionPrefData();
        faultSectionPrefData.setAseismicSlipFactor(FaultSectionData.getPrefForEstimate(this.aseismicSlipFactorEst));
        faultSectionPrefData.setAveDip(FaultSectionData.getPrefForEstimate(this.aveDipEst));
        faultSectionPrefData.setSlipRateStdDev(this.getSlipRateStdDev(this.aveLongTermSlipRateEst));
        faultSectionPrefData.setAveLongTermSlipRate(FaultSectionData.getPrefForEstimate(this.aveLongTermSlipRateEst));
        faultSectionPrefData.setAveLowerDepth(FaultSectionData.getPrefForEstimate(this.aveLowerDepthEst));
        faultSectionPrefData.setAveRake(FaultSectionData.getPrefForEstimate(this.aveRakeEst));
        faultSectionPrefData.setAveUpperDepth(FaultSectionData.getPrefForEstimate(this.aveUpperDepthEst));
        faultSectionPrefData.setDipDirection(this.dipDirection);
        faultSectionPrefData.setSectionId(this.sectionId);
        faultSectionPrefData.setSectionName(this.sectionName);
        faultSectionPrefData.setShortName(this.shortName);
        faultSectionPrefData.setFaultTrace(this.faultTrace);
        return faultSectionPrefData;
    }

    private double getSlipRateStdDev(EstimateInstances estimateInstance) {
        if (estimateInstance == null) {
            return Double.NaN;
        }
        Estimate estimate = estimateInstance.getEstimate();
        if (estimate instanceof NormalEstimate) {
            return ((NormalEstimate)estimate).getStdDev();
        }
        return Double.NaN;
    }

    public static double getPrefForEstimate(EstimateInstances estimateInstance) {
        if (estimateInstance == null) {
            return Double.NaN;
        }
        Estimate estimate = estimateInstance.getEstimate();
        if (estimate instanceof MinMaxPrefEstimate) {
            return ((MinMaxPrefEstimate)estimate).getPreferred();
        }
        if (estimate instanceof NormalEstimate) {
            return ((NormalEstimate)estimate).getMean();
        }
        if (estimate instanceof DiscreteValueEstimate) {
            DiscreteValueEstimate discValEst = (DiscreteValueEstimate)estimate;
            return discValEst.getMean();
        }
        throw new RuntimeException("FaultSectionData: Unable to handle this estimate type");
    }
}

