/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import org.opensha.commons.data.Location;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;

public class ProbEqkRupture
extends EqkRupture {
    protected double probability;
    private int rupIndex;
    private int srcIndex;
    private String srcName;

    public ProbEqkRupture() {
    }

    public ProbEqkRupture(double mag, double aveRake, double probability, EvenlyGriddedSurfaceAPI ruptureSurface, Location hypocenterLocation) throws InvalidRangeException {
        super(mag, aveRake, ruptureSurface, hypocenterLocation);
        this.probability = probability;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double p) {
        this.probability = p;
    }

    public double getMeanAnnualRate(double duration) {
        return -Math.log(1.0 - this.probability) / duration;
    }

    public String getInfo() {
        String info2;
        String info1 = new String("\tMag. = " + (float)this.mag + "\n" + "\tAve. Rake = " + (float)this.aveRake + "\n" + "\tProb. = " + (float)this.probability + "\n" + "\tAve. Dip = " + (float)this.ruptureSurface.getAveDip() + "\n" + "\tHypocenter = " + this.hypocenterLocation + "\n");
        if (this.ruptureSurface.getNumCols() == 1 && this.ruptureSurface.getNumRows() == 1) {
            Location loc = this.ruptureSurface.getLocation(0, 0);
            info2 = new String("\tPoint-Surface Location (lat, lon, depth (km):\n\n\t\t" + (float)loc.getLatitude() + ", " + (float)loc.getLongitude() + ", " + (float)loc.getDepth());
        } else {
            Location loc1 = this.ruptureSurface.getLocation(0, 0);
            Location loc2 = this.ruptureSurface.getLocation(0, this.ruptureSurface.getNumCols() - 1);
            Location loc3 = this.ruptureSurface.getLocation(this.ruptureSurface.getNumRows() - 1, 0);
            Location loc4 = this.ruptureSurface.getLocation(this.ruptureSurface.getNumRows() - 1, this.ruptureSurface.getNumCols() - 1);
            info2 = new String("\tRup. Surf. Corner Locations (lat, lon, depth (km):\n\n\t\t" + (float)loc1.getLatitude() + ", " + (float)loc1.getLongitude() + ", " + (float)loc1.getDepth() + "\n" + "\t\t" + (float)loc2.getLatitude() + ", " + (float)loc2.getLongitude() + ", " + (float)loc2.getDepth() + "\n" + "\t\t" + (float)loc3.getLatitude() + ", " + (float)loc3.getLongitude() + ", " + (float)loc3.getDepth() + "\n" + "\t\t" + (float)loc4.getLatitude() + ", " + (float)loc4.getLongitude() + ", " + (float)loc4.getDepth() + "\n");
        }
        return info1 + info2;
    }

    public void setRuptureIndexAndSourceInfo(int sourceIndex, String sourceName, int ruptureIndex) {
        this.srcIndex = sourceIndex;
        this.srcName = sourceName;
        this.rupIndex = ruptureIndex;
    }

    public int getRuptureIndex() {
        return this.rupIndex;
    }

    public String getRuptureMetadata() {
        String ruptureMetadata = this.srcIndex + "\t";
        ruptureMetadata = ruptureMetadata + this.rupIndex + "\t";
        ruptureMetadata = ruptureMetadata + (float)this.mag + "\t";
        ruptureMetadata = ruptureMetadata + (float)this.probability + "\t";
        ruptureMetadata = ruptureMetadata + (float)this.aveRake + "\t";
        ruptureMetadata = ruptureMetadata + (float)this.ruptureSurface.getAveDip() + "\t";
        ruptureMetadata = ruptureMetadata + "\"" + this.srcName + "\"";
        return ruptureMetadata;
    }

    public Object clone() {
        ProbEqkRupture eqkRuptureClone = new ProbEqkRupture();
        eqkRuptureClone.setAveRake(this.aveRake);
        eqkRuptureClone.setMag(this.mag);
        eqkRuptureClone.setRuptureSurface(this.ruptureSurface);
        eqkRuptureClone.setHypocenterLocation(this.hypocenterLocation);
        eqkRuptureClone.setProbability(this.probability);
        return eqkRuptureClone;
    }
}

