/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval;

import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.calc.recurInterval.EqkProbDistCalc;

public final class BPT_DistCalc
extends EqkProbDistCalc
implements ParameterChangeListener {
    public BPT_DistCalc() {
        this.NAME = "BPT";
        this.mkAdjParamList();
    }

    public void setAll(double mean, double aperiodicity, double deltaX, int numPoints) {
        this.mean = mean;
        this.aperiodicity = aperiodicity;
        this.deltaX = deltaX;
        this.numPoints = numPoints;
        this.upToDate = false;
    }

    public void setAll(double mean, double aperiodicity, double deltaX, int numPoints, double duration) {
        this.mean = mean;
        this.aperiodicity = aperiodicity;
        this.deltaX = deltaX;
        this.numPoints = numPoints;
        this.duration = duration;
        this.upToDate = false;
    }

    public void setAll(double mean, double aperiodicity) {
        this.mean = mean;
        this.aperiodicity = aperiodicity;
        this.deltaX = 0.001 * mean;
        this.numPoints = (int)Math.round(aperiodicity * 10.0 * mean / this.deltaX) + 1;
        this.upToDate = false;
    }

    protected void computeDistributions() {
        this.pdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.cdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.pdf.set(0, 0.0);
        this.cdf.set(0, 0.0);
        double temp1 = this.mean / (Math.PI * 2 * (this.aperiodicity * this.aperiodicity));
        double temp2 = 2.0 * this.mean * (this.aperiodicity * this.aperiodicity);
        double cd = 0.0;
        for (int i = 1; i < this.pdf.getNum(); ++i) {
            double t = this.cdf.getX(i);
            double pd = Math.sqrt(temp1 / (t * t * t)) * Math.exp(-(t - this.mean) * (t - this.mean) / (temp2 * t));
            if (Double.isNaN(pd)) {
                pd = 0.0;
                System.out.println("pd=0 for i=" + i);
            }
            this.pdf.set(i, pd);
            this.cdf.set(i, cd += this.deltaX * (pd + this.pdf.getY(i - 1)) / 2.0);
        }
        this.upToDate = true;
    }

    public static double getCondProb(double mean, double aperiodicity, double timeSinceLast, double duration) {
        double step = 0.001;
        double cdf = 0.0;
        double pdf_last = 0.0;
        double cBPT1 = 0.0;
        double x = timeSinceLast / mean > aperiodicity * 10.0 ? 10.0 * aperiodicity * mean : timeSinceLast;
        int i1 = Math.round((float)(x / mean / step));
        int i2 = Math.round((float)((x + duration) / mean / step));
        double temp1 = 1.0 / (Math.PI * 2 * (aperiodicity * aperiodicity));
        double temp2 = 2.0 * (aperiodicity * aperiodicity) * 1.0;
        double t = step * 1.0;
        for (int i = 1; i <= i2; ++i) {
            double pdf = Math.sqrt(temp1 / (t * t * t)) * Math.exp(-(t - 1.0) * (t - 1.0) / (temp2 * t));
            cdf += step * (pdf + pdf_last) / 2.0;
            if (i == i1) {
                cBPT1 = cdf;
            }
            t += step;
            pdf_last = pdf;
        }
        double cBPT2 = cdf;
        if (cBPT1 >= 1.0) {
            return Double.NaN;
        }
        return (cBPT2 - cBPT1) / (1.0 - cBPT1);
    }

    private void mkAdjParamList() {
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.meanParam);
        this.adjustableParams.addParameter(this.aperiodicityParam);
        this.adjustableParams.addParameter(this.durationParam);
        this.adjustableParams.addParameter(this.deltaX_Param);
        this.adjustableParams.addParameter(this.numPointsParam);
        this.setAll(DEFAULT_MEAN_PARAM_VAL, DEFAULT_APERIODICITY_PARAM_VAL, DEFAULT_DELTAX_PARAM_VAL, DEFAULT_NUMPOINTS_PARAM_VAL, DEFAULT_DURATION_PARAM_VAL);
    }

    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase("Mean")) {
            this.mean = (Double)this.meanParam.getValue();
        } else if (paramName.equalsIgnoreCase("Aperiodicity")) {
            this.aperiodicity = (Double)this.aperiodicityParam.getValue();
        } else if (paramName.equalsIgnoreCase("Duration")) {
            this.duration = (Double)this.durationParam.getValue();
        } else if (paramName.equalsIgnoreCase("Delta X")) {
            this.deltaX = (Double)this.deltaX_Param.getValue();
        } else if (paramName.equalsIgnoreCase("Num Points")) {
            this.numPoints = (Integer)this.numPointsParam.getValue();
        }
        this.upToDate = false;
    }

    public static void main(String[] args) {
        double p;
        double timeSinceLast = 96.0;
        double nYr = 30.0;
        double alph = 0.5;
        double[] rate = new double[]{0.00466746464, 0.00432087015, 0.004199435, 0.004199435};
        double[] prob = new double[]{0.130127236, 0.105091952, 0.0964599401, 0.0964599401};
        double[] static_prob = new double[rate.length];
        System.out.println("Test1: static-method comparison with probs from WG02 code");
        for (int i = 0; i < rate.length; ++i) {
            p = BPT_DistCalc.getCondProb(1.0 / rate[i], alph, timeSinceLast, nYr);
            System.out.println("Test1 (static): prob=" + (float)p + "; ratio=" + (float)(p / prob[i]));
            static_prob[i] = p;
        }
        BPT_DistCalc calc = new BPT_DistCalc();
        double[] nonStatic_prob = new double[rate.length];
        System.out.println("Test2: non-static method compared to static");
        for (int i = 0; i < rate.length; ++i) {
            calc.setAll(1.0 / rate[i], alph);
            p = calc.getCondProb(timeSinceLast, nYr);
            System.out.println("Test2: prob=" + (float)p + "; ratio=" + (float)(p / static_prob[i]));
            nonStatic_prob[i] = p;
        }
    }
}

