/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.griddedForecast;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.ListIterator;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.EqkRupForecastBaseAPI;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtMultLocsAPI;
import org.opensha.sha.util.TectonicRegionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GriddedHypoMagFreqDistForecast
implements EqkRupForecastBaseAPI,
HypoMagFreqDistAtMultLocsAPI,
ParameterChangeListener {
    private TimeSpan timeSpan;
    private ParameterList adjustableParameters;
    protected boolean parameterChangeFlag = true;
    protected GriddedRegion region;
    private ArrayList listenerList = new ArrayList();

    @Override
    public boolean isLocWithinApplicableRegion(Location loc) {
        return this.region.contains(loc);
    }

    public GriddedRegion getRegion() {
        return this.region;
    }

    public void setRegion(GriddedRegion region) {
        this.region = region;
    }

    @Override
    public Region getApplicableRegion() {
        return this.region;
    }

    @Override
    public ParameterList getAdjustableParameterList() {
        return this.adjustableParameters;
    }

    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParameters.getParametersIterator();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String updateAndSaveForecast() {
        throw new UnsupportedOperationException("updateAndSaveForecast() not supported");
    }

    @Override
    public int getNumHypoLocs() {
        return this.region.getNodeCount();
    }

    public void timeSpanChange(EventObject event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public boolean setParameter(String name, Object value) {
        if (this.getAdjustableParameterList().containsParameter(name)) {
            this.getAdjustableParameterList().getParameter(name).setValue(value);
            return true;
        }
        if (this.timeSpan.getAdjustableParams().containsParameter(name)) {
            this.timeSpan.getAdjustableParams().getParameter(name).setValue(value);
            return true;
        }
        return false;
    }

    @Override
    public void setTimeSpan(TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            // empty if block
        }
    }

    @Override
    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        ArrayList<TectonicRegionType> list = new ArrayList<TectonicRegionType>();
        list.add(TectonicRegionType.ACTIVE_SHALLOW);
        return list;
    }
}

